//-----------------------------------------------------------
//
//-----------------------------------------------------------
class UTProj_VASBioGlob extends UTProj_BioGlob;

var int VolatileAmmoCount;
var int VolatileAmmoDamage;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

    SetTimer(2,false,'EnableCollisionTimer');
	bProjTarget = false;
}

simulated function SplashGloblings()
{
	local int g;
	local UTProj_BioGlobling NewGlob;
	local UTProj_VASBioGlob VasNewGlob;
	local float GlobVolume;
	local Vector VNorm;

    MaxRestingGlobStrength = VolatileAmmoCount/3;

	if ( (GlobStrength > MaxRestingGlobStrength) && (UTPawn(Base) == None) )
	{
		if (Role == ROLE_Authority)
		{
			GlobVolume = Sqrt(GlobStrength);

			for (g=0; g<VolatileAmmoCount; g++)
			    {
			    if ( Rand(100) >= 25 )
			       {
                   NewGlob = Spawn(class'UTProj_BioGlobling', self,, Location+GlobVolume*6*SurfaceNormal);
				   if (NewGlob != None)
				      {
				      NewGlob.Damage = NewGlob.Damage * VolatileAmmoDamage;
					  NewGlob.Velocity = (GloblingSpeed + FRand()*150.0) * (SurfaceNormal + VRand()*0.8);
					  if (Physics == PHYS_Falling)
					     {
						 VNorm = (Velocity dot SurfaceNormal) * SurfaceNormal;
						 NewGlob.Velocity += (-VNorm + (Velocity - VNorm)) * RandRange(0.1,5);
					    }
			         NewGlob.InstigatorController = InstigatorController;
				     }
                   }
			    else
			        {
		            VasNewGlob = Spawn(class'UTProj_VASBioGlob', self,, Location+GlobVolume*6*SurfaceNormal);
		            if (VasNewGlob != None)
                        {
                        VasNewGlob.Velocity = (GloblingSpeed + FRand()*150.0) * (SurfaceNormal + VRand()*0.8);
                        VasNewGlob.Damage=VasNewGlob.Damage * VolatileAmmoDamage;
                        VasNewGlob.VolatileAmmoCount=VolatileAmmoCount/3;
                        VasNewGlob.SetGlobStrength(VolatileAmmoCount/3);
                        g += VolatileAmmoCount/3;
                        VasNewGlob.InstigatorController = InstigatorController;
                        if (Physics == PHYS_Falling)
					       {
					       VNorm = (Velocity dot SurfaceNormal) * SurfaceNormal;
				           VasNewGlob.Velocity += (-VNorm + (Velocity - VNorm)) * RandRange(0.1,5);
				           }
				        }
                    }

			   }
		}
		SetGlobStrength(MaxRestingGlobStrength);
	}
}


simulated function EnableCollisionTimer()
{
	bProjTarget = true;
}


DefaultProperties
{
   MaxRestingGlobStrength=1
   bProjTarget=False
   Name="Default__UTProj_VASBioGlob"
   ObjectArchetype=UTProj_BioGlob'UTGameContent.Default__UTProj_BioGlob'
}