//-----------------------------------------------------------
//   VasAutoShields by Kal Corp
//   KalCorp@Cfl.rr.com
//   Development Forums @ Http://vasserver.dyndns.org:88
//   SVN @ http://vasserver.dyndns.org:81/svn/UT3-VASUT3VolatileAmmo/
//-----------------------------------------------------------
class VAS_UTAmmo_ShockRifle extends UTAmmo_ShockRifle;


var int VolatilePercent;
var int ResetCounter;
var int VolatileAmmoCount;
var int VolatileAmmoHealth;
var int TempVolatileAmmoHealth;
var int CounterforShoot;
var float VolatileAmmoDamage;

var Controller	Vas_Instigator;

var float tempcounter;

var bool bVASInit;
var bool bVASInitShoot;
var bool bVASInitHealth;
var bool bShoot;
var bool bSpwnVolatilePawn;
var bool bhitexplode;




simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

    SetTimer(0.2,true,'VASTimerVolatile');
	bProjTarget = false;
	bVASInit=true;
	CounterforShoot=VolatileAmmoCount;
}

simulated function VASTimerVolatile()
{
    local vector RealStartLoc;
	local Projectile SpawnedProjectile;
	local rotator r;

    if (IsInState('Pickup'))
       {
       bProjTarget=true;
       if (!bVASInit)
          bVASInit=true;
       }

    if (IsInState('Sleeping'))
       {
       bProjTarget=false;
       bVASInit=true;
       TempVolatileAmmoHealth=VolatileAmmoHealth;
       CounterforShoot=VolatileAmmoCount;
       }

     If (bShoot)
        VASSpawnShoot();
     else
        CounterforShoot=VolatileAmmoCount;

     if (bhitexplode)
        {
	    bhitexplode= false;
        RealStartLoc = self.location;
        r = RotRand(true);
        if( Role == ROLE_Authority )
	        {
    	    SpawnedProjectile = Spawn(class'VASUT3VolatileAmmo.UTProj_VASShockBall',,, RealStartLoc,r);
		    if( SpawnedProjectile != None )
		        {
		        UTProj_VASShockBall(SpawnedProjectile).Damage = 0;
     	        UTProj_VASShockBall(SpawnedProjectile).Speed = 10;
		        UTProj_VASShockBall(SpawnedProjectile).Init(vector(r));
		        UTProj_VASShockBall(SpawnedProjectile).LifeSpan=0.1;
                }
            }
        }
}


event TakeDamage( int Damage, Controller EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType, optional TraceHitInfo HitInfo, optional Actor DamageCauser)
{
 if (!bVASInithealth)
    {
    TempVolatileAmmoHealth=VolatileAmmoHealth;
    bVASInithealth = True;
    }

 if (IsInState ('Pickup'))
    {
    Vas_Instigator = EventInstigator;
    if (bVASInit)
       {
       bhitexplode= true;
       TempVolatileAmmoHealth = TempVolatileAmmoHealth-Damage;
       if (TempVolatileAmmoHealth <= 0)
          if( Role == ROLE_Authority )
  	         {
               bShoot=True;
  	           VASSpawnShoot();
  	         }
       }
    }
 }



function VASSpawnExplosion()
{
    local vector RealStartLoc;
	local Projectile SpawnedProjectile;


    if( Role == ROLE_Authority )
	   {
        bShoot = false;
        RealStartLoc = self.location;
    	SpawnedProjectile = Spawn(class'VASUT3VolatileAmmo.UTProj_VASShockBall',,, RealStartLoc);
		if( SpawnedProjectile != None )
		    {
     	    UTProj_VASShockBall(SpawnedProjectile).InstigatorController =  Vas_Instigator;
	        UTProj_VASShockBall(SpawnedProjectile).Damage = UTProj_ShockBall(SpawnedProjectile).Damage * VolatileAmmoDamage;
            UTProj_VASShockBall(SpawnedProjectile).ComboExplosion();
            }
        self.gotostate('Sleeping');
		}
}

function VASSpawnShoot()
{
	local Projectile SpawnedProjectile;
	local rotator r;
	local vector RealStartLoc;


    if( Role == ROLE_Authority )
        {

        bVASInit = false;
	    CounterforShoot = CounterforShoot-1;

        If ((CounterforShoot <= 0) || (rand(100) >= 98))
           {
           bVASInitShoot = False;
           bProjTarget=false;
           VASSpawnExplosion();
           }
        RealStartLoc = self.location;
        if (Rand(100) >= 80)
           {
           r = RotRand(true);
           SpawnedProjectile = Spawn(class'VASUT3VolatileAmmo.UTProj_VASShockBall',,, RealStartLoc, r);
           if( SpawnedProjectile != None )
		       {
     	       UTProj_VASShockBall(SpawnedProjectile).InstigatorController =  Vas_Instigator;
     	       UTProj_VASShockBall(SpawnedProjectile).Speed = 10;
		       UTProj_VASShockBall(SpawnedProjectile).Init(vector(r));
		       UTProj_VASShockBall(SpawnedProjectile).Damage = UTProj_ShockBall(SpawnedProjectile).Damage * VolatileAmmoDamage;
		       UTProj_VASShockBall(SpawnedProjectile).LifeSpan=0.1;
               }
           }
        r = RotRand(true);
        SpawnedProjectile = Spawn(class'VASUT3VolatileAmmo.UTProj_VASShockBall',,, RealStartLoc, r);
        if( SpawnedProjectile != None )
		    {
     	    UTProj_VASShockBall(SpawnedProjectile).InstigatorController =  Vas_Instigator;
     	    UTProj_VASShockBall(SpawnedProjectile).Speed = 100 + Rand(600);
		    UTProj_VASShockBall(SpawnedProjectile).Init(vector(r));
		    UTProj_VASShockBall(SpawnedProjectile).Damage = UTProj_ShockBall(SpawnedProjectile).Damage * VolatileAmmoDamage;
	        UTProj_VASShockBall(SpawnedProjectile).LifeSpan=RandRange(0.1,5.0);
            }
        }
}


defaultproperties
{
    bProjTarget=True
    bNoDelete=False
    BStatic=False
    bVASInit=True
    ResetCounter=0
}

