//-----------------------------------------------------------
//   VasAutoShields by Kal Corp
//   KalCorp@Cfl.rr.com
//   Development Forums @ Http://vasserver.dyndns.org:88
//   SVN @ http://vasserver.dyndns.org:81/svn/UT3-VASUT3VolatileAmmo/
//-----------------------------------------------------------
class VASUT3VolatileAmmo extends UTMutator config(VASUT3VolatileAmmo);

Var string VASName;
var string VersionNumber;
var array<String> SentWelcomeMSG;

var config int VolatileAmmoCount;
var config int VolatileAmmoHealth;
var config float VolatileAmmoDamage;


function PreBeginPlay()
{
 SaveConfig();
 VasLog ("");
 VasLog ("***************************************************************");
 VasLog ("");
 VasLog ("           Powered by "$VASName$" v"$VersionNumber);
 VasLog ("");
 VasLog ("                VolatileAmmoCount: "$VolatileAmmoCount);
 VasLog ("");
 VasLog ("               VolatileAmmoHealth: "$VolatileAmmoHealth);
 VasLog ("");
 VasLog ("               VolatileAmmoDamage: "$VolatileAmmoDamage);
 VasLog ("");
 VasLog ("***************************************************************");
 VasLog ("");
}


function bool CheckReplacement(Actor Other)
{
	local UTAmmoPickupFactory AmmoPickup, NewAmmo;
	local class<UTAmmoPickupFactory> NewAmmoClass;

    AmmoPickup = UTAmmoPickupFactory(Other);


    if (AmmoPickup != None)
    {
       if ( Other.IsA('UTAmmo_BioRifle_Content') )
       {
       if (Other.IsA('VAS_UTAmmo_BioRifle'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_BioRifle", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_BioRifle(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_BioRifle(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
		    VAS_UTAmmo_BioRifle(NewAmmo).VolatileAmmoDamage = VolatileAmmoDamage/100;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }




       if ( Other.IsA('UTAmmo_ShockRifle') )
       {
       if (Other.IsA('VAS_UTAmmo_ShockRifle'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_ShockRifle", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_ShockRifle(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_ShockRifle(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
		    VAS_UTAmmo_ShockRifle(NewAmmo).VolatileAmmoDamage = VolatileAmmoDamage/100;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }



       if ( Other.IsA('UTAmmo_FlakCannon') )
       {
       if (Other.IsA('VAS_UTAmmo_FlakCannon'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_FlakCannon", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_FlakCannon(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_FlakCannon(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
		    VAS_UTAmmo_FlakCannon(NewAmmo).VolatileAmmoDamage = VolatileAmmoDamage/100;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }


       if ( Other.IsA('UTAmmo_SniperRifle') )
       {
       if (Other.IsA('VAS_UTAmmo_SniperRifle'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_SniperRifle", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_SniperRifle(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_SniperRifle(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }


       if (Other.IsA('UTAmmo_RocketLauncher'))
       {
       if (Other.IsA('VAS_UTAmmo_RocketLauncher'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_RocketLauncher", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_RocketLauncher(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_RocketLauncher(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }


       if (Other.IsA('UTAmmo_Enforcer'))
       {
       if (Other.IsA('VAS_UTAmmo_Enforcer'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_Enforcer", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_Enforcer(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_Enforcer(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }

       if (Other.IsA('UTAmmo_LinkGun'))
       {
       if (Other.IsA('VAS_UTAmmo_LinkGun'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_LinkGun", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_LinkGun(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_LinkGun(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }

       if (Other.IsA('UTAmmo_Stinger'))
       {
       if (Other.IsA('VAS_UTAmmo_Stinger'))
          return true;

		NewAmmoClass = class<UTAmmoPickupFactory>(DynamicLoadObject("VASUT3VolatileAmmo.VAS_UTAmmo_Stinger", class'class'));
		if (NewAmmoClass == None)
            return false;
		else
			{
            NewAmmo = AmmoPickup.Spawn(NewAmmoClass);
		    VAS_UTAmmo_Stinger(NewAmmo).VolatileAmmoCount = VolatileAmmoCount;
		    VAS_UTAmmo_Stinger(NewAmmo).VolatileAmmoHealth = VolatileAmmoHealth;
			NewAmmo.OriginalFactory = AmmoPickup;
			AmmoPickup.ReplacementFactory = NewAmmo;
			return false;
			}
       }
    }

	return true;
}


function ModifyPlayer(Pawn Other)
{
    if (Other.controller.isa('PlayerController'))
      if (!SentWelcomeMSGCheck(Other.PlayerReplicationInfo.PlayerName))
          SendSTSPoweredByMessage(Other);
    Super.ModifyPlayer(Other);
}

function SendSTSPoweredByMessage(pawn pawn)
{
    pawn.ClientMessage("Powered by "$VASName$" v"$VersionNumber);
}

function bool SentWelcomeMSGCheck(string PlayerName)
{
	local int i;
	local string NewSentWelcomeMSG;

	for ( i=0; i<SentWelcomeMSG.Length; i++ )
		if ( caps(SentWelcomeMSG[i]) == Caps(PlayerName) )
           return True;
	NewSentWelcomeMSG = Caps(PlayerName);
	SentWelcomeMSG[SentWelcomeMSG.Length] = NewSentWelcomeMSG;
	return False;
}


function VasLog(String MSG, optional int option)
{
local int i;
local string OptionTemp, GameTimerTemp;

   if (option > 0)
      for ( i=0; i<option; i++ )
          OptionTemp = OptionTemp$"*";
   if (WorldInfo.TimeSeconds > 0.00)
      GameTimerTemp = " - "$string(WorldInfo.TimeSeconds);
   LogInternal(String(self)$" - " $OptionTemp$" - "$Role$GameTimerTemp$" - "$MSG);
}

DefaultProperties
{
   VASName="{Vas} Volatile-Ammo"
   VersionNumber="1.1"
   VolatileAmmoCount=25
   VolatileAmmoHealth=50
   VolatileAmmoDamage=25
   name="VAS UT3 VolatileAmmo"
   ObjectArchetype=UTMutator'UTGame.Default__UTMutator'
}
