//-----------------------------------------------------------
//   VasAutoShields by Kal Corp
//   KalCorp@Cfl.rr.com
//   Development Forums @ Http://vasserver.dyndns.org:88
//   SVN @ http://vasserver.dyndns.org:81/svn/UT3-VASUT3VolatileAmmo/
//-----------------------------------------------------------
class VAS_UTAmmo_BioRifle extends UTAmmo_BioRifle_Content;

var Controller	Vas_Instigator;

var int VolatilePercent;
var int VolatileAmmoCount;
var int VolatileAmmoHealth;
var int TempVolatileAmmoHealth;
var float VolatileAmmoDamage;
var int CounterforShoot;

var float tempcounter;

var bool bVASInitShoot;
var bool bShoot;
var bool bSpwnVolatilePawn;
var bool bhitexplode;
var bool bVASInit;
var bool bVASInitHealth;


simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    SetTimer(0.2,true,'VASTimerVolatile');
	bProjTarget = false;
	bVASInit=true;
	CounterforShoot=VolatileAmmoCount;
}

simulated function VASTimerVolatile()
{
    local vector RealStartLoc;
	local Projectile SpawnedProjectile;

    if (IsInState('Pickup'))
       {
       bProjTarget=true;
       if (!bVASInit)
          bVASInit=true;
       }

    if (IsInState('Sleeping'))
       {
       bProjTarget=false;
       bVASInit=true;
       TempVolatileAmmoHealth=VolatileAmmoHealth;
       CounterforShoot=VolatileAmmoCount;
       }
     If (bShoot)
        {
        //VASSpawnShoot();
        }
     else
        CounterforShoot=VolatileAmmoCount;

     if (bhitexplode)
        {
	    bhitexplode= false;
        RealStartLoc = self.location;
        if( Role == ROLE_Authority )
	        {
    	    SpawnedProjectile = Spawn(class'UTProj_VASBioGlob', self,, RealStartLoc);
		    if( SpawnedProjectile != None )
		        {
		        UTProj_VASBioGlob(SpawnedProjectile).Damage = 0;
		        UTProj_VASBioGlob(SpawnedProjectile).SetGlobStrength(1);
		        UTProj_VASBioGlob(SpawnedProjectile).Velocity = (Location * 0.1) ;
		        UTProj_VASBioGlob(SpawnedProjectile).LifeSpan=0.1;
		        }
             }

        }
}

simulated function VASSpawnExplosion()
{
    if( Role == ROLE_Authority )
	    {
        bShoot = false;
        self.gotostate('Sleeping');
		}
}

simulated function VASSpawnShoot()
{
	local Projectile SpawnedProjectile;
	local vector RealStartLoc;


    if( Role == ROLE_Authority )
        {
        bVASInit = false;
	    CounterforShoot = CounterforShoot-1;

        If ((CounterforShoot <= 0) || (rand(100) >= 98))
           {
           bVASInitShoot = False;
           bProjTarget=false;
           }

        self.gotostate('Sleeping');
        RealStartLoc = self.location;
        SpawnedProjectile = Spawn(class'VASUT3VolatileAmmo.UTProj_VASBioGlob',,, RealStartLoc);
        if( SpawnedProjectile != None )
            {
            self.gotostate('Sleeping');
            UTProj_VASBioGlob(SpawnedProjectile).InstigatorController =  Vas_Instigator;
            UTProj_VASBioGlob(SpawnedProjectile).VolatileAmmoCount=VolatileAmmoCount;
            UTProj_VASBioGlob(SpawnedProjectile).SetGlobStrength(VolatileAmmoCount);
            UTProj_VASBioGlob(SpawnedProjectile).Velocity = (Normal(UTProj_BioGlob(SpawnedProjectile).Velocity) * UTProj_BioGlob(SpawnedProjectile).Speed * (0.4 + 40)/(1.35*40));
            UTProj_VASBioGlob(SpawnedProjectile).Damage = UTProj_VASBioGlob(SpawnedProjectile).Damage * VolatileAmmoDamage;
            UTProj_VASBioGlob(SpawnedProjectile).VolatileAmmoDamage = VolatileAmmoDamage;
            UTProj_VASBioGlob(SpawnedProjectile).gotostate('Flying');
            }
       }
}

event TakeDamage( int Damage, Controller EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType, optional TraceHitInfo HitInfo, optional Actor DamageCauser)
{
 if (!bVASInithealth)
    {
    TempVolatileAmmoHealth=VolatileAmmoHealth;
    bVASInithealth = True;
    }

 if (IsInState ('Pickup'))
    {
    Vas_Instigator = EventInstigator;
    if (bVASInit)
       {
       if (Damage > 0)
          bhitexplode= true;
       TempVolatileAmmoHealth = TempVolatileAmmoHealth-Damage;
       if (TempVolatileAmmoHealth <= 0)
          if( Role == ROLE_Authority )
  	          {
              bShoot=True;
  	          VASSpawnShoot();
  	          }
       }
    }
}


defaultproperties
{
    bProjTarget=True
    bNoDelete=False
    BStatic=False
    bVASInit=True
}

