// ============================================================================
// JBAddonOverTimeLastChance
// Based on JBAddonLlama
// Date      : 03.29.2005
// Revision  : 4
//
// Class used to add the JBGameRulesOvertimeLastChance to the game, do
// clientside stuff and add settings to webadmin
// ============================================================================
class JBAddonOvertimeLastChance extends JBAddon
  config
  cacheexempt;

// ============================================================================
// Variables
// ============================================================================

// configurables
var globalconfig string LocksJamMessage;
var globalconfig bool bAllowArenaInOT;      // If true, the players will be able to earn freedom in arena match even in OT.
var globalconfig int RestartPlayersInOT;    // if the players will be restarted in OT;
                                            // 0 - no restart, 1 - only free players are restarted,
                                            // 2 - all players are restarted in freedom.

// localizables
var localized string AllowArenaInOvertime;
var localized string RestartPlayersInOvertime;
var localized string AllowArenaInOvertimeHint;
var localized string RestartPlayersInOvertimeHint;

// internals
var string TextTeamReleasedNobodyBackup;
var string TextLastManBackup;
var string Mode;

var bool bMakeChanges;
var bool bMadeChanges;
var bool bUndoChanges;
var bool bUndoneChanges;
var bool bDebug;

var JBGameRulesOvertimeLastChance LastChanceRules;

// replication
replication
{
	// replicating two flag vars to client
  reliable if ( Role == ROLE_Authority)
    bUndoChanges, bMakeChanges;
}


// ============================================================================
// PostBeginPlay
//
// Spawns the JBGameRulesOvertimeLastChance, startss timer and does some
// debug stuff.
// ============================================================================

simulated event PostBeginPlay()
{
  Super.PostBeginPlay();

  if ( Jailbreak(Level.Game) != None && Level.NetMode != NM_Client) {
    // spawn the JBGameRules subclass for Jailbreak event notifications
    LastChanceRules = class'JBGameRulesOvertimeLastChance'.static.FindRules(Self);
    if ( LastChanceRules != None )
      LastChanceRules.MyAddon = Self;
  }

	SetTimer(1,True);
}


// ============================================================================
// Timer
//
// Checks if the flag variables have changed and if so, performs client-side
// changes
// ============================================================================

simulated function Timer(){
	super.Timer();

 	if (bMakeChanges && !bMadeChanges){
    MakeLocalChanges();
    bMadeChanges = true;
 	}
 	if (bUndoChanges && !bUndoneChanges){
 	  UndoLocalChanges();
 		bUndoneChanges = true;
 	}

}


// ============================================================================
// MakeLocalChanges
//
// Makes clientside changes:
// - hides some messages (doesn't seem to work yet)
// - hides the particle swirl around the lock
// ============================================================================

simulated function MakeLocalChanges(){

	local JBEmitterBasket myEmitter;

	// somehow this code doesn't do anything to the messages. Can't understand why
	// making localized backup...
	TextTeamReleasedNobodyBackup = class'JBLocalMessage'.default.TextTeamReleasedNobody;
	TextLastManBackup 					 = class'JBLocalMessage'.default.TextLastMan;
	// clearing messages, so they won't appear
	class'JBLocalMessage'.default.TextTeamReleasedNobody = " ";
	class'JBLocalMessage'.default.TextLastMan = " ";

	if (Level.NetMode != NM_DedicatedServer){
		Foreach AllActors(class'JBEmitterBasket', myEmitter){
			HideEmitter(myEmitter);
		}
	}
}


// ============================================================================
// UndoLocalChanges
//
// Reverts clientside changes:
// - restores messages
// - restores the particle swirl around the lock
// ============================================================================

simulated function UndoLocalChanges(){

	local JBEmitterBasket myEmitter;

	class'JBLocalMessage'.default.TextTeamReleasedNobody = TextTeamReleasedNobodyBackup;
	class'JBLocalMessage'.default.TextLastMan						 = TextLastManBackup;

	if (Level.NetMode != NM_DedicatedServer && bMadeChanges){
  	Foreach AllActors(class'JBEmitterBasket', myEmitter){
			ShowEmitter(myEmitter);
		}
	}
}

// ============================================================================
// HideEmitter
//
// Utility function to hide particle swirl around the lock
// ============================================================================

simulated function HideEmitter(Emitter myEmitter){

 	local ParticleEmitter SwirlEmitter;

 	SwirlEmitter = myEmitter.Emitters[0];
  SwirlEmitter.Disabled = true;
 	SwirlEmitter.Inactive = true;
}


// ============================================================================
// ShowEmitter
//
// Utility function to show particle swirl around the lock
// ============================================================================

simulated function ShowEmitter(Emitter myEmitter){

 	local ParticleEmitter SwirlEmitter;

 	SwirlEmitter = myEmitter.Emitters[0];
 	SwirlEmitter.Disabled = false;
 	SwirlEmitter.Inactive = false;
}


// ============================================================================
// FillPlayInfo
//
// Provides access to addon's setting via WebAdmin interface
// ============================================================================

static function FillPlayInfo(PlayInfo PlayInfo)
{
  Super.FillPlayInfo(PlayInfo);

  PlayInfo.AddClass(default.Class);
	PlayInfo.AddSetting(PlayInfoGroup(), "bAllowArenaInOT", 				default.AllowArenaInOvertime,   				1, 	1, "Check");
	PlayInfo.AddSetting(PlayInfoGroup(), "RestartPlayersInOT", 			default.RestartPlayersInOvertime, 			1, 	1, "Select", "0;Do not restart (default);1;Only free players;2;Everyone");
  PlayInfo.PopClass();
}

static event string GetDescriptionText(string PropName)
{
  switch (PropName)
  {
    case "bAllowArenaInOT":
      return default.AllowArenaInOvertimeHint;
    case "RestartPlayersInOT":
      return default.RestartPlayersInOvertimeHint;
  }

  return super.GetDescriptionText(PropName);
}


// ============================================================================
// Destroyed
//
// Modified to undo local changes
// ============================================================================

simulated event Destroyed(){
	UndoLocalChanges();
	super.Destroyed();
}

DefaultProperties
{
	FriendlyName="Overtime Last Chance"
	Description="If a match goes to overtime because of a tie, the release switches become jammed to nobody can release any more. Last chance to score a point!"

	LocksJamMessage="OMG! The Jail locks are jammed!"
  ConfigMenuClassName="JBAddonOvertimeLastChance.JBGUIPanelConfigOTLastChance"
	RemoteRole=ROLE_SimulatedProxy
	bAlwaysRelevant=True
	bDebug=false

	AllowArenaInOvertime="Allow arena matches in overtime"
  RestartPlayersInOvertime="Restart players in overtime"
  AllowArenaInOvertimeHint="If true, the arena matches will be played during overtime."
  RestartPlayersInOvertimeHint="Choose if the players will be restarted at the beginning of the overtime, and if so should it be all players or only free players."
}
