// ============================================================================
// JBLocalMessageOTLockJam
// Date      : 03.29.2005
// Revision  : 1
//
// Contains the messages for the Overtime Last Chance Addon
// The following message codes are defined:
//
//   Switch    Meaning              		Info 1        Info 2        Object
//   =======   =======================  ===========   ===========   ========
//   100		   Locks are jammed
//   200		   OT: No releases allowed
//   300       Tried to release         Who tried
//
//	100: shown when the overtime starts
//  200: shown to the player who runs over the switch in the overtime
// ============================================================================
class JBLocalMessageOTLockJam extends LocalMessage;

var localized string OvertimeNoReleasesAllowed;
var localized string TriedToReleaseButLostKey[3];

static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
  local string mystring;

	if (switch == 100)
		return class'JBAddonOvertimeLastChance'.default.LocksJamMessage;
	if (switch == 200)
	  return default.OvertimeNoReleasesAllowed;
	if (switch == 300){
    mystring = default.TriedToReleaseButLostKey[Rand(2)];
	  return RelatedPRI_1.PlayerName@mystring;
	}

}

DefaultProperties
{
	OvertimeNoReleasesAllowed="Overtime: releases are not allowed"
	TriedToReleaseButLostKey(0)="tried to relase his team but lost his key!"
	TriedToReleaseButLostKey(1)="broke his lockpick while trying to release his team!"
	TriedToReleaseButLostKey(2)="missed the 'Releases' not allowed announcement!"
  bIsUnique=True
  bFadeMessage=True
  Lifetime=4
  bBeep=True
  FontSize=1
  DrawColor=(R=255,G=15,B=15,A=255),
  StackMode=2
  PosY=0.40
}
