// ============================================================================
// JBGUIPanelConfigOTLastChance
// Based on JBAddonLlama's JBGUIPanelConfigLlama
// Date      : 03.29.2005
// Revision  : 1
//
// GUI class to configure Overtime Last Chance addon
// That's a very basic config. Not ure if it's needed, so I commented out the
// appropriate string in Addon. Actually I made it just to understand how
// UT200x GUI system works (never tried to do anything with it yet). Not sure
// if it will be of any use.
// ============================================================================
class JBGUIPanelConfigOTLastChance extends JBGUIPanelConfig;


//=============================================================================
// Variables
//=============================================================================

var private bool bInitialized;  // used to prevent executing SaveINISettings() during initialization

// ============================================================================
var automated moCheckbox ch_AllowArenaInOT;
var automated moComboBox co_RestartPlayers;

var localized string str_RestartAllPlayers;
var localized string str_RestartOnlyFreePlayers;
var localized string str_DoNotRestart;

//=============================================================================
// InitComponent
//
// Sets the values for co_RestartPlayers dropdown box and loads the
// configurable values.
//=============================================================================

function InitComponent(GUIController MyController, GUIComponent MyOwner)
{
  Super.InitComponent(MyController, MyOwner);

	co_RestartPlayers.AddItem(str_DoNotRestart);
	co_RestartPlayers.AddItem(str_RestartOnlyFreePlayers);
  co_RestartPlayers.AddItem(str_RestartAllPlayers);
	co_RestartPlayers.ReadOnly(true);

  LoadINISettings();
}

//=============================================================================
// LoadINISettings
//
// Loads the values of all config GUI controls.
//=============================================================================

function LoadINISettings()
{
  bInitialized = False;
  co_RestartPlayers.SetIndex(class'JBAddonOvertimeLastChance'.default.RestartPlayersInOT);
  ch_AllowArenaInOT.Checked(!class'JBAddonOvertimeLastChance'.default.bAllowArenaInOT);
  bInitialized = True;
}


//=============================================================================
// SaveINISettings
//
// Called when a value of a control changed.
// Saves the values of all config GUI controls.
//=============================================================================

function SaveINISettings(GUIComponent Sender)
{
  if ( !bInitialized )
    return;

  class'JBAddonOvertimeLastChance'.default.bAllowArenaInOT    = !ch_allowArenaInOT.IsChecked();
  class'JBAddonOvertimeLastChance'.default.RestartPlayersInOT = co_RestartPlayers.GetIndex();
  class'JBAddonOvertimeLastChance'.static.StaticSaveConfig();
}


//=============================================================================
// ResetConfiguration
//
// Resets the configurable properties to their default values.
//=============================================================================

function ResetConfiguration()
{
  class'JBAddonOvertimeLastChance'.static.ResetConfig();
  LoadINISettings();
}


//=============================================================================
// Default properties
//=============================================================================

defaultproperties
{
  str_RestartAllPlayers="All players"
  str_RestartOnlyFreePlayers="Only free players"
  str_DoNotRestart="None"

  Begin Object Class=moComboBox Name=RestartPlayersInOT
    bReadOnly=True
    ComponentJustification=TXTA_Left
    CaptionWidth=0.6
    Caption="Restart players in OT"
    OnCreateComponent=RestartPlayersInOT.InternalOnCreateComponent
    Hint="This option allows you to restart free players when overtime starts, restart all players in freedom, including prisoners and arena combatants or none at all."
		WinHeight=0.065434
		WinLeft=0.002168
		WinTop=-0.122379
    WinWidth=0.9
    TabOrder=1
    OnChange=JBGUIPanelConfigOTLastChance.SaveINISettings
  End Object
  co_RestartPlayers=moComboBox'JBaddonOvertimeLastChance.JBGUIPanelConfigOTLastChance.RestartPlayersInOT'

  Begin Object Class=moCheckBox Name=NoArena
    CaptionWidth=0.65
    Caption="Disallow arena matches in OT"
    OnCreateComponent=NoArena.InternalOnCreateComponent
    Hint="If true, there will be no arena matches during overtime. However, if the match was progress, at the moment overtime started, it will continue."
		WinLeft=0.005423
		WinTop=-0.014439
    WinWidth=0.9
    TabOrder=2
		WinHeight=0.065434
    OnChange=JBGUIPanelConfigOTLastChance.SaveINISettings
  End Object
  ch_allowArenaInOT=moCheckBox'JBaddonOvertimeLastChance.JBGUIPanelConfigOTLastChance.NoArena'
}

