class Z_part extends Walker_part;

var Walker_part Slave;
var WHinge      Slave_Joint;

// simulate this event locally

simulated event PostBeginPlay()
{
 local rotator HingesRot;
 local vector  SocketLoc;

   SocketLoc = GetBoneCoords('end_bone').Origin;

    // make 90 deg yaw angle
   HingesRot.Yaw = Rotation.Yaw + 16384;
   HingesRot.Roll = Rotation.Roll;
   HingesRot.Pitch = Rotation.Pitch;

   // Slave
   Slave = Spawn(class'B_part', self,, SocketLoc, Rotation);
   Slave.Master = self;
   Slave.Walker_Craft = Walker_Craft;
   Slave.PartType = PartType;
   Slave.AmbientGlow = AmbientGlow;
   Slave_Joint = Spawn(class'WHinge', none,, SocketLoc, HingesRot);
   Slave_Joint.KConstraintActor1 = self;
   Slave_Joint.KConstraintActor2 = Slave;
   Slave_Joint.Parked_Stiffness = 400;
   Slave_Joint.Walking_Stiffness = 20;
   Slave_Joint.Falling_Stiffness = 100;

   // setup physics
   Slave_Joint.SetPhysics(Phys_Karma);

 Super.PostBeginPlay();
}

// destroy childrenS

simulated function Destroyed()
{
  Slave_Joint.Destroy();
  Slave.Destroy();

  Super.Destroyed();
}

simulated function SetStiffness(byte WHS_Mode)
{
 Slave_Joint.SetStiffness(WHS_Mode);
 B_part(Slave).SetStiffness(WHS_Mode);
}

simulated function SetWPFriction(float K)
{
 KSetFriction(KParams.KFriction*K);
 B_part(Slave).SetWPFriction(B_part(Slave).KParams.KFriction*K);
}

simulated event TeamChanged(byte Team)
{
 Super.TeamChanged(Team);
 Slave.TeamChanged(Team);
}

DefaultProperties
{
 AmbientSound=Sound'DC_Walker_S.loop_xeng'
 SoundVolume=0
 SoundRadius=600
 TransientSoundRadius=1200
 VehicleDamMult=0.9
 Mesh=SkeletalMesh'DC_Walker_A.Leg_Z_part'
}
