//-----------------------------------------------------------
// This is "S_part" if you dont know...
// Working class to interpolate end of leg to destinastion point.
// Do sounds, step effects and other stuff here, synchronise
// its position with server if possible !!!
//-----------------------------------------------------------

class Walker_leg extends Walker_part;

var Walker_part Left_Slave, Right_Slave, Rear_Slave;
var WHinge      Left_Joint, Right_Joint, Rear_Joint;
var float       GroundTraceDist, LegLength, LegStretch, kL;
var float       StepSpeed, StepHeight, Z_Buffer, LegStepForce;
var vector      TargetLocation, NewLocation, Dist, Dist2D;
var float       OnGroundTime, ArrivedDistance, NewStepSpeed;
var bool        IsStack, CanSmash;
var vector      LastFallLocation;

// Internal system of states...
var() enum L_State {
                  L_Interpolating, // normal mass, moving to next point, check everything
                  L_OnGround, // max mass, force stay on place, check leg length
                  L_Falling   // normal mass, seacrch groung (tracing)
                 } LegState;

simulated event PostBeginPlay()
{
 local rotator LeftPartRot, RightPartRot, RearPartRot, NinetyDegs;
 local vector  Left_SocketLoc, Right_SocketLoc, Rear_SocketLoc;

   Left_SocketLoc = GetBoneCoords('left_end').Origin;
   Right_SocketLoc = GetBoneCoords('right_end').Origin;
   Rear_SocketLoc = GetBoneCoords('rear_end').Origin;

   // make 60, -60 and 180 deg Yaw angles
   LeftPartRot.Roll = Rotation.Roll;
   LeftPartRot.Pitch = Rotation.Pitch;
   LeftPartRot.Yaw = Rotation.Yaw - 10923; // 60 deg
   RightPartRot.Roll = Rotation.Roll;
   RightPartRot.Pitch = Rotation.Pitch;
   RightPartRot.Yaw = Rotation.Yaw + 10923; // -60 deg
   RearPartRot.Roll = Rotation.Roll;
   RearPartRot.Pitch = Rotation.Pitch;
   RearPartRot.Yaw = Rotation.Yaw + 32768; // 180 deg
   NinetyDegs.Yaw = 16384;

   // left slave
   Left_Slave = Spawn(class'F_part', self,, Left_SocketLoc, LeftPartRot);
   Left_Slave.Master = self;
   Left_Slave.Walker_Craft = Walker_Craft;
   Left_Slave.PartType = PartType;
   Left_Slave.AmbientGlow = AmbientGlow;
   Left_Joint = Spawn(class'WHinge', none,, Left_SocketLoc, LeftPartRot + NinetyDegs);
   Left_Joint.KConstraintActor1 = self;
   Left_Joint.KConstraintActor2 = Left_Slave;
   Left_Joint.Parked_Stiffness = 300;
   Left_Joint.Walking_Stiffness = 300;
   Left_Joint.Falling_Stiffness = 300;

   // right slave
   Right_Slave = Spawn(class'F_part', self,, Right_SocketLoc, RightPartRot);
   Right_Slave.Master = self;
   Right_Slave.Walker_Craft = Walker_Craft;
   Right_Slave.PartType = PartType;
   Right_Slave.AmbientGlow = AmbientGlow;
   Right_Joint = Spawn(class'WHinge', none,, Right_SocketLoc, RightPartRot + NinetyDegs);
   Right_Joint.KConstraintActor1 = self;
   Right_Joint.KConstraintActor2 = Right_Slave;
   Right_Joint.Parked_Stiffness = 300;
   Right_Joint.Walking_Stiffness = 300;
   Right_Joint.Falling_Stiffness = 300;

   // rear slave
   Rear_Slave = Spawn(class'F_part', self,, Rear_SocketLoc, RearPartRot);
   Rear_Slave.Master = self;
   Rear_Slave.Walker_Craft = Walker_Craft;
   Rear_Slave.PartType = PartType;
   Rear_Slave.AmbientGlow = AmbientGlow;
   Rear_Joint = Spawn(class'WHinge', none,, Rear_SocketLoc, RearPartRot + NinetyDegs);
   Rear_Joint.KConstraintActor1 = self;
   Rear_Joint.KConstraintActor2 = Rear_Slave;
   Rear_Joint.Parked_Stiffness = 300;
   Rear_Joint.Walking_Stiffness = 1200;
   Rear_Joint.Falling_Stiffness = 300;

   // setup physics
   Left_Joint.SetPhysics(Phys_Karma);
   Right_Joint.SetPhysics(Phys_Karma);
   Rear_Joint.SetPhysics(Phys_Karma);

   OnGroundTime = 0;

 Super.PostBeginPlay();
}

simulated function Tick(float dt)
{
 if (LegState == L_Interpolating)
  {
   InterpolateProcess(dt);
  }
 else if (LegState == L_OnGround)
  {
   OnGroundTime = OnGroundTime + dt;
   if ((Walker_Craft != none) && (Walker_Craft.WalkerState == W_Walking))
    StayAtPlaceProcess();
  }
 else if (LegState == L_Falling)
  {
   if (IsOnGround() == true)
    {
     SetLState(L_OnGround);
     PlaySound(Sound'DC_Walker_S.step1_mb',,6,,64,32);
    }
   if (IsStack == false)
    Debug(dt);
  }

 DoSounds();
 Super.Tick(dt);
}

simulated function SetLState(L_State NewState)
{
 if (NewState == L_Interpolating)  // INTERPOLATING START
  {
   LegState = L_Interpolating;
   NewLocation = Location;
   Z_Buffer = Location.Z;
   Dist = TargetLocation - Location;
   Dist2D.X = Dist.X; Dist2D.Y = Dist.Y;
   kL = VSize(Dist2D)/2;
   KSetFriction(0.5);
   KarmaParams(KParams).KAngularDamping=10.0;
   KarmaParams(KParams).KLinearDamping=10.0;
   Left_Slave.KSetFriction(0.1);
   Right_Slave.KSetFriction(0.1);
   Rear_Slave.KSetFriction(0.1);
   OnGroundTime = 0;
   IsStack = false;
   CanSmash = true;
  }
 else  if (NewState == L_OnGround) // FIXING START
  {
   LegState = L_OnGround;
   NewLocation = Location;
   Z_Buffer = Location.Z;
   TargetLocation = Location;
   OnGroundTime = 0;
   KSetFriction(5);
   KarmaParams(KParams).KAngularDamping=10.0;
   KarmaParams(KParams).KLinearDamping=10.0;
   Left_Slave.KSetFriction(1);
   Right_Slave.KSetFriction(1);
   Rear_Slave.KSetFriction(1);
   OnGroundTime = 0;
   IsStack = false;
  }
 else  if (NewState == L_Falling)  // FALLING START
  {
   LegState = L_Falling;
   KSetFriction(5);
   KarmaParams(KParams).KAngularDamping=2.0;
   KarmaParams(KParams).KLinearDamping=2.0;
   Left_Slave.KSetFriction(1);
   Right_Slave.KSetFriction(1);
   Rear_Slave.KSetFriction(1);
   IsStack = false;
   OnGroundTime = 0;
   LastFallLocation = Location;
  }
}

simulated function Debug(float dt)
{
 if (VSize(LastFallLocation - Location) < 8*dt)
  {
   IsStack = true;
   OnGroundTime = 1;
  }
 LastFallLocation = Location;
}

// Function to command step externally (from vehicle)
// Check possibility here
simulated function bool StepTo(vector StepToLoc, float CustomStepHeight)
{
 local vector TestLocation, HitLocation, Hitnormal;
 local Actor  Other;

 StepSpeed = NewStepSpeed;
 TestLocation = (StepToLoc + Location)/2;
 TestLocation.Z = TestLocation.Z + CustomStepHeight;
 Other = Trace(HitLocation, Hitnormal, StepToLoc + vect(0,0,16), TestLocation);
 if ((Other != none) && (Other.bWorldGeometry == true) && (StepToLoc.Z < Location.Z))
  StepToLoc.Z = Location.Z;
 else
  {
   Other = Trace(HitLocation, Hitnormal, TestLocation, Location);
   if ((Other != none) && (Other.bWorldGeometry == true))
    StepToLoc.Z = HitLocation.Z + CustomStepHeight;
  }

 if ((VSize(Location - StepToLoc) < 64) || (abs(Location.Z - StepToLoc.Z) > Walker_Craft.StandHeight))
  return false;
 else
  {
   StepHeight = Min(128, CustomStepHeight);
   TargetLocation = StepToLoc;
   SetLState(L_Interpolating);
   return true;
  }
}

// Moving leg here
simulated function InterpolateProcess(float dt)
{
 local rotator LegOffset;
 local vector  ThurstCenter;

 LegOffset.Roll = Normalize(Rotation).Roll;
 LegOffset.Yaw = Normalize(Rotation).Yaw;
 LegOffset.Pitch = Normalize(Rotation).Pitch - 16384;
 ThurstCenter = GetBoneCoords('base_bone').Origin + vector(LegOffset)*48;

 Dist = TargetLocation - NewLocation;
 Dist2D.X = Dist.X; Dist2D.Y = Dist.Y;
 NewLocation.X = NewLocation.X + Normal(Dist).X*dt*StepSpeed;
 NewLocation.Y = NewLocation.Y + Normal(Dist).Y*dt*StepSpeed;
 Z_Buffer = Z_Buffer + Normal(Dist).Z*dt*StepSpeed;
 NewLocation.Z = Z_Buffer + StepHeight*(1 - abs(1 - VSize(Dist2D)/kL));
  KAddImpulse(LegStepForce*(NewLocation - ThurstCenter), ThurstCenter, 'base_bone');
 if(VSize(Dist) < ArrivedDistance)
  SetLState(L_Falling);
}

// Continue force it to it's target location, don't forget to check length
simulated function StayAtPlaceProcess()
{
 if (PartType == PT_Left)
  LegStretch = VSize(NewLocation - Walker_Craft.GetBoneCoords('left_leg_socket').Origin);
 else if (PartType == PT_Right)
  LegStretch = VSize(NewLocation - Walker_Craft.GetBoneCoords('right_leg_socket').Origin);

 if (LegStretch > LegLength)
  SetLState(L_Falling);
 else if (VSize(NewLocation - Location) > ArrivedDistance)
  KAddImpulse(LegStepForce*(NewLocation - Location), GetBoneCoords('base_bone').Origin, 'base_bone');
}

// trace ground, return true if on ground
simulated function bool IsOnGround( optional out vector HitLocation, optional out vector HitNormal, optional out Material Surface)
{
 local vector StartTrace, EndTrace;
 local rotator LegOffset;
 local Actor  Other;

 LegOffset.Roll = Normalize(Rotation).Roll;
 LegOffset.Yaw = Normalize(Rotation).Yaw;
 LegOffset.Pitch = Normalize(Rotation).Pitch - 16384;

 StartTrace = GetBoneCoords('base_bone').Origin + vector(LegOffset)*32;
 EndTrace = StartTrace; EndTrace.Z = EndTrace.Z - GroundTraceDist;
 Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace,,, Surface);
 if ((Other != none) && ((Other.bWorldGeometry == true) || ((Other.IsA('vehicle')) && (Other != self))))
  {
   if (CanSmash == true)
    {
     if ( (Other.IsA('ONSVehicle') == true) && (ONSVehicle(Other).Team != Walker_Craft.Team) )
      {
       Other.TakeDamage(300, Walker_Craft, Location, vect(0,0,0), class'Crushed');
       CanSmash = false;
      }
     else if ( (Other.IsA('xPawn') == true) && (xPawn(Other).TeamSkin != Walker_Craft.Team) )
      {
       Other.TakeDamage(300, Walker_Craft, Location, vect(0,0,0), class'Crushed');
       CanSmash = false;
      }
    }
   return true;
  }
 else
  return false;
}

// destroy childrenS
simulated function Destroyed()
{
 Left_Joint.Destroy();
 Right_Joint.Destroy();
 Rear_Joint.Destroy();

 Left_Slave.Destroy();
 Right_Slave.Destroy();
 Rear_Slave.Destroy();

 Super.Destroyed();
}

simulated function SetStiffness(byte WHS_Mode)
{
 Left_Joint.SetStiffness(WHS_Mode);
 Right_Joint.SetStiffness(WHS_Mode);
 Rear_Joint.SetStiffness(WHS_Mode);
}

simulated function SetWPFriction(float K)
{
 KSetFriction(KParams.KFriction*K);
 F_Part(Left_Slave).KSetFriction(F_Part(Left_Slave).KParams.KFriction*K);
 F_Part(Right_Slave).KSetFriction(F_Part(Right_Slave).KParams.KFriction*K);
 F_Part(Rear_Slave).KSetFriction(F_Part(Rear_Slave).KParams.KFriction*K);
}

simulated event TeamChanged(byte Team)
{
 Super.TeamChanged(Team);
 Left_Slave.TeamChanged(Team);
 Right_Slave.TeamChanged(Team);
 Rear_Slave.TeamChanged(Team);
}

simulated function DoSounds()
{
 if (PartType == PT_Left)
  LegStretch = VSize(Location - Walker_Craft.GetBoneCoords('left_leg_socket').Origin);
 else if (PartType == PT_Right)
  LegStretch = VSize(Location - Walker_Craft.GetBoneCoords('right_leg_socket').Origin);
 SoundPitch = 32 + 48*LegStretch/LegLength;
 if (LegState == L_Interpolating)
  SoundVolume = 255*LegStretch/LegLength;
 else
  SoundVolume = 0;
}


DefaultProperties
{
 // own physics here //
 StepSpeed=200
 LegLength=450
 GroundTraceDist=64
 LegStepForce=1000
 ArrivedDistance=64
 IsStack = false
 //////////////////
 LegState=L_Falling
 Begin Object Class=KarmaParams Name=KarmaParams0
  KAngularDamping=10.0
  KLinearDamping=10.0
  KFriction=5
  KActorGravScale=5
  bKDoubleTickRate=True
  KMass=1;
 End Object
 KParams=KarmaParams'DC_Walker.Walker_leg.KarmaParams0'
 VehicleDamMult=0.5
 Mesh=SkeletalMesh'DC_Walker_A.Leg_S_part'
 AmbientSound=Sound'DC_Walker_S.servo_loop'
 SoundRadius=600
 SoundVolume=255
 SoundPitch=64
}
