class Quad_gun extends ONSWeapon;

var name    Barrel[4];
var vector  FireLoc;
var rotator FireRot;
var byte    BarrelIndex, OldBarrelIndex, r;

replication
{
 reliable if (Role == ROLE_Authority)
  BarrelIndex;
}

simulated function Tick(float dt)
{
 if (OldBarrelIndex != BarrelIndex)
  {
   FireRot.Yaw = Rotation.Yaw;
   FireRot.Roll = Rotation.Roll;
   FireRot.Pitch = WeaponFireRotation.Pitch;
   FireLoc = GetBoneCoords(Barrel[BarrelIndex]).Origin;
   Spawn(Class'DC_Walker.Plasma_Flash', self, , FireLoc, FireRot);
   PlaySound(SoundGroup'WeaponSounds.PulseRifle.PulseRifleAltFire', SLOT_None, 0.35,, 600, 68, false);
   OldBarrelIndex = BarrelIndex;
  }
 Super.Tick(dt);
}

state ProjectileFireMode
{
 function Fire(Controller C)
  {
   FireRot.Yaw = Rotation.Yaw;
   FireRot.Roll = Rotation.Roll;
   FireRot.Pitch = WeaponFireRotation.Pitch;

   if (BarrelIndex < 3)
    BarrelIndex = BarrelIndex + 1;
   else
    BarrelIndex = 0;

   FireLoc = GetBoneCoords(Barrel[BarrelIndex]).Origin;
   Spawn(Class'DC_Walker.Walker_Plasma', self, , FireLoc, FireRot);
  }

 function AltFire(Controller C)
  {
   if (DC_Walker(Owner) != none)
    DC_Walker(Owner).LaunchRocket();
  }
}

function byte BestMode()
{
 local Bot B;

 if (Bot(DC_Walker(Owner).Controller) != none)
  {
   B = Bot(DC_Walker(Owner).Controller);
   if ((B.Enemy.IsA('Vehicle') == true) || (DC_Walker(Owner).Health < DC_Walker(Owner).HealthMax/5))
    {
     if ((DC_Walker(Owner).HaveRockets() == true) && (DC_Walker(Owner).CurrentTarget != none))
      return 1;
     else
      return 0;
    }
   else
    return 0;
  }
 else if (DC_Walker(Owner).CurrentTarget != none)
  return 1;
 else
  return(0);
}


DefaultProperties
{
 bNetNotify=true
 NetUpdateFrequency=30
 FireInterval=0.15
 AltFireInterval=0.5
 bInstantFire=false
 bShowAimCrosshair=false
 PitchBone="base_bone"
 PitchUpLimit=4000
 PitchDownLimit=-4000
 Spread=0.0
 Barrel(0)="fire_tip_2"
 Barrel(1)="fire_tip_1"
 Barrel(2)="fire_tip_3"
 Barrel(3)="fire_tip_4"
 RedSkin=Shader'DC_Walker_T.Red_Skin'
 BlueSkin=Shader'DC_Walker_T.Blue_Skin'
 Mesh=SkeletalMesh'DC_Walker_A.Guns'
 DrawScale3D=(Z=-1)
}
