class Top_Turret extends ONSWeapon;

var class<ShockBeamEffect> BeamEffectClass;

function SpawnBeamEffect(Vector Start, Rotator Dir, Vector HitLocation, Vector HitNormal, int ReflectNum)
{
    local ShockBeamEffect Beam;

    Beam = Spawn(BeamEffectClass,,, Start, Dir);
    Beam.Instigator = None; // prevents client side repositioning of beam start
    Beam.AimAt(HitLocation, HitNormal);
}

state InstantFireMode
{
    simulated function ClientSpawnHitEffects()
    {
     Spawn(FlashEmitterClass,,,GetBoneCoords(WeaponFireAttachmentBone).Origin, GetBoneRotation(WeaponFireAttachmentBone));
    }

    function SpawnHitEffects(Actor HitActor, vector HitLocation, vector HitNormal)
    {
     Spawn(FlashEmitterClass,,,GetBoneCoords(WeaponFireAttachmentBone).Origin, GetBoneRotation(WeaponFireAttachmentBone));
    }

    function Fire(Controller C)
    {
     PlayOwnedSound(FireSoundClass, SLOT_None, 0.35,, 300,, False);
     TraceFire(WeaponFireLocation, WeaponFireRotation);
    }
}

function byte BestMode()
{
	return 0;
}

DefaultProperties
{
 YawBone="base_bone"
 PitchBone="barrel_bone"
 PitchUpLimit=12000
 PitchDownLimit=64000
 WeaponFireAttachmentBone="fire_bone"
 bInstantRotation=True
 bDoOffsetTrace=True
 bInstantFire=True
 BeamEffectClass=Class'XWeapons.ShockBeamEffect'
 FlashEmitterClass=Class'DC_Walker.Small_plasma_flash'
 RedSkin=Shader'DC_Walker_T.Red_Skin'
 BlueSkin=Shader'DC_Walker_T.Blue_Skin'
 FireInterval=0.35
 FireSoundClass=Sound'WeaponSounds.Linkgun.BLinkedFire'
 FireForce="ShockRifleFire"
 DamageType=Class'Onslaught.DamTypePRVLaser'
 DamageMin=45
 DamageMax=45
 TraceRange=50000.000000
 AIInfo(0)=(bLeadTarget=True,WarnTargetPct=0.000000,RefireRate=1.000000)
 AIInfo(1)=(bLeadTarget=True,WarnTargetPct=0.000000,RefireRate=1.000000)
 CullDistance=8000.000000
 Mesh=SkeletalMesh'DC_Walker_A.Top_Turret'
 DrawScale3D=(Y=-1)
}
