class DC_Walker_replacer extends Mutator config;

var() config string ReplacedVehicleClassName;

static function FillPlayInfo(PlayInfo PlayInfo)
{
 local array<CacheManager.VehicleRecord> Recs;
 local string VehicleOptions;
 local int i;

 Super.FillPlayInfo(PlayInfo);

 class'CacheManager'.static.GetVehicleList(Recs);
 for (i = 0; i < Recs.Length; i++)
 {
  if (VehicleOptions != "")
   VehicleOptions $= ";";
  VehicleOptions $= Recs[i].ClassName $ ";" $ Recs[i].FriendlyName;
 }

 PlayInfo.AddSetting(default.RulesGroup, "ReplacedVehicleClassName", "Replace this with Walking Death", 0, 1, "Select", VehicleOptions);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
 local ONSVehicleFactory Factory;
 local class<Vehicle>    ReplacedVehicleClass;
 local vector            NewSpawnLoc;

 if(ONSVehicleFactory(Other) != none)
  {
   Factory = ONSVehicleFactory(Other);
   if(ReplacedVehicleClassName != "")
    ReplacedVehicleClass = class<SVehicle>(DynamicLoadObject(ReplacedVehicleClassName, class'Class'));
   if (Factory.VehicleClass == ReplacedVehicleClass)
    {
     NewSpawnLoc = Factory.Location;
     NewSpawnLoc.Z = NewSpawnLoc.Z + Class'DC_Walker.DC_Walker'.default.SpawnHeight;
     Factory.SetLocation(NewSpawnLoc);
     Factory.VehicleClass = Class'DC_Walker.DC_Walker';
    }
  }

 return true;
}

DefaultProperties
{
 FriendlyName="Walking Death replacer"
 Description="Replace any vehicle with the Walking Death"
}
