class Top_Turret_Pawn extends ONSWeaponPawn;

function bool PlaceExitingDriver()
{
 local vector ExitLocation, RandomHole;

 RandomHole.X = 128 - Rand(255); RandomHole.Y = 128 - Rand(255);
 ExitLocation = (DC_Walker(VehicleBase).GetBoneCoords('rocket_base_2').Origin + DC_Walker(VehicleBase).GetBoneCoords('rocket_base_12').Origin)/2 + 1.5*Driver.default.CollisionRadius*Normal(RandomHole >> (DC_Walker(VehicleBase).Rotation - DC_Walker(VehicleBase).RelChasRot));

 Driver.SetLocation(ExitLocation);
 return true;
}

function AltFire(optional float F)
{
	local PlayerController PC;

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = true;
	PC.ToggleZoom();
}

function ClientVehicleCeaseFire(bool bWasAltFire)
{
	local PlayerController PC;

	if (!bWasAltFire)
	{
		Super.ClientVehicleCeaseFire(bWasAltFire);
		return;
	}

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = false;
	PC.StopZoom();
}

simulated function ClientKDriverLeave(PlayerController PC)
{
	Super.ClientKDriverLeave(PC);

	bWeaponIsAltFiring = false;
	PC.EndZoom();
}


function ShouldTargetMissile(Projectile P)
{
	if ( Bot(Controller) != None && Bot(Controller).Skill >= 5.0 )
	{
		if ( (Controller.Enemy != None) && Bot(Controller).EnemyVisible() && (Bot(Controller).Skill < 5) )
			return;
		ShootMissile(P);
	}
}

DefaultProperties
{
 GunClass=Class'DC_Walker.Top_Turret'
 EntryRadius=380
 bHasAltFire=False
 EntryPosition=(Z=-300.0)
 FPCamPos=(X=-20.0,Z=40.0)
 TPCamLookat=(X=-20.0,Z=40.0)
 TPCamDistance=10
 TPCamDistRange=(Min=9,Max=11)
 DriverDamageMult=0.0
 VehiclePositionString="in a Walker turret"
 VehicleNameString="Death Turret"
 bDrawDriverInTP=false
}
