class HealthDropGameRules extends GameRules;

var float RewardScale, OverDamageScale, DropScale, DropSpread;
var float SST, MST, LST, GST;
var float MMD, LMD;
var bool  OnlyVials, AllowGrabOwn;
var float OverDamage;
var vector     DropVector, DropTarget;
var UniHealth  HealthProj;
var UniShield  ShieldProj;
var int        SpreadSize;

function int NetDamage( int OriginalDamage, int Damage, pawn injured, pawn instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
    if ( NextGameRules != None )
		damage= NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
    if (OnlyVials != true)
     SpawnHealth( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
    else
     SpawnVials( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );

    if (OverDamage > 0)
    {
      SpreadSize = (128 + VSize(instigatedBy.Location - injured.Location))*DropSpread;
      DropVector.X = SpreadSize/2 - Rand(SpreadSize);
      DropVector.Y = SpreadSize/2 - Rand(SpreadSize);
      DropVector.Z = SpreadSize - Rand(SpreadSize);
      ShieldProj = Spawn(Class'UniShield', , , injured.Location+Normal(DropVector)*(injured.CollisionRadius+42));
      ShieldProj.Velocity = DropVector;
      ShieldProj.Victim = injured;
      ShieldProj.AllowGrabOwn = AllowGrabOwn;
      ShieldProj.Capacity = OverDamage*OverDamageScale;
      ShieldProj.LifeTime = ShieldProj.Capacity/100*GST;
      OverDamage = 0;
    }

    return Damage;
}

function SpawnHealth( int OriginalDamage, int Damage, pawn injured, pawn instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
      SpreadSize = (128 + VSize(instigatedBy.Location - injured.Location))*DropSpread;
      DropTarget.X = SpreadSize/2 - Rand(SpreadSize);
      DropTarget.Y = SpreadSize/2 - Rand(SpreadSize);
      DropTarget.Z = SpreadSize/2 - Rand(SpreadSize);
      DropVector = DropScale*(instigatedBy.Location - injured.Location) + DropTarget;
      DropVector.Z = DropVector.Z + 200 + DropScale*250 - instigatedBy.CollisionRadius;
      HealthProj = Spawn(Class'UniHealth', , , injured.Location+Normal(DropVector)*(injured.CollisionRadius+42));
      HealthProj.Velocity = DropVector;
      if (OriginalDamage*RewardScale <= injured.Health)
       HealthProj.Capacity = OriginalDamage*RewardScale;
      else
       {
        HealthProj.Capacity = 100;
        OverDamage = OriginalDamage*RewardScale - injured.Health;
       }
      HealthProj.Victim = injured;
      HealthProj.AllowGrabOwn = AllowGrabOwn;
      HealthProj.MMD = MMD;
      HealthProj.LMD = LMD;

      if (Damage <= MMD)
        HealthProj.LifeTime = SST;
      else if (Damage <= LMD)
        HealthProj.LifeTime = MST;
      else
        HealthProj.LifeTime = LST;
}

function SpawnVials( int OriginalDamage, int Damage, pawn injured, pawn instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
      local int Vials, i;

      if (OriginalDamage*RewardScale <= injured.Health)
       Vials = OriginalDamage*RewardScale/5;
      else
       {
        Vials = 20;
        OverDamage = OriginalDamage*RewardScale - injured.Health;
       }

      for(i = 0; i<=Vials; i++)
      {
       SpreadSize = (128 + VSize(instigatedBy.Location - injured.Location))*DropSpread;
       DropTarget.X = SpreadSize/2 - Rand(SpreadSize);
       DropTarget.Y = SpreadSize/2 - Rand(SpreadSize);
       DropTarget.Z = SpreadSize/2 - Rand(SpreadSize);
       DropVector = DropScale*(instigatedBy.Location - injured.Location) + DropTarget;
       DropVector.Z = DropVector.Z + 200 + DropScale*250 - instigatedBy.CollisionRadius;
       HealthProj = Spawn(Class'UniHealth', , , injured.Location+Normal(DropVector)*(injured.CollisionRadius+42));
       HealthProj.Velocity = DropVector;
       HealthProj.Capacity = 5;
       HealthProj.Victim = injured;
       HealthProj.AllowGrabOwn = AllowGrabOwn;
       HealthProj.MMD = MMD;
       HealthProj.LMD = LMD;
       HealthProj.LifeTime = SST;
      }
}


defaultproperties
{
  RewardScale=1
  OverDamageScale=1
  DropScale=1
  DropSpread=0.2
  OnlyVials=false
  AllowGrabOwn = false
  MMD=15
  LMD=50
  SST=3
  MST=5
  LST=9
  GST=10
}
