class UniShield extends ShieldPickup notplaceable;

var float       Capacity, LifeTime, DieTime;
var bool        released;
var bool        AllowGrabOwn;

var Pawn                 Victim;
var Emitter              DieEffect;

auto state Pickup
{
	function Touch( actor Other )
	{
        local Pawn P;

		if ( (ValidTouch(Other)) && (Pawn(Other) != Victim) )
		{
			P = Pawn(Other);
            if ( P.AddShieldStrength(ShieldAmount) || !Level.Game.bTeamGame )
            {
				AnnouncePickup(P);
                SetRespawn();
                Destroy();
            }
		}
	}
}

function Release()
{
 NetUpdateFrequency = 30;
 bUpdateSimulatedPosition = true;
 bOnlyReplicateHidden = false;
 AddToNavigation();
 DieTime = Level.TimeSeconds + LifeTime;
 released = true;
}

simulated function Tick(float dt)
{
 local float Scaler;

 if (released != true)
  Release();

 if (LifeTime > 0)
  Scaler = (DieTime - Level.TimeSeconds)/LifeTime;
 else
  Scaler = 1;
 SetCollisionSize(24*Scaler, 24*Scaler);
 SetDrawScale(Scaler);
 RotationRate.Yaw = 128000*(1 - Scaler);
 ShieldAmount = Capacity*Scaler;

 if (Physics != Phys_Falling)
  {
   SetPhysics(Phys_Rotating);
   if (AllowGrabOwn == true)
    Victim = none;
  }

 if ((Level.TimeSeconds >= DieTime - 1) && (DieEffect == none)  && (LifeTime > 0))
    {
     DieEffect = Spawn(class'WeaponFadeEffect', self);
     DieEffect.Emitters[0]=none;
     DieEffect.Emitters[1]=none;
     DieEffect.SetLocation(Location);
    }

 if ((LifeTime > 0) && (Level.TimeSeconds >= DieTime))
  {
    RemoveFromNavigation();
    Destroy();
  }

 Super.Tick(dt);
}

static function string GetLocalString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	return"";
}

DefaultProperties
{
     Capacity=100
     LifeTime=5
     PickupMessage="+"
     PickupSound=Sound'PickupSounds.ShieldPack'
     PickupForce="ShieldPickup"
     DrawType=DT_StaticMesh
     Physics=PHYS_Falling
     StaticMesh=StaticMesh'E_Pickups.General.RegShield'
     DrawScale=1
     Style=STY_AlphaZ
     TransientSoundRadius=450.000000
     CollisionRadius=32.000000
     LifeSpan=1000000
}
