class UniHealth extends TournamentHealth notplaceable;

var StaticMesh  SSM, MSM, LSM;
var float       SDS, MDS, LDS;
var float       SCR, MCR, LCR;
var float       SRR, MRR, LRR;
var sound       SPS, MPS, LPS;
var float       MMD, LMD;
var bool        AllowGrabOwn;

var float       Capacity, LifeTime, DieTime, TransitScale, TransitRotRate, TransitColl;
var bool        released;

var Pawn                 Victim;
var Emitter              DieEffect;

static function StaticPrecache(LevelInfo L)
{
	L.AddPrecacheStaticMesh(StaticMesh'XPickups_rc.MiniHealthPack');
	L.AddPrecacheStaticMesh(StaticMesh'E_Pickups.Health.MidHealth');
	L.AddPrecacheStaticMesh(StaticMesh'E_Pickups.Health.SuperKeg');
}

auto state Pickup
{
	function Touch( actor Other )
	{
		local Pawn P;

		if ( (ValidTouch(Other)) && (Pawn(Other) != Victim) )
		{
			P = Pawn(Other);
            if ( P.GiveHealth(HealingAmount, GetHealMax(P)) || (bSuperHeal && !Level.Game.bTeamGame) )
            {
				AnnouncePickup(P);
                SetRespawn();
                Destroy();
            }
		}
	}
}


function Release()
{
 if ( Capacity <= MMD)
  {
   SetStaticMesh(SSM);
   TransitScale = SDS*Capacity/5;
   PickupSound = SPS;
   TransitColl =SCR;
   TransitRotRate = SRR;
   bSuperHeal=True;
  }
 else  if ( Capacity <= LMD)
  {
   SetStaticMesh(MSM);
   TransitScale = MDS*Capacity/25;
   PickupSound = MPS;
   TransitColl = MCR;
   TransitRotRate = MRR;
   bSuperHeal=False;
  }
 else
  {
   SetStaticMesh(LSM);
   TransitScale = LDS;
   PickupSound = LPS;
   TransitColl = LCR;
   TransitRotRate = LRR;
   bSuperHeal=True;
  }

 NetUpdateFrequency = 30;
 bUpdateSimulatedPosition = true;
 bOnlyReplicateHidden = false;
 AddToNavigation();
 DieTime = Level.TimeSeconds + LifeTime;
 released = true;
}

simulated function Tick(float dt)
{
 local float Scaler;

 if (released != true)
  Release();
 if (LifeTime > 0)
  Scaler = (DieTime - Level.TimeSeconds)/LifeTime;
 else
  Scaler = 1;
 SetCollisionSize(TransitColl*Scaler, TransitColl*Scaler);
 SetDrawScale(TransitScale*Scaler);
 RotationRate.Yaw = TransitRotRate*(1 - Scaler);
 HealingAmount = Capacity*Scaler;

 if (Physics != Phys_Falling)
  {
   SetPhysics(Phys_Rotating);
   if (AllowGrabOwn == true)
    Victim = none;
  }

 if ((Level.TimeSeconds >= DieTime - 1) && (DieEffect == none) && (LifeTime > 0))
    {
     DieEffect = Spawn(class'WeaponFadeEffect', self);
     DieEffect.Emitters[0]=none;
     DieEffect.Emitters[1]=none;
     DieEffect.SetLocation(Location);
    }

 if ((LifeTime > 0) && (Level.TimeSeconds >= DieTime))
  {
    RemoveFromNavigation();
    Destroy();
  }

 Super.Tick(dt);
}



static function string GetLocalString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	return"";
}


defaultproperties
{
 HealingAmount=0
 PickupMessage="+"
 PickupForce="HealthPack"
 DrawType=DT_StaticMesh

 SSM=StaticMesh'XPickups_rc.MiniHealthPack'
 SPS=Sound'PickupSounds.HealthPack'
 SDS=0.06
 SCR=24
 SRR = 128000

 MSM=StaticMesh'E_Pickups.Health.MidHealth'
 MPS=Sound'PickupSounds.HealthPack'
 MDS=0.3
 MCR=32
 MRR = 128000

 LSM=StaticMesh'E_Pickups.Health.SuperKeg'
 LPS=Sound'PickupSounds.LargeHealthPickup'
 LDS=0.4
 LCR=42
 LRR = 128000

 CullDistance=4500.000000
 AmbientGlow=64
 Physics=PHYS_Falling
 Style=STY_AlphaZ
 ScaleGlow=0.6
 LifeSpan=1000000
}
