class HealthDropMut extends Mutator;

var() config float RewardScale, OverDamageScale, DropScale, DropSpread;
var() config float SST, MST, LST, GST;
var() config float MMD, LMD;
var() config bool  OnlyVials, AllowGrabOwn;

static function FillPlayInfo(PlayInfo PlayInfo)
{
  Super.FillPlayInfo(PlayInfo);
  PlayInfo.AddSetting("SkyLines config:", "RewardScale", "Health drop percentage", 0, 1, "Text", "4;1:10000");
  PlayInfo.AddSetting("SkyLines config:", "OverDamageScale", "Shield drop percentage", 0, 2, "Text", "4;1:1000");
  PlayInfo.AddSetting("SkyLines config:", "DropScale", "Pickups drop velocity percentage", 0, 3, "Text", "4;1:200");
  PlayInfo.AddSetting("SkyLines config:", "DropSpread", "Drop spread percentage", 0, 4, "Text", "4;1:200");
  PlayInfo.AddSetting("SkyLines config:", "OnlyVials", "Only vials", 254,  5,  "Check");
  PlayInfo.AddSetting("SkyLines config:", "AllowGrabOwn", "Allow to grab own health", 254,  6,  "Check");
  PlayInfo.AddSetting("SkyLines config:", "SST", "Vials stay time, s", 0, 7, "Text", "4;0:30");
  PlayInfo.AddSetting("SkyLines config:", "MST", "Mid-packs stay time, s", 0, 8, "Text", "4;0:30");
  PlayInfo.AddSetting("SkyLines config:", "LST", "Large kegs stay time, s", 0, 9, "Text", "4;0:30");
  PlayInfo.AddSetting("SkyLines config:", "GST", "Shield packs stay time, s", 0, 10, "Text", "4;0:30");
  PlayInfo.AddSetting("SkyLines config:", "MMD", "Max vial capacity, HP", 0, 11, "Text", "4;0:100");
  PlayInfo.AddSetting("SkyLines config:", "LMD", "Max mid-pack capacity, HP", 0, 12, "Text", "4;0:100");
}

static event string GetDescriptionText(string PropName)
{
	switch (PropName)
	{
		case "RewardScale":	return "Health per damage interrelation, 100 for equal";
		case "OverDamageScale":	return "Shield per overdamage interrelation, 100 for equal";
		case "DropScale":	return "How far to throw pickups in shooter direction, 100 for full distance";
		case "DropSpread":	return "How much scatter pickups, 100 for totally random";
		case "OnlyVials":	return "Spawn several vials instead of bigger one";
		case "SST":	return "How relatively long will vials stay, 0 for infinity";
		case "MST":	return "How relatively long will mid-packs stay, 0 for infinity";
		case "LST":	return "How relatively long will large kegs stay, 0 for infinity";
		case "GST":	return "How relatively long will shield packs stay, 0 for infinity";
		case "MMD":	return "Maximum HP, for which small vial mesh used";
		case "LMD":	return "Maximum HP, for which mid-pack mesh used";
		case "AllowGrabOwn": return "Enables you to take your own lost health";
	}
	return Super.GetDescriptionText(PropName);
}



function PostBeginPlay()
{
	local GameRules G;

	Super.PostBeginPlay();
	G = spawn(class'HealthDropGameRules');
	HealthDropGameRules(G).RewardScale = RewardScale/100;
	HealthDropGameRules(G).OverDamageScale = OverDamageScale/100;
	HealthDropGameRules(G).DropScale = DropScale/100;
	HealthDropGameRules(G).DropSpread = DropSpread/100;
	HealthDropGameRules(G).SST = SST;
	HealthDropGameRules(G).MST = MST;
	HealthDropGameRules(G).LST = LST;
	HealthDropGameRules(G).GST = GST;
	HealthDropGameRules(G).MMD = MMD;
	HealthDropGameRules(G).LMD = LMD;
	HealthDropGameRules(G).OnlyVials = OnlyVials;
	HealthDropGameRules(G).AllowGrabOwn = AllowGrabOwn;
	if ( Level.Game.GameRulesModifiers == None )
		Level.Game.GameRulesModifiers = G;
	else
		Level.Game.GameRulesModifiers.AddGameRules(G);
	Destroy();
}

defaultproperties
{
  RewardScale=50
  OverDamageScale=100
  DropScale=100
  DropSpread=20
  OnlyVials=false
  AllowGrabOwn=false
  MMD=15
  LMD=50
  SST=5
  MST=10
  LST=15
  GST=30

  bAddToServerPackages=True
  GroupName="HealthDrop"
  FriendlyName="Health Drop"
  Description="Makes your enemy to vomit health"
}
