class UTItem_VehicleFreezingOrb extends UTItem_FreezingOrb;

var UTVehicle VehicleTarget;

var float PowerupYPos;

var MaterialInterface BackupMaterials[5];

replication
{
	if ((Role == ROLE_Authority) && bNetDirty)
    		VehicleTarget, BackupMaterials;
}

simulated function FreezeEnemy()
{
    local int x;

    Damage = int(30 * FMin((TimeRemaining / 15),1));

	if (VehicleTarget != None)
	{
  	    SetPlayerSettings(VehicleTarget);

        if (VehicleTarget.Seats.Length > 0)
		{
            for (x = 0; x < VehicleTarget.Seats.Length; x++)
    		{
    		    VehicleTarget.Seats[x].Gun.FireInterval[0] = VehicleTarget.Seats[x].Gun.default.FireInterval[0] * ((1 - FMin((TimeRemaining / 15),1)) * 2.5);
    		    VehicleTarget.Seats[x].Gun.FireInterval[1] = VehicleTarget.Seats[x].Gun.default.FireInterval[1] * ((1 - FMin((TimeRemaining / 15),1)) * 2.5);
                if (VehicleTarget.Seats[x].SeatPawn != None)
    		    {
    		        if (VehicleTarget.Seats[x].SeatPawn.Weapon != None)
    		        {
            		    VehicleTarget.Seats[x].SeatPawn.Weapon.FireInterval[0] = VehicleTarget.Seats[x].SeatPawn.Weapon.default.FireInterval[0] * ((1 - FMin((TimeRemaining / 15),1)) * 2.5);
            		    VehicleTarget.Seats[x].SeatPawn.Weapon.FireInterval[1] = VehicleTarget.Seats[x].SeatPawn.Weapon.default.FireInterval[1] * ((1 - FMin((TimeRemaining / 15),1)) * 2.5);
    		        }
                }
            }
    	}

        if (TimeRemaining > 10)
        {
    		if (VehicleTarget.Seats.Length > 0)
    		{
                for (x = 0; x < VehicleTarget.Seats.Length; x++)
        		{
        		    if (VehicleTarget.Seats[x].Gun.IsFiring())
        		    {
        		        VehicleTarget.Seats[x].Gun.StopFire(VehicleTarget.Seats[x].Gun.CurrentFireMode);
        		    }
        		    if (VehicleTarget.Seats[x].SeatPawn != None)
        		    {
    		            if (VehicleTarget.Seats[x].SeatPawn.Weapon != None)
    		            {
                            if (VehicleTarget.Seats[x].SeatPawn.Weapon.IsFiring())
                		    {
                		        VehicleTarget.Seats[x].SeatPawn.Weapon.StopFire(VehicleTarget.Seats[x].SeatPawn.Weapon.CurrentFireMode);
                		    }
            		    }
            		    SetPlayerSettings(VehicleTarget.Seats[x].SeatPawn,true);
        		    }
        		}
        	}
        	SetPlayerSettings(VehicleTarget,true);
        }

        if ((WorldInfo.TimeSeconds - LastTakeDamageTime) >= 1)
        {
    		if (VehicleTarget.Seats.Length > 0)
    		{
                for (x = 0; x < VehicleTarget.Seats.Length; x++)
        		{
        		    // Deal Damage To Passengers
        		    if (VehicleTarget.Seats[x].StoragePawn != None && UTPawn(VehicleTarget.Seats[x].StoragePawn) != None)
        		    {
                        UTPawn(VehicleTarget.Seats[x].StoragePawn).TakeDamage(Max(int(float(Damage)/5),1),OwnedBy,vect(0,0,0),vect(0,0,0),class'UTDmgType_Freeze');
                    }
        		}
        	}
            VehicleTarget.TakeDamage(Damage,OwnedBy,vect(0,0,0),vect(0,0,0),class'UTDmgType_Freeze');
	        LastTakeDamageTime = WorldInfo.TimeSeconds;
        }
    }
}


simulated function Freeze()
{
    local int x;

	if (bFrozen)
		return;

	bFrozen = true;

	LastTakeDamageTime = WorldInfo.TimeSeconds;

	if (VehicleTarget != None)
	{
		for (x = 0; x < VehicleTarget.Mesh.GetNumElements(); x++)
		{
			BackupMaterials[x] = VehicleTarget.Mesh.GetMaterial(x);
            VehicleTarget.Mesh.SetMaterial(x, FrozenMaterial);
		}

		if (VehicleTarget.Seats.Length > 0)
		{
            for (x = 0; x < VehicleTarget.Seats.Length; x++)
    		{
    		    if (VehicleTarget.Seats[x].Gun.IsFiring())
    		    {
    		        VehicleTarget.Seats[x].Gun.StopFire(VehicleTarget.Seats[x].Gun.CurrentFireMode);
    		    }
    		    if (VehicleTarget.Seats[x].SeatPawn != None)
    		    {
    		        if (VehicleTarget.Seats[x].SeatPawn.Weapon != None)
                    {
                        if (VehicleTarget.Seats[x].SeatPawn.Weapon.IsFiring())
            		    {
            		        VehicleTarget.Seats[x].SeatPawn.Weapon.StopFire(VehicleTarget.Seats[x].SeatPawn.Weapon.CurrentFireMode);
            		    }
        		    }
    		    }
    		}

    	}

        SetTimer(0.1, true, 'FreezeEnemy');
	}
}

simulated function UnFreeze()
{
    local int x;

	if (!bFrozen)
		return;

	bFrozen = false;

	if (VehicleTarget != None)
	{
   		for (x = 0; x < VehicleTarget.Mesh.GetNumElements(); x++)
		{
            VehicleTarget.Mesh.SetMaterial(x, BackupMaterials[x]);
		}
        SetPlayerSettings(VehicleTarget);

		if (VehicleTarget.Seats.Length > 0)
		{
            for (x = 0; x < VehicleTarget.Seats.Length; x++)
    		{
    		    VehicleTarget.Seats[x].Gun.FireInterval[0] = VehicleTarget.Seats[x].Gun.default.FireInterval[0];
    		    VehicleTarget.Seats[x].Gun.FireInterval[1] = VehicleTarget.Seats[x].Gun.default.FireInterval[1];

                if (VehicleTarget.Seats[x].SeatPawn != None)
    		    {
                    if (VehicleTarget.Seats[x].SeatPawn.Weapon != None)
        		    {
            		    VehicleTarget.Seats[x].SeatPawn.Weapon.FireInterval[0] = VehicleTarget.Seats[x].SeatPawn.Weapon.default.FireInterval[0];
            		    VehicleTarget.Seats[x].SeatPawn.Weapon.FireInterval[1] = VehicleTarget.Seats[x].SeatPawn.Weapon.default.FireInterval[1];
        		    }
    		    }
    		    SetPlayerSettings(VehicleTarget.Seats[x].SeatPawn);
            }
    	}
    }
}

defaultproperties
{
    PowerupYPos=0.75
}