class UTItem_FreezingOrb extends UTTimedPowerup;

var Material FrozenMaterial;
var bool bFrozen;

var UTPawn Target;
var Controller OwnedBy;

var int Damage;

var float LastTakeDamageTime;

replication
{
	if ((Role == ROLE_Authority) && bNetDirty)
    		bFrozen, Target, OwnedBy, Damage, LastTakeDamageTime;
}

simulated function DisplayPowerup(Canvas Canvas, UTHud HUD, float ResolutionScale,out float YPos)
{
	local float FlashAlpha, Scaler;
	local float XPos;
	local string TimeRemainingAsString;
	local int TimeRemainingAsInt;
	local LinearColor TeamColor;
	`log("Inside Display Powerup Function!");

	if (TransitionTime > 0.0)
	{
		TransitionTime -= HUD.RenderDelta;
		if (TransitionTime < 0.0)
		{
			TransitionTime = 0.0;
		}
	}

	Scaler = TransitionTime / TransitionDuration;
	if (TimeRemaining < 1.0)
	{
		FlashAlpha = TimeRemaining;
	}
	else
	{
		FlashAlpha = (TimeRemaining <= WarningTime) ? 0.25 + (0.75*abs(cos(TimeRemaining))) : 1.0;
	}

	// Draw the icon
	TeamColor = Hud.TeamHudColor;
	TeamColor.A = FlashAlpha;
	Scaler = 1.0 + (12 * Scaler);
	XPos = (Canvas.ClipX * 0.025);
	Canvas.SetPos(XPos+20 * ResolutionScale, YPos+20 * ResolutionScale);
	Hud.DrawTileCentered(Hud.AltHudTexture, IconCoords.UL * ResolutionScale * Scaler , IconCoords.VL * ResolutionScale * Scaler, IconCoords.U, IconCoords.V, IconCoords.UL, IconCoords.VL, TeamColor);

	// Draw the Time Remaining;
    TimeRemainingAsInt = Max(0, int(TimeRemaining+1));
	TimeRemainingAsString = string(TimeRemainingAsInt);

	XPos += (35 * ResolutionScale);
	Canvas.SetDrawColor(0,0,128,255*FlashAlpha);
	Hud.DrawGlowText(TimeRemainingAsString, XPos, YPos, 40 * ResolutionScale);

	YPos -= 50 * ResolutionScale;
}

simulated function SetPlayerSettings(Pawn Other, optional bool bFroze)
{
    local float FreezePercent;

    FreezePercent = (1 - FMin((TimeRemaining / 15),1));

    if (!bFrozen)
    {
        if (Other.IsA('UTPawn'))
        {
            UTPawn(Other).FireRateMultiplier = UTPawn(Other).default.FireRateMultiplier;
        	UTPawn(Other).DodgeSpeed = UTPawn(Other).default.DodgeSpeed;
        	UTPawn(Other).DodgeSpeedZ = UTPawn(Other).default.DodgeSpeedZ;
        }
        else if (Other.IsA('UTVehicle'))
        {
            UTVehicle(Other).MaxSpeed = UTVehicle(Other).default.MaxSpeed;
        }
        Other.GroundSpeed = Other.default.GroundSpeed;
    	Other.AirSpeed = Other.default.AirSpeed;
    	Other.WaterSpeed = Other.default.WaterSpeed;
        Other.JumpZ = Other.default.JumpZ;
        Other.AirControl = Other.default.AirControl;
        Other.AccelRate = Other.default.AccelRate;
    }
    else
    {
        if (Other.IsA('UTPawn'))
        {
            UTPawn(Other).FireRateMultiplier = UTPawn(Other).default.FireRateMultiplier + (FreezePercent * 2.5);
        	UTPawn(Other).DodgeSpeed = UTPawn(Other).default.DodgeSpeed * FreezePercent;
        	UTPawn(Other).DodgeSpeedZ = UTPawn(Other).default.DodgeSpeedZ * FreezePercent;
        }
        else if (Other.IsA('UTVehicle'))
        {
            UTVehicle(Other).MaxSpeed = UTVehicle(Other).default.MaxSpeed * FreezePercent;
        }
        Other.GroundSpeed = Other.default.GroundSpeed * FreezePercent;
		Other.AirSpeed = Other.default.AirSpeed * FreezePercent;
		Other.WaterSpeed = Other.default.WaterSpeed * FreezePercent;
        Other.JumpZ = Other.default.JumpZ * FreezePercent;
        Other.AirControl = Other.default.AirControl * FreezePercent;
        Other.AccelRate = Other.default.AccelRate * FreezePercent;

    }
    if (Other.IsA('UTPawn'))
    {
        UTPawn(Other).bCanFly = UTPawn(Other).default.bCanFly;
        UTPawn(Other).bCanDoubleJump = UTPawn(Other).default.bCanDoubleJump;
    }
    Other.bCanJump = Other.default.bCanJump;
    Other.bCanWalk = Other.default.bCanWalk;
    Other.bCanSwim = Other.default.bCanSwim;
    Other.bCanClimbLadders = Other.default.bCanClimbLadders;
    Other.bCanClimbCeilings = Other.default.bCanClimbCeilings;
    Other.bCanStrafe = Other.default.bCanStrafe;
    Other.bNoWeaponFiring = Other.default.bNoWeaponFiring;
    Other.bStationary = Other.default.bStationary;
    if (bFroze)
    {
        if (Other.IsA('UTPawn'))
        {
            UTPawn(Other).bCanFly = false;
            UTPawn(Other).bCanDoubleJump = false;
        }
        Other.bCanJump = false;
        Other.bCanWalk = false;
        Other.bCanSwim = false;
        Other.bCanClimbLadders = false;
        Other.bCanClimbCeilings = false;
        Other.bCanStrafe = false;
        Other.bNoWeaponFiring = true;
        Other.bStationary = true;
    }
}

simulated static function AddWeaponOverlay(UTGameReplicationInfo GRI)
{
	GRI.WeaponOverlays[2] = default.FrozenMaterial;
}

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	super.GivenTo(NewOwner, bDoNotActivate);

	Freeze();
}

function ItemRemovedFromInvManager()
{
	UnFreeze();
	ClearTimer();
}

simulated function FreezeEnemy()
{
    Damage = int(15 * FMin((TimeRemaining / 15),1));

	if (Target != None)
	{
	    SetPlayerSettings(Target);

        if (TimeRemaining > 10)
        {
         	if (Target.Weapon.IsFiring())
        	{
        		Target.Weapon.StopFire(Target.Weapon.CurrentFireMode);
        	}
        	SetPlayerSettings(Target,true);
        }

        if ((WorldInfo.TimeSeconds - LastTakeDamageTime) >= 1)
        {
            Target.TakeDamage(Damage,OwnedBy,vect(0,0,0),vect(0,0,0),class'UTDmgType_Freeze');
	        LastTakeDamageTime = WorldInfo.TimeSeconds;
        }
	}
}

simulated function Freeze()
{
    if (bFrozen)
		return;

	bFrozen = true;

	LastTakeDamageTime = WorldInfo.TimeSeconds;

	if (Target != None)
	{
		Target.SetSkin(FrozenMaterial);
		Target.SetWeaponOverlayFlag(2);

     	if (Target.Weapon.IsFiring())
    	{
    		Target.Weapon.StopFire(Target.Weapon.CurrentFireMode);
    	}

        SetTimer(0.1, true, 'FreezeEnemy');
	}
}

simulated function UnFreeze()
{
	if (!bFrozen)
		return;

	bFrozen = false;

	if (Target != None)
	{
		Target.SetSkin(none);
		Target.ClearWeaponOverlayFlag(2);
        SetPlayerSettings(Target);
    }
}
simulated function OwnerEvent(name EventName)
{
	if (EventName == 'TakeDamage')
	{
	    // To Do: Add Shattering Kill
	}
}

defaultproperties
{
    FrozenMaterial=Material'FreezeRayContent.Materials.MT_Frozen'
    Damage = 5
    TimeRemaining = 20
	WarningTime=0.0
	bReceiveOwnerEvents=True
}