class Mutator_FreezeRay extends UTMutator;

function bool CheckReplacement(Actor Other)
{
	local UTWeaponPickupFactory WeaponPickup;
	local UTWeaponLocker Locker;
	local UTAmmoPickupFactory AmmoPickup;
	local int i;

	WeaponPickup = UTWeaponPickupFactory(Other);
	Locker = UTWeaponLocker(Other);
	AmmoPickup = UTAmmoPickupFactory(Other);

	if (WeaponPickup != None)
	{
		if (WeaponPickup.WeaponPickupClass == class'UTWeap_ShockRifle')
		{
			WeaponPickup.WeaponPickupClass = class'UTWeap_FreezeRay';
			WeaponPickup.InitializePickup();
		}
	}
	if (Locker != None)
	{
		for (i = 0; i < Locker.Weapons.length; i++)
		{
			if (Locker.Weapons[i].WeaponClass != None)
			{
				if (Locker.Weapons[i].WeaponClass == class'UTWeap_ShockRifle')
				{
					Locker.ReplaceWeapon(i, class'UTWeap_FreezeRay');
				}
			}
		}
	}
	if (AmmoPickup != None)
	{
		if (AmmoPickup.TargetWeapon == Class'UTWeap_ShockRifle')
		{
			AmmoPickup.TransformAmmoType(class'UTAmmo_FreezeRay');
		}
	}

	if (Other.IsA('UTWeap_ShockRifle') && !Other.IsA('UTWeap_FreezeRay'))
	{
	    return false;
	}

	return true;
}


defaultproperties
{
}