class UTWeap_FreezeRay extends UTWeap_ShockRifle;

var array<MaterialInterface> TeamSkins;
var array<ParticleSystem> TeamMuzzleFlashes;

simulated function SetSkin(Material NewMaterial)
{
	local int TeamIndex;

	if ( NewMaterial == None ) 	// Clear the materials
	{
		if ( Instigator != None )
		{
			TeamIndex = Instigator.GetTeamNum();
		}
		if (TeamIndex > TeamSkins.length)
		{
			TeamIndex = 0;
		}
		Mesh.SetMaterial(0,TeamSkins[TeamIndex]);
	}
	else
	{
		Super.SetSkin(NewMaterial);
	}
}

simulated function AttachWeaponTo(SkeletalMeshComponent MeshCpnt, optional name SocketName)
{
	local int TeamIndex;

	TeamIndex = Instigator.GetTeamNum();
	if (TeamIndex > TeamMuzzleFlashes.length)
	{
		TeamIndex = 0;
	}
	MuzzleFlashPSCTemplate = TeamMuzzleFlashes[TeamIndex];

	Super.AttachWeaponTo(MeshCpnt, SocketName);
}

simulated function ProcessInstantHit( byte FiringMode, ImpactInfo Impact )
{
    local UTItem_FreezingOrb FreezingOrb;
    local UTItem_VehicleFreezingOrb VFO;
    local float FrozenDuration;

	super.ProcessInstantHit(FiringMode, Impact);

	if (Impact.HitActor != None && !Impact.HitActor.bStatic && (Impact.HitActor != Instigator) )
	{
        FrozenDuration = 3;

        if (FiringMode == 1) FrozenDuration = 20;

	    if (UTVehicle(Impact.HitActor) != None && UTVehicle(Impact.HitActor).Health > 0 && UTVehicle(Impact.HitActor).Occupied())
	    {
            if (ClassIsChildOf(WorldInfo.GetGameClass(),class'UTTeamGame'))
            {
                if (UTVehicle(Impact.HitActor).GetTeamNum() != UTPawn(Instigator).GetTeamNum())
                {
                    VFO = UTItem_VehicleFreezingOrb(UTVehicle(Impact.HitActor).FindInventoryType(class'UTItem_VehicleFreezingOrb'));

                    if (VFO == None)
                    {
                        VFO = Spawn(class'UTItem_VehicleFreezingOrb');

                        if (VFO != None)
                        {
                            VFO.VehicleTarget = UTVehicle(Impact.HitActor);
                            VFO.OwnedBy = UTPawn(Instigator).Controller;
                            VFO.TimeRemaining = FrozenDuration;
                            VFO.GiveTo(UTVehicle(Impact.HitActor));
                        }
                    }
                    else
                    {
                        VFO.VehicleTarget = UTVehicle(Impact.HitActor);
                        VFO.OwnedBy = UTPawn(Instigator).Controller;
                        if (FiringMode == 1)
                           VFO.TimeRemaining = FMin(VFO.TimeRemaining + FrozenDuration, 20);
                        else
                           VFO.TimeRemaining = FMax(FMin(VFO.TimeRemaining + FrozenDuration, 15),VFO.TimeRemaining);
                    }
                }
                else
                {
                    VFO = UTItem_VehicleFreezingOrb(UTVehicle(Impact.HitActor).FindInventoryType(class'UTItem_VehicleFreezingOrb'));

                    if (VFO != None)
                    {
                        VFO.Destroy();
                    }
                }
            }
            else
            {
                VFO = UTItem_VehicleFreezingOrb(UTVehicle(Impact.HitActor).FindInventoryType(class'UTItem_VehicleFreezingOrb'));

                if (VFO == None)
                {
                    VFO = Spawn(class'UTItem_VehicleFreezingOrb');

                    if (VFO != None)
                    {
                        VFO.VehicleTarget = UTVehicle(Impact.HitActor);
                        VFO.OwnedBy = UTPawn(Instigator).Controller;
                        VFO.TimeRemaining = FrozenDuration;
                        VFO.GiveTo(UTVehicle(Impact.HitActor));
                    }
                }
                else
                {
                    VFO.VehicleTarget = UTVehicle(Impact.HitActor);
                    VFO.OwnedBy = UTPawn(Instigator).Controller;
                    if (FiringMode == 1)
                       VFO.TimeRemaining = FMin(VFO.TimeRemaining + FrozenDuration, 20);
                    else
                        VFO.TimeRemaining = FMax(FMin(VFO.TimeRemaining + FrozenDuration, 15),VFO.TimeRemaining);
                }
            }
	    }

        if (UTPawn(Impact.HitActor) != None && UTPawn(Impact.HitActor).Health > 0 && UTPawn(Impact.HitActor).ShieldBeltArmor == 0)
        {
            if (ClassIsChildOf(WorldInfo.GetGameClass(),class'UTTeamGame'))
            {
                if (UTPawn(Impact.HitActor).GetTeamNum() != UTPawn(Instigator).GetTeamNum())
                {
                    FreezingOrb = UTItem_FreezingOrb(UTPawn(Impact.HitActor).FindInventoryType(class'UTItem_FreezingOrb'));

                    if (FreezingOrb == None)
                    {
                        FreezingOrb = Spawn(class'UTItem_FreezingOrb');

                        if (FreezingOrb != None)
                        {
                            FreezingOrb.Target = UTPawn(Impact.HitActor);
                            FreezingOrb.OwnedBy = UTPawn(Instigator).Controller;
                            FreezingOrb.TimeRemaining = FrozenDuration;
                            FreezingOrb.GiveTo(UTPawn(Impact.HitActor));
                        }
                    }
                    else
                    {
                        FreezingOrb.Target = UTPawn(Impact.HitActor);
                        FreezingOrb.OwnedBy = UTPawn(Instigator).Controller;
                        if (FiringMode == 1)
                           FreezingOrb.TimeRemaining = FMin(FreezingOrb.TimeRemaining + FrozenDuration, 20);
                        else
                           FreezingOrb.TimeRemaining = FMax(FMin(FreezingOrb.TimeRemaining + FrozenDuration, 15),FreezingOrb.TimeRemaining);
                    }
                }
                else
                {
                    FreezingOrb = UTItem_FreezingOrb(UTPawn(Impact.HitActor).FindInventoryType(class'UTItem_FreezingOrb'));

                    if (FreezingOrb != None)
                    {
                        FreezingOrb.Destroy();
                    }
                }
            }
            else
            {
                FreezingOrb = UTItem_FreezingOrb(UTPawn(Impact.HitActor).FindInventoryType(class'UTItem_FreezingOrb'));

                if (FreezingOrb == None)
                {
                    FreezingOrb = Spawn(class'UTItem_FreezingOrb');

                    if (FreezingOrb != None)
                    {
                        FreezingOrb.Target = UTPawn(Impact.HitActor);
                        FreezingOrb.OwnedBy = UTPawn(Instigator).Controller;
                        FreezingOrb.TimeRemaining = FrozenDuration;
                        FreezingOrb.GiveTo(UTPawn(Impact.HitActor));
                    }
                }
                else
                {
                    FreezingOrb.Target = UTPawn(Impact.HitActor);
                    FreezingOrb.OwnedBy = UTPawn(Instigator).Controller;
                    if (FiringMode == 1)
                       FreezingOrb.TimeRemaining = FMin(FreezingOrb.TimeRemaining + FrozenDuration, 20);
                    else
                       FreezingOrb.TimeRemaining = FMax(FMin(FreezingOrb.TimeRemaining + FrozenDuration, 15),FreezingOrb.TimeRemaining);
                }
            }
        }
	}
}

defaultproperties
{
	MuzzleFlashSocket=MF
	MuzzleFlashPSCTemplate=WP_Shockrifle.Particles.P_Shockrifle_Instagib_MF_Blue
	MuzzleFlashAltPSCTemplate=WP_Shockrifle.Particles.P_Shockrifle_Instagib_MF_Blue
	MuzzleFlashDuration=0.33;

	WeaponColor=(R=160,G=0,B=255,A=255)
	FireInterval(0)=+0.77
	FireInterval(1)=+1.5
	FireOffset=(X=20,Y=5)
	PlayerViewOffset=(X=17,Y=10.0,Z=-8.0)
	bCanThrow=false

	AttachmentClass=class'UTAttachment_FreezeRay'

    WeaponFireTypes(0)=EWFT_InstantHit
	WeaponFireTypes(1)=EWFT_InstantHit
	InstantHitDamage(0)=15
	InstantHitDamage(1)=20
	InstantHitMomentum(0)=0
	InstantHitMomentum(1)=0
	WeaponProjectiles(1)=None

	InstantHitDamageTypes(0)=class'UTDmgType_Freeze'
	InstantHitDamageTypes(1)=class'UTDmgType_Freeze'

	WeaponFireAnim(0)=WeaponFireInstigib
	WeaponFireAnim(1)=WeaponFireInstigib

	WeaponFireSnd[0]=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_InstagibFireCue'
	WeaponFireSnd[1]=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_InstagibFireCue'
	WeaponEquipSnd=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_RaiseCue'
	WeaponPutDownSnd=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_LowerCue'

	bInstantHit=true
	bSplashJump=false
	bRecommendSplashDamage=false
	bSniping=true
	ShouldFireOnRelease(0)=0
	ShouldFireOnRelease(1)=0

	AmmoCount=50
	LockerAmmoCount=75
	MaxAmmoCount=100

	PickupSound=SoundCue'A_Pickups.Weapons.Cue.A_Pickup_Weapons_Shock_Cue'

	ShotCost(0)=1
	ShotCost(1)=3

	IconX=400
	IconY=129
	IconWidth=22
	IconHeight=48
	IconCoordinates=(U=722,V=479,UL=166,VL=42)

	TeamSkins[0]=MaterialInterface'WP_ShockRifle.Materials.M_WP_ShockRifle_Instagib_Blue'
	TeamSkins[1]=MaterialInterface'WP_ShockRifle.Materials.M_WP_ShockRifle_Instagib_Blue'
	TeamMuzzleFlashes[0]=ParticleSystem'WP_Shockrifle.Particles.P_Shockrifle_Instagib_MF_Blue'
	TeamMuzzleFlashes[1]=ParticleSystem'WP_Shockrifle.Particles.P_Shockrifle_Instagib_MF_Blue'
	CrossHairCoordinates=(U=320,V=0,UL=64,VL=64)

	ItemName = "Freeze Ray"
    PickupMessage = "Freeze Ray"
 }