class MissionInfoGUI extends FloatingWindow;

var protected string Text;

var automated GUIButton CloseWindowButton, PlayButton;
var automated GUIScrollTextBox ItemDesc;
var automated GUILabel MissionDifficulty;

function OnOpen()
{
    local INVInventory INVInventory;

   	INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());
   	if(INVInventory != none)
   	{
        INVInventory.bMissionInfoOpen = true;
        INVInventory.MissionInfoGUI = self;
        CloseWindowButton.OnClick = XButtonClicked;
        PlayButton.OnClick = PlayClicked;
        UpdateDescription();
    }
}

function OnClose(optional bool bCancelled)
{
    local INVInventory INVInventory;

    INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());
    if(INVInventory != none)
    {
        INVInventory.bMissionInfoOpen = false;
        INVInventory.MissionInfoGUI = none;
    }
}

function UpdateDescription()
{
    local PlayerController C;
    local INVInventory INVInventory;

   	INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());
   	if(INVInventory == none)
   	    return;

    C = PlayerOwner();
    MissionDifficulty.Caption = ("Difficulty:" @ INVInventory.MissionItem.default.MissionDifficulty);
    Text = INVInventory.MissionItem.static.GetDescription(C);
    ItemDesc.SetContent(Text);
}

function bool PlayClicked(GUIComponent Sender)
{
    PlayerOwner().TextToSpeech(Text, 255);
    return true;
}

defaultproperties
{
    Begin Object Class=GUILabel Name=MissionD
        Caption="Difficulty: Unknown"
        TextColor=(B=255,G=255,R=255)
        WinTop=0.050000
        WinLeft=0.050000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    MissionDifficulty=MissionD

    Begin Object Class=GUIButton Name=CloseButton
        Caption="Close"
        WinTop=0.8500000
        WinLeft=0.050000
        WinWidth=0.900000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    CloseWindowButton=CloseButton

    Begin Object Class=GUIButton Name=PButton
        Caption="Play"
        WinTop=0.050000
        WinLeft=0.850000
        WinWidth=0.100000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    PlayButton=PButton

    Begin Object Class=GUIScrollTextBox Name=ItemDescription
		WinWidth=0.900000
		WinHeight=0.700000
		WinLeft=0.050000
		WinTop=0.150000
        CharDelay=0.0025
        EOLDelay=0.5
        bNoTeletype=True
        bNeverFocus=true
        StyleName="NoBackground"
        bTabStop=False
    End Object
    ItemDesc=ItemDescription

    DefaultWidth=0.500000
    DefaultHeight=0.500000
    DefaultLeft=0.250000
    DefaultTop=0.000000
    WinWidth=0.500000
	WinHeight=0.500000
	WinLeft=0.250000
	WinTop=0.000000

    WindowName="Mission Information"

    bRenderWorld=True
    bAllowedAsLast=True
    bResizeWidthAllowed=False
 	bResizeHeightAllowed=False
 	bMoveAllowed=True
}
