class EscortSM extends StaticMeshActor;

replication
{
	reliable if(ROLE==ROLE_Authority)
		SetClientSkin;
}

function PostBeginPlay()
{
    SetClientSkin(Owner);
    super.PostBeginPlay();
}

protected simulated function SetClientSkin(Actor myOwner)
{
    if(ROLE<ROLE_Authority && Level != none && Level.GetLocalPlayerController() == myOwner)
        Skins[0] = Shader'ONSstructureTextures.CoreEnergyShaderBlue';
}

function Tick(float DeltaTime)
{
    if(Owner == none)
        Destroy();
    super.Tick(DeltaTime);
}

defaultproperties
{
	bCollideActors=false
	bBlockActors=false
	bBlockKarma=false
	bWorldGeometry=false
	bStatic=false
	bNetInitial=true
	bUnlit=True
	bAlwaysRelevant=True
	StaticMesh=StaticMesh'VMStructures.CoreGroup.CoreShieldSM'
	DrawScale3D=(X=1,Y=1,Z=10)
}
