class MissionHudClass extends KMenuClass;

var class<MissionFile> DefaultMission;
var sound NextPageSound;
var Material ScrollBlury, ScrollPressed, ScrollWatched, ContextBGMat;
var protected array<ItemPosStruct> ItemPos;
var protected array<string> ContextArray;
var protected array<class<MissionFile> > AvailableMissions;
var protected bool bContextOpen, bContextOpened, bMouseInContext;
var protected float ContextPosY, ContextPosX, ContextBorder, ScrollBarLocation, ItemLengthY[5], ItemLengthX[5], ContextW, ContextH;
var protected byte PItemNum, ContextNum;

function PostRender(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory)
{
    super.PostRender(InteractionOwner, Canvas, INVInventory);
    DrawMainGUI(InteractionOwner, Canvas, INVInventory);
    bMouseInContext = false;
    if(bContextOpen)
        DrawContextMenu(InteractionOwner, Canvas, INVInventory);
}

protected function DrawMainGUI(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory)
{
    local int i, x;
    local float LastPos, XL, YL, ScrollHeight;
    local color MissionColor;

    Canvas.DrawColor = DefaultColor;
    SetPos(Canvas, Canvas.ClipX*0.025, Canvas.ClipY*0.025);
    Canvas.DrawTileStretched(Texture(EmptySlotImage), Canvas.ClipX*0.275, Canvas.ClipY*0.15);
    LastPos = 0.035;
    MissionColor = InteractionOwner.WhiteColor;
    for(i=0;i<5;i++)
    {
        if(INVInventory.DataRep.CurrentMission == AvailableMissions[i+PItemNum])
            MissionColor = class'mutInventorySystem'.default.YellowColor;
        else
        {
            for(x=0;x<INVInventory.DataRep.CompletedMissions.Length;x++)
            {
                if(INVInventory.DataRep.CompletedMissions[x] == AvailableMissions[i+PItemNum])
                {
                    MissionColor = class'mutInventorySystem'.default.GreenColor;
                    x = INVInventory.DataRep.CompletedMissions.Length;
                }
            }
            if(MissionColor == InteractionOwner.WhiteColor)
                MissionColor = class'mutInventorySystem'.default.RedColor;
        }
        Canvas.DrawColor = MissionColor;
        SetPos(Canvas, Canvas.ClipX*0.035, Canvas.ClipY*LastPos);
        Canvas.DrawText(AvailableMissions[i+PItemNum].default.MissionName);
        Canvas.TextSize(AvailableMissions[i+PItemNum].default.MissionName, XL, YL);
        ItemLengthY[i] = YL;
        ItemLengthX[i] = XL;
        MissionColor = InteractionOwner.WhiteColor;
        LastPos += YL/Canvas.ClipY;
    }
    for(i=0;i<ItemPos.length;i++)
    {
        Canvas.DrawColor = DefaultColor;
        SetPos(Canvas, Canvas.ClipX*ItemPos[i].XTL, Canvas.ClipY*ItemPos[i].YTL);
        if(i == 2)
            Canvas.DrawTileStretched(Texture(ItemPos[i].BGImage), Canvas.ClipX*ItemPos[i].XH, Canvas.ClipY*ItemPos[i].YH);
        else
            Canvas.DrawRect(Texture(ItemPos[i].BGImage), Canvas.ClipX*ItemPos[i].XH, Canvas.ClipY*ItemPos[i].YH);
    }
    ScrollHeight = fMax(0.015, (ItemPos[2].YH)/AvailableMissions.length);
    SetPos(Canvas, Canvas.ClipX*ItemPos[2].XTL, Canvas.ClipY*(ItemPos[2].YTL+(((ItemPos[2].YH+ScrollHeight)/AvailableMissions.length)*PItemNum)));
    Canvas.DrawTileStretched(Texture(ScrollBlury), Canvas.ClipX*ItemPos[2].XH, Canvas.ClipY*ScrollHeight);
}

function bool KeyEvent(InventoryInteraction InteractionOwner, EInputKey Key, EInputAction Action, float Delta)
{
    local string TouchingImage;
    local bool bIsValidClick;
    local int i;
    local float LastPos;

    if(Key == IK_MouseWheelDown && PItemNum+5 < AvailableMissions.length
    && InteractionOwner.ViewportOwner.WindowsMouseX >= InteractionOwner.ClipX*0.025+(InteractionOwner.ClipX*WindowLocX)
    && InteractionOwner.ViewportOwner.WindowsMouseX <= (InteractionOwner.ClipX*0.025)+(InteractionOwner.ClipX*WindowLocX)+InteractionOwner.ClipX*0.275
    && InteractionOwner.ViewportOwner.WindowsMouseY >= InteractionOwner.ClipY*0.025+(InteractionOwner.ClipY*WindowLocY)
    && InteractionOwner.ViewportOwner.WindowsMouseY <= (InteractionOwner.ClipY*0.025)+(InteractionOwner.ClipY*WindowLocY)+InteractionOwner.ClipY*0.15)
    {
        bContextOpen = false;
        PItemNum++;
        InteractionOwner.ViewportOwner.Actor.ClientPlaySound(NextPageSound,true,2);
        return true;
    }
    else if(Key == IK_MouseWheelUp && PItemNum >= 1
    && InteractionOwner.ViewportOwner.WindowsMouseX >= InteractionOwner.ClipX*0.025+(InteractionOwner.ClipX*WindowLocX)
    && InteractionOwner.ViewportOwner.WindowsMouseX <= (InteractionOwner.ClipX*0.025)+(InteractionOwner.ClipX*WindowLocX)+InteractionOwner.ClipX*0.275
    && InteractionOwner.ViewportOwner.WindowsMouseY >= InteractionOwner.ClipY*0.025+(InteractionOwner.ClipY*WindowLocY)
    && InteractionOwner.ViewportOwner.WindowsMouseY <= (InteractionOwner.ClipY*0.025)+(InteractionOwner.ClipY*WindowLocY)+InteractionOwner.ClipY*0.15)
    {
        PItemNum--;
        bContextOpen = false;
        InteractionOwner.ViewportOwner.Actor.ClientPlaySound(NextPageSound,true,2);
        return true;
    }
    else if(Key == IK_LeftMouse)
    {
        TouchingImage = InteractionOwner.bTouchingImage();
        if(!bMouseInContext)
        {
            LastPos = 0.035;
            for(i=0;i<5;i++)
            {
                if(InteractionOwner.ViewportOwner.WindowsMouseX >= InteractionOwner.ClipX*0.035+(InteractionOwner.ClipX*WindowLocX)
                && InteractionOwner.ViewportOwner.WindowsMouseX <= InteractionOwner.ClipX*0.035+(InteractionOwner.ClipX*WindowLocX)+ItemLengthX[i]
                && InteractionOwner.ViewportOwner.WindowsMouseY >= InteractionOwner.ClipY*LastPos+(InteractionOwner.ClipY*WindowLocY)
                && InteractionOwner.ViewportOwner.WindowsMouseY <= InteractionOwner.ClipY*LastPos+(InteractionOwner.ClipY*WindowLocY)+ItemLengthY[i])
                {
                    GetImageContextArray(InteractionOwner, class'mutInventorySystem'.static.FindINVInventory(InteractionOwner.ViewportOwner.Actor), i+PItemNum);
                    bContextOpen = true;
                    bContextOpened = false;
                    bIsValidClick = true;
                    InteractionOwner.bLeftClicked = false;
                    ContextNum = i;
                    ContextPosY = InteractionOwner.ViewportOwner.WindowsMouseY;
                    ContextPosX = InteractionOwner.ViewportOwner.WindowsMouseX;
                    break;
                }
                LastPos += ItemLengthY[i]/InteractionOwner.ClipY;
            }
        }
        if(bContextOpen && !bIsValidClick)
        {
            if(!bMouseInContext)
            {
                bContextOpen = false;
                bContextOpened = false;
                ContextArray.Length = 0;
            }
            return true;
        }
        else if(TouchingImage ~= "UpArrow" && PItemNum >= 1)
        {
            bContextOpen = false;
            PItemNum--;
            InteractionOwner.ViewportOwner.Actor.ClientPlaySound(NextPageSound,true,2);
            return true;
        }
        else if(TouchingImage ~= "DownArrow" && PItemNum+5 < AvailableMissions.length)
        {
            bContextOpen = false;
            PItemNum++;
            InteractionOwner.ViewportOwner.Actor.ClientPlaySound(NextPageSound,true,2);
            return true;
        }
    }
    return super.KeyEvent(InteractionOwner, Key, Action, Delta);
}

protected function GetImageContextArray(InventoryInteraction InteractionOwner, INVInventory INVInventory, int ItemNum)
{
    ContextArray = AvailableMissions[ItemNum].static.GetImageContextArray(InteractionOwner.ViewportOwner.Actor);
}

protected function UseImageContextArray(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory, int ItemNum)
{
    AvailableMissions[ContextNum+PItemNum].static.UseImageContextArray(InteractionOwner.ViewportOwner.Actor, ContextArray[ItemNum]);
}

protected function DrawContextMenu(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory)
{
    local int i;
    local color NoAlphaColor;
    local float LastTextPos, XL, YL;

    NoAlphaColor = DefaultColor;
    NoAlphaColor.A = 255;
    Canvas.DrawColor = NoAlphaColor;
    ContextH = 0;
    ContextW = 0;
    for(i=0;i<ContextArray.Length;i++)
    {
        Canvas.TextSize(ContextArray[i], XL, YL);
        ContextH += YL;
        if(XL > ContextW)
            ContextW = XL;
    }
    ContextH += Canvas.ClipY*ContextBorder;
    ContextW += Canvas.ClipX*ContextBorder;
    Canvas.SetPos(ContextPosX-Canvas.ClipX*(ContextBorder/2), ContextPosY-Canvas.ClipY*(ContextBorder/2));
    Canvas.DrawTileStretched(Texture(ContextBGMat), ContextW, ContextH);
    if(InteractionOwner.ViewportOwner.WindowsMouseX >= ContextPosX-Canvas.ClipX*(ContextBorder/2)
    && InteractionOwner.ViewportOwner.WindowsMouseX <= (ContextPosX-Canvas.ClipX*(ContextBorder/2))+ContextW
    && InteractionOwner.ViewportOwner.WindowsMouseY >= ContextPosY-Canvas.ClipY*(ContextBorder/2)
    && InteractionOwner.ViewportOwner.WindowsMouseY <= (ContextPosY-Canvas.ClipY*(ContextBorder/2))+ContextH)
        bMouseInContext = true;
    for(i=0;i<ContextArray.Length;i++)
    {
        Canvas.DrawColor = InteractionOwner.WhiteColor;
        Canvas.TextSize(ContextArray[i], XL, YL);
        if(InteractionOwner.ViewportOwner.WindowsMouseX >= ContextPosX
        && InteractionOwner.ViewportOwner.WindowsMouseX <= ContextPosX+XL
        && InteractionOwner.ViewportOwner.WindowsMouseY >= ContextPosY+LastTextPos
        && InteractionOwner.ViewportOwner.WindowsMouseY <= ContextPosY+LastTextPos+YL)
        {
            Canvas.DrawColor = class'InventoryInteraction'.default.YellowColor;
            if(bContextOpened && InteractionOwner.bLeftClicked)
            {
                UseImageContextArray(InteractionOwner, Canvas, INVInventory, i);
                bContextOpen = false;
                bContextOpened = false;
                return;
            }
        }
        Canvas.SetPos(ContextPosX, ContextPosY+LastTextPos);
        Canvas.DrawText(ContextArray[i]);
        LastTextPos += YL;
    }
    bContextOpened = true;
}

function string bTouchingImage(InventoryInteraction InteractionOwner)
{
    local int i;

    if(bContextOpened)
    {
        for(i=0;i<ItemPos.Length;i++)
        {
            if(InteractionOwner.ViewportOwner.WindowsMouseX >= ContextPosX-InteractionOwner.ClipX*(ContextBorder/2)
            && InteractionOwner.ViewportOwner.WindowsMouseX <= (ContextPosX-InteractionOwner.ClipX*(ContextBorder/2))+ContextW
            && InteractionOwner.ViewportOwner.WindowsMouseY >= ContextPosY-InteractionOwner.ClipY*(ContextBorder/2)
            && InteractionOwner.ViewportOwner.WindowsMouseY <= (ContextPosY-InteractionOwner.ClipY*(ContextBorder/2))+ContextH)
                return "ContextMenu";
        }
    }
    for(i=0;i<ItemPos.Length;i++)
    {
        if(InteractionOwner.ViewportOwner.WindowsMouseX >= (InteractionOwner.ClipX*ItemPos[i].XTL)+(InteractionOwner.ClipX*WindowLocX)
        && InteractionOwner.ViewportOwner.WindowsMouseX <= (InteractionOwner.ClipX*(ItemPos[i].XTL+ItemPos[i].XH))+(InteractionOwner.ClipX*WindowLocX)
        && InteractionOwner.ViewportOwner.WindowsMouseY >= (InteractionOwner.ClipY*ItemPos[i].YTL)+(InteractionOwner.ClipY*WindowLocY)
        && InteractionOwner.ViewportOwner.WindowsMouseY <= (InteractionOwner.ClipY*(ItemPos[i].YTL+ItemPos[i].YH))+(InteractionOwner.ClipY*WindowLocY))
            return ItemPos[i].ImageTag;
    }
    if(InteractionOwner.ViewportOwner.WindowsMouseX >= (InteractionOwner.ClipX*0.025)+(InteractionOwner.ClipX*WindowLocX)
    && InteractionOwner.ViewportOwner.WindowsMouseX <= (InteractionOwner.ClipX*(0.025+0.275))+(InteractionOwner.ClipX*WindowLocX)
    && InteractionOwner.ViewportOwner.WindowsMouseY >= (InteractionOwner.ClipY*0.025)+(InteractionOwner.ClipY*WindowLocY)
    && InteractionOwner.ViewportOwner.WindowsMouseY <= (InteractionOwner.ClipY*(0.025+0.15))+(InteractionOwner.ClipY*WindowLocY))
        return "MissionBG";
    return super.bTouchingImage(InteractionOwner);
}

function MenuToggled(InventoryInteraction InteractionOwner, bool bOpen)
{
    if(!bOpen)
    {
        bContextOpen = false;
        bContextOpened = false;
        bDragging = false;
        SaveConfig();
    }
}

defaultproperties
{
    AvailableMissions(0)=class'SonicRPG45.Mission030F'
    AvailableMissions(1)=class'SonicRPG45.Mission031F'
    AvailableMissions(2)=class'SonicRPG45.Mission032F'
    AvailableMissions(3)=class'SonicRPG45.Mission033F'
    AvailableMissions(4)=class'SonicRPG45.Mission011F'
    AvailableMissions(5)=class'SonicRPG45.Mission001F'
    AvailableMissions(6)=class'SonicRPG45.Mission002F'
    AvailableMissions(7)=class'SonicRPG45.Mission003F'
    AvailableMissions(8)=class'SonicRPG45.Mission004F'
    AvailableMissions(9)=class'SonicRPG45.Mission009F'
    AvailableMissions(10)=class'SonicRPG45.Mission014F'
    AvailableMissions(11)=class'SonicRPG45.Mission005F'
    AvailableMissions(12)=class'SonicRPG45.Mission010F'
    AvailableMissions(13)=class'SonicRPG45.Mission006F'
    AvailableMissions(14)=class'SonicRPG45.Mission007F'
    AvailableMissions(15)=class'SonicRPG45.Mission008F'
    AvailableMissions(16)=class'SonicRPG45.Mission027F'
    AvailableMissions(17)=class'SonicRPG45.Mission016F'
    AvailableMissions(18)=class'SonicRPG45.Mission017F'
    AvailableMissions(19)=class'SonicRPG45.Mission018F'
    AvailableMissions(20)=class'SonicRPG45.Mission019F'
    AvailableMissions(21)=class'SonicRPG45.Mission025F'
    AvailableMissions(22)=class'SonicRPG45.Mission028F'
    AvailableMissions(23)=class'SonicRPG45.Mission020F'
    AvailableMissions(24)=class'SonicRPG45.Mission026F'
    AvailableMissions(25)=class'SonicRPG45.Mission021F'
    AvailableMissions(26)=class'SonicRPG45.Mission023F'
    AvailableMissions(27)=class'SonicRPG45.Mission024F'
    AvailableMissions(28)=class'SonicRPG45.Mission012F'
    AvailableMissions(29)=class'SonicRPG45.Mission013F'
    AvailableMissions(30)=class'SonicRPG45.Mission015F'
    AvailableMissions(31)=class'SonicRPG45.Mission029F'

    DefaultMission=class'SonicRPG45.Mission030F'
    NextPageSound=Sound'2K4MenuSounds.Generic.msfxUp'

    ContextBGMat=Texture'2K4Menus.Controls.thinpipe_b'
    ScrollBlury=Material'2K4Menus.NewControls.ScrollGripBlurry'
    ScrollPressed=Material'2K4Menus.NewControls.ScrollGripPressed'
    ScrollWatched=Material'2K4Menus.NewControls.ScrollGripWatched'

    ItemPos(0)=(XTL=0.30,YTL=0.025,XH=0.025,YH=0.025,BGImage=Material'2K4Menus.NewControls.UpMark',ImageTag="UpArrow")
    ItemPos(1)=(XTL=0.30,YTL=0.150,XH=0.025,YH=0.025,BGImage=Material'2K4Menus.NewControls.DownMark',ImageTag="DownArrow")
    ItemPos(2)=(XTL=0.30,YTL=0.050,XH=0.025,YH=0.100,BGImage=Material'2K4Menus.NewControls.NewTabBK',ImageTag="ScrollSection")

    WindowLocY=0.20
    WindowLocX=0.60
    WindowLocH=0.20
    WindowLocW=0.35
    ContextBorder=0.04
}
