class LootHudClass extends InventoryHudClass;

protected function GetItemArray(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory)
{
    Items.Length = INVInventory.LootedItems.length;
    Items = INVInventory.LootedItems;
    ItemsAmount.Length = INVInventory.LootedItemsAmount.length;
    ItemsAmount = INVInventory.LootedItemsAmount;
    Limit = INVInventory.LootedItems.length;
}

protected function GetImageContextArray(InventoryInteraction InteractionOwner, INVInventory INVInventory, int ItemNum)
{
    ContextArray.length = 3;
    ContextArray[0] = "Add to inventory";
    ContextArray[1] = "Remove";
    ContextArray[2] = "Information";
}

protected function UseImageContextArray(InventoryInteraction InteractionOwner, Canvas Canvas, INVInventory INVInventory, int ContextNum, int ItemNum)
{
    if(ContextNum == 0)
        INVInventory.TakeLootedItem(Items[ItemNum]);
    else if(ContextNum == 1)
    {
        INVInventory.DeleteNum = ItemNum;
        INVInventory.RemoveInventoryItem = false;
        if(!INVInventory.bDeleteOpen)
            InteractionOwner.ViewportOwner.GUIController.OpenMenu("SonicRPG45.DeleteGUI");
    }
    else if(ContextNum == 2)
    {
        INVInventory.InfoClass = Items[ItemNum];
        if(!INVInventory.bInformationOpen)
            InteractionOwner.ViewportOwner.GUIController.OpenMenu("SonicRPG45.InformationGUI");
        else if(INVInventory.Information != none)
            INVInventory.Information.OnOpen();
    }
}

defaultproperties
{
    ItemPos(0)=(XTL=0.05,YTL=0.00,XH=0.05,YH=0.05,ImageTag="1")
	ItemPos(1)=(XTL=0.11,YTL=0.00,XH=0.05,YH=0.05,ImageTag="2")
	ItemPos(2)=(XTL=0.17,YTL=0.00,XH=0.05,YH=0.05,ImageTag="3")
	ItemPos(3)=(XTL=0.05,YTL=0.06,XH=0.05,YH=0.05,ImageTag="4")
	ItemPos(4)=(XTL=0.11,YTL=0.06,XH=0.05,YH=0.05,ImageTag="5")
	ItemPos(5)=(XTL=0.17,YTL=0.06,XH=0.05,YH=0.05,ImageTag="6")
	ItemPos(6)=(XTL=0.05,YTL=0.12,XH=0.05,YH=0.05,ImageTag="7")
	ItemPos(7)=(XTL=0.11,YTL=0.12,XH=0.05,YH=0.05,ImageTag="8")
	ItemPos(8)=(XTL=0.17,YTL=0.12,XH=0.05,YH=0.05,ImageTag="9")
	ArrowButtons(0)=(XTL=0.00,YTL=0.0325,XH=0.05,YH=0.10,BGImage=Material'2K4Menus.NewControls.LeftMark',ImageTag="LeftScroll")
	ArrowButtons(1)=(XTL=0.22,YTL=0.0325,XH=0.05,YH=0.10,BGImage=Material'2K4Menus.NewControls.RightMark',ImageTag="RightScroll")

    WindowLocY=0.20
    WindowLocX=0.00
    WindowLocW=0.27
}
