class InventoryPlayerDataObject extends Object;

const SkillAmount = 8;

var string OwnerID;
var int Slots, CombatLevel, SkillLevel[SkillAmount], CurrentMissionTimeLapsed;
var float CombatXP, Credits;
var class<ClassFile> CharClass;
var class<MissionFile> CurrentMission;
var array<class<MainInventoryItem> > Items, SelectedItems;
var array<class<MissionFile> > CompletedMissions;
var array<int> ItemsAmount, MissionObjectSuccess;

struct InventoryPlayerData
{
    var int Slots, CombatLevel, CurrentMissionTimeLapsed, SkillLevel[SkillAmount];
	var float CombatXP, Credits;
	var class<ClassFile> CharClass;
    var class<MissionFile> CurrentMission;
	var array<class<MainInventoryItem> > Items, SelectedItems;
	var array<class<MissionFile> > CompletedMissions;
	var array<int> ItemsAmount, MissionObjectSuccess;
};

function CreateDataStruct(out InventoryPlayerData Data, bool bOnlyCredits, optional bool bUpdateSkills)
{
    local int i;

    Data.Credits = Credits;
	if(bOnlyCredits)
	    return;
    Data.Slots = Slots;
    Data.CombatLevel = CombatLevel;
    Data.CombatXP = CombatXP;
    Data.CurrentMissionTimeLapsed = CurrentMissionTimeLapsed;
    Data.CurrentMission = CurrentMission;
    Data.Items = Items;
	Data.CompletedMissions = CompletedMissions;
	Data.ItemsAmount = ItemsAmount;
    Data.MissionObjectSuccess = MissionObjectSuccess;
    Data.SelectedItems = SelectedItems;
    Data.CharClass = CharClass;
    if(!bUpdateSkills)
        return;
    for(i=0;i<ArrayCount(SkillLevel);i++)
        Data.SkillLevel[i] = SkillLevel[i];
}

defaultproperties
{
    OwnerID="OFFLINE"
}
