class InformationGUI extends FloatingWindow;

var automated GUIButton CloseWindowButton;
var automated GUIImage ItemScreenShot;
var automated GUIScrollTextBox ItemDesc, ItemInfomation;

function OnOpen()
{
    local INVInventory INVInventory;
    local PlayerController C;

    C = PlayerOwner();
    if(C != none)
        INVInventory = class'mutInventorySystem'.static.FindINVInventory(C);
    if(INVInventory != none)
    {
        INVInventory.bInformationOpen = true;
        INVInventory.Information = self;

        ItemScreenShot.Image = INVInventory.InfoClass.default.Image;
        t_WindowTitle.SetCaption(INVInventory.InfoClass.static.GetInvItemName(C));
        ItemInfomation.SetContent(INVInventory.InfoClass.static.GetItemInformation(C));
        ItemDesc.SetContent(INVInventory.InfoClass.static.GetDescription(C));
    }
}

function OnClose(optional bool bCancelled)
{
    local INVInventory INVInventory;

    INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());

    if(INVInventory != none)
    {
        INVInventory.bInformationOpen = false;
        INVInventory.Information = none;
    }
}

defaultproperties
{
     Begin Object Class=GUIButton Name=CloseButton
         Caption="Close"
         WinWidth=0.900000
         WinHeight=0.100000
         WinLeft=0.050000
         WinTop=0.8500000
         bBoundToParent=True
         bScaleToParent=True
         OnClick=XButtonClicked
     End Object
     CloseWindowButton=CloseButton

     Begin Object Class=GUIScrollTextBox Name=ItemInfo
         WinWidth=0.600000
		 WinHeight=0.250000
		 WinLeft=0.350000
		 WinTop=0.100000
		 CharDelay=0.0025
         EOLDelay=0.5
         bNoTeletype=True
         bNeverFocus=true
         StyleName="NoBackground"
         bTabStop=False
     End Object
     ItemInfomation=ItemInfo

     Begin Object Class=GUIScrollTextBox Name=ItemDescription
		 WinWidth=0.900000
		 WinHeight=0.400000
		 WinLeft=0.050000
		 WinTop=0.400000
         CharDelay=0.0025
         EOLDelay=0.5
         bNeverFocus=true
         StyleName="NoBackground"
         bTabStop=False
     End Object
     ItemDesc=ItemDescription

     Begin Object Class=GUIImage Name=ScreenShot
         ImageStyle=ISTY_Scaled
         BorderOffsets(0)=50
	     BorderOffsets(1)=50
	     BorderOffsets(2)=50
	     BorderOffsets(3)=50
         WinTop=0.100000
         WinLeft=0.050000
         WinWidth=0.250000
         WinHeight=0.250000
         bBoundToParent=True
         bScaleToParent=True
     End Object
     ItemScreenShot=ScreenShot

     DefaultWidth=0.500000
     DefaultHeight=0.500000
     DefaultLeft=0.250000
     DefaultTop=0.000000
     WinWidth=0.500000
	 WinHeight=0.500000
	 WinLeft=0.250000
	 WinTop=0.000000

     WindowName="Item Information"
     bRenderWorld=True
     bAllowedAsLast=True
     bResizeWidthAllowed=False
 	 bResizeHeightAllowed=False
 	 bMoveAllowed=True
}
