class myGasBag extends INVMonster;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	if(Controller != none)
	    Controller.GotoState('PlayerFlying');
}

function RangedAttack(Actor A)
{
	if(bShotAnim)
		return;
	SetAnimAction('Belch');
	bShotAnim = true;
}

function AltRangedAttack(Actor A)
{
	if(bShotAnim)
		return;
	PlaySound(sound'twopunch1g',SLOT_Talk);
	if (FRand() < 0.5)
		SetAnimAction('TwoPunch');
	else
		SetAnimAction('Pound');
	bShotAnim = true;
}

function SetMovementPhysics()
{
	Controller.GotoState('PlayerFlying');
}

singular function Falling()
{
	Controller.GotoState('PlayerFlying');
}

function bool Dodge(eDoubleClickDir DoubleClickMove)
{
	Controller.GotoState('PlayerFlying');
    return false;
}

simulated function PlayDirectionalDeath(Vector HitLoc)
{
	if ( FRand() < 0.5 )
		PlayAnim('Deflate',, 0.1);
	else
		PlayAnim('Dead2',, 0.1);
}

simulated function PlayDirectionalHit(Vector HitLoc)
{
	if ( FRand() < 0.6 )
		TweenAnim('TakeHit', 0.05);
	else
		TweenAnim('Hit2', 0.05);
}

function PlayVictory()
{
    PlaySound(sound'twopunch1g',SLOT_Interact);
	SetAnimAction('Pound');
}

function SpawnBelch()
{
	if(ROLE == ROLE_Authority)
        FireProjectile();
}

function vector GetFireStart(vector X, vector Y, vector Z)
{
    return Location + 0.5*X;
}

function PunchDamageTarget()
{
	if(ROLE == ROLE_Authority && Controller.Target != none && MeleeDamageTarget(25, (39000 * Normal(Controller.Target.Location - Location))))
		PlaySound(sound'Hit1g', SLOT_Interact);
}

function PoundDamageTarget()
{
	if(ROLE == ROLE_Authority && Controller.Target != none && MeleeDamageTarget(35, (24000 * Normal(Controller.Target.Location - Location))))
		PlaySound(sound'Hit1g', SLOT_Interact);
}

defaultproperties
{
	DodgeSkillAdjust=4
	Skins(0)=Gasbag1
	Skins(1)=GasBag2
	bMeleeFighter=false
	  bCanFly=true
      Health=150
      AirSpeed=+00330.000000
      Mesh=GasbagM
      AmbientSound=amb2g
      CollisionRadius=+00047.000000
      CollisionHeight=+00036.000000
      Mass=+00120.000000

     AmmunitionClass=class'GasbagAmmo'
     HitSound(0)=injur1g
     HitSound(1)=injur2g
     HitSound(2)=injur1g
     HitSound(3)=injur2g
     FireSound=yell3g
     DeathSound(0)=death1g
     DeathSound(1)=death1g
     DeathSound(2)=death1g
     DeathSound(3)=death1g
     ChallengeSound(0)=yell2g
     ChallengeSound(1)=yell3g
     ChallengeSound(2)=nearby1g
     ChallengeSound(3)=yell2g

    IdleWeaponAnim=Grab
    TurnRightAnim=idle_rest
    TurnLeftAnim=idle_rest

    CrouchAnims(0)=idle_rest
    CrouchAnims(1)=idle_rest
    CrouchAnims(2)=idle_rest
    CrouchAnims(3)=idle_rest

    CrouchTurnRightAnim=Float
    CrouchTurnLeftAnim=Float

    AirStillAnim=Float
    AirAnims(0)=Float
    AirAnims(1)=Float
    AirAnims(2)=Float
    AirAnims(3)=Float
    TakeoffStillAnim=Float
    TakeoffAnims(0)=Float
    TakeoffAnims(1)=Float
    TakeoffAnims(2)=Float
    TakeoffAnims(3)=Float
    LandAnims(0)=Float
    LandAnims(1)=Float
    LandAnims(2)=Float
    LandAnims(3)=Float
    DodgeAnims(0)=Float
    DodgeAnims(1)=Float
    DodgeAnims(2)=Float
    DodgeAnims(3)=Float
    MovementAnims(0)=Float
    MovementAnims(1)=Float
    MovementAnims(2)=Float
    MovementAnims(3)=Float

	ScoringValue=4
}
