class mutSonicUT2004RPG extends MutUT2004RPG;

function ModifyPlayer(Pawn Other)
{
    super(Mutator).ModifyPlayer(Other);
}

function myModifyPlayer(Pawn Other)
{
	local RPGPlayerDataObject data;
	local int x, FakeBotLevelDiff;
	local RPGStatsInv StatsInv;
	local Inventory Inv;
	local array<Weapon> StartingWeapons;
	local class<Weapon> StartingWeaponClass;
	local RPGWeapon MagicWeapon;

	if (Other.Controller == None || !Other.Controller.bIsPlayer)
		return;
	StatsInv = RPGStatsInv(Other.FindInventoryType(class'RPGStatsInv'));
	if (StatsInv != None)
	{
		if (StatsInv.Instigator != None)
			for (x = 0; x < StatsInv.Data.Abilities.length; x++)
				StatsInv.Data.Abilities[x].static.ModifyPawn(StatsInv.Instigator, StatsInv.Data.AbilityLevels[x]);
		return;
	}
	else
	{
		for (Inv = Other.Controller.Inventory; Inv != None; Inv = Inv.Inventory)
		{
			StatsInv = RPGStatsInv(Inv);
			if (StatsInv != None)
				break;
			//I fail to understand why I need this check... am I missing something obvious or is this some weird script bug?
			if (Inv.Inventory == None)
			{
				Inv.Inventory = None;
				break;
			}
		}
	}

	if (StatsInv != None)
		data = StatsInv.DataObject;
	else
	{
		data = RPGPlayerDataObject(FindObject("Package." $ Other.PlayerReplicationInfo.PlayerName, class'RPGPlayerDataObject'));
		if (data == None)
			data = new(None, Other.PlayerReplicationInfo.PlayerName) class'RPGPlayerDataObject';
		if (bFakeBotLevels && PlayerController(Other.Controller) == None) //a bot, and fake bot levels is turned on
		{
			// if the bot has data, delete it
			if (data.Level != 0)
			{
				data.ClearConfig();
				data = new(None, Other.PlayerReplicationInfo.PlayerName) class'RPGPlayerDataObject';
			}

			// give the bot a level near the current lowest level
			if (CurrentLowestLevelPlayer != None)
			{
				FakeBotLevelDiff = 3 + Min(25, CurrentLowestLevelPlayer.Level * 0.1);
				data.Level = Max(StartingLevel, CurrentLowestLevelPlayer.Level - FakeBotLevelDiff + Rand(FakeBotLevelDiff * 2));
			}
			else
				data.Level = StartingLevel;

			data.PointsAvailable = PointsPerLevel * data.Level;
			data.AdrenalineMax = 100;
			if (Levels.length > data.Level)
				data.NeededExp = Levels[data.Level];
			else if (InfiniteReqEXPValue != 0)
			{
				if (InfiniteReqEXPOp == 0)
					data.NeededExp = Levels[Levels.length - 1] + InfiniteReqEXPValue * (data.Level - (Levels.length - 1));
				else
				{
					data.NeededExp = Levels[Levels.length - 1];
					for (x = Levels.length - 1; x < data.Level; x++)
						data.NeededExp += int(float(data.NeededExp) * float(InfiniteReqEXPValue) * 0.01);
				}
			}
			else
				data.NeededExp = Levels[Levels.length - 1];

			// give some random amount of EXP toward next level so some will gain a level or two during the match
			data.Experience = Rand(data.NeededExp);

			data.OwnerID = "Bot";
		}
		else if (data.Level == 0) //new player
		{
			data.Level = StartingLevel;
			data.PointsAvailable = PointsPerLevel * (StartingLevel - 1);
			data.AdrenalineMax = 100;
			if (Levels.length > StartingLevel)
				data.NeededExp = Levels[StartingLevel];
			else if (InfiniteReqEXPValue != 0)
			{
				if (InfiniteReqEXPOp == 0)
					data.NeededExp = Levels[Levels.length - 1] + InfiniteReqEXPValue * (data.Level - (Levels.length - 1));
				else
				{
					data.NeededExp = Levels[Levels.length - 1];
					for (x = Levels.length - 1; x < StartingLevel; x++)
						data.NeededExp += int(float(data.NeededEXP) * float(InfiniteReqEXPValue) * 0.01);
				}
			}
			else
				data.NeededExp = Levels[Levels.length - 1];
			if (PlayerController(Other.Controller) != None)
				data.OwnerID = PlayerController(Other.Controller).GetPlayerIDHash();
			else
				data.OwnerID = "Bot";
		}
		else //returning player
		{
			if ( (PlayerController(Other.Controller) != None && !(PlayerController(Other.Controller).GetPlayerIDHash() ~= data.OwnerID))
			     || (Bot(Other.Controller) != None && data.OwnerID != "Bot") )
			{
				//imposter using somebody else's name
				if (PlayerController(Other.Controller) != None)
					PlayerController(Other.Controller).ReceiveLocalizedMessage(class'RPGNameMessage', 0);
				Level.Game.ChangeName(Other.Controller, Other.PlayerReplicationInfo.PlayerName$"_Imposter", true);
				if (string(data.Name) ~= Other.PlayerReplicationInfo.PlayerName) //initial name change failed
					Level.Game.ChangeName(Other.Controller, string(Rand(65000)), true); //That's gotta suck, having a number for a name
				myModifyPlayer(Other);
				return;
			}
			ValidateData(data);
		}
	}

	if (data.PointsAvailable > 0 && Bot(Other.Controller) != None)
	{
		x = 0;
		do
		{
			BotLevelUp(Bot(Other.Controller), data);
			x++;
		} until (data.PointsAvailable <= 0 || data.BotAbilityGoal != None || x > 10000)
	}

	if ((CurrentLowestLevelPlayer == None || data.Level < CurrentLowestLevelPlayer.Level) && (!bFakeBotLevels || Other.Controller.IsA('PlayerController')))
		CurrentLowestLevelPlayer = data;

	//spawn the stats inventory item
	if (StatsInv == None)
	{
		StatsInv = spawn(class'SonicRPGStatsInv',Other,,,rot(0,0,0));
		if (Other.Controller.Inventory == None)
			Other.Controller.Inventory = StatsInv;
		else
		{
			for (Inv = Other.Controller.Inventory; Inv.Inventory != None; Inv = Inv.Inventory)
			{}
			Inv.Inventory = StatsInv;
		}
	}
	StatsInv.DataObject = data;
	data.CreateDataStruct(StatsInv.Data, false);
	StatsInv.RPGMut = self;
	StatsInv.GiveTo(Other);

	if (WeaponModifierChance > 0)
	{
		x = 0;
		for (Inv = Other.Inventory; Inv != None; Inv = Inv.Inventory)
		{
			if (Weapon(Inv) != None && RPGWeapon(Inv) == None)
				StartingWeapons[StartingWeapons.length] = Weapon(Inv);
			x++;
			if (x > 1000)
				break;
		}

		for (x = 0; x < StartingWeapons.length; x++)
		{
			StartingWeaponClass = StartingWeapons[x].Class;
			// don't affect the translocator because it breaks bots
			// don't affect Weapons of Evil's Sentinel Deployer because it doesn't work at all
			if (StartingWeaponClass.Name != 'TransLauncher' && StartingWeaponClass.Name != 'SentinelDeployer')
			{
				StartingWeapons[x].Destroy();
				if (bMagicalStartingWeapons)
					MagicWeapon = spawn(GetRandomWeaponModifier(StartingWeaponClass, Other), Other,,, rot(0,0,0));
				else
					MagicWeapon = spawn(class'RPGWeapon', Other,,, rot(0,0,0));
				MagicWeapon.Generate(None);
				MagicWeapon.SetModifiedWeapon(spawn(StartingWeaponClass,Other,,,rot(0,0,0)), bNoUnidentified);
				MagicWeapon.GiveTo(Other);
			}
		}
		Other.Controller.ClientSwitchToBestWeapon();
	}

	//set pawn's properties
	Other.Health = Other.default.Health + data.HealthBonus;
	Other.HealthMax = Other.default.HealthMax + data.HealthBonus;
	Other.SuperHealthMax = Other.HealthMax + (Other.default.SuperHealthMax - Other.default.HealthMax);
	Other.Controller.AdrenalineMax = data.AdrenalineMax;
	for (x = 0; x < data.Abilities.length; x++)
		data.Abilities[x].static.ModifyPawn(Other, data.AbilityLevels[x]);
}
