class StatsGUI extends FloatingWindow;

var automated GUIButton CloseWindowButton, OKButton;
var automated GUIScrollTextBox ItemDesc;
var automated GUILabel MissionPoints, CombatStats, PointsAvaliable, ClassName;
var automated GUIImage CharImage;
var automated GUIListBox MListBox;
var automated GUINumericEdit PointsToAdd;

function OnOpen()
{
    local INVInventory INVInventory;

   	INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());
   	if(INVInventory != none)
   	{
        INVInventory.bStatsGUIOpen = true;
        INVInventory.StatsGUI = self;
        CloseWindowButton.OnClick = XButtonClicked;
        OKButton.OnClick = OKClicked;
        CharImage.Image = PlayerOwner().PlayerReplicationInfo.GetPortrait();
        UpdateStats();
    }
}

function OnClose(optional bool bCancelled)
{
    local INVInventory INVInventory;

    INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());
    if(INVInventory != none)
    {
        INVInventory.bStatsGUIOpen = false;
        INVInventory.StatsGUI = none;
    }
}

function myOnChange(GUIComponent Sender)
{
    if(Sender == none || GUIListBase(Sender) == none || GUIListBase(Sender).Index < 0
    || GUIListBase(Sender).Index >= class'mutInventorySystem'.default.Skills.length)
        return;

    ItemDesc.SetContent(class'mutInventorySystem'.default.Skills[GUIListBase(Sender).Index].Description);
}

function UpdateStats()
{
    local INVInventory INVInventory;
    local int i, SavedIndex;

   	INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());

   	if(INVInventory == none || INVInventory.MutINV == none)
   	    return;

    SavedIndex = MListBox.List.Index;
    MListBox.List.OnChange = myOnChange;
    MListBox.List.TextAlign = TXTA_Left;
    MListBox.List.Clear();
    if(INVInventory.DataRep.CharClass != none)
        ClassName.Caption = ("Class:" @ INVInventory.DataRep.CharClass.default.ClassName);
    MissionPoints.Caption = ("Mission Points:" @ INVInventory.GetMissionPoints());
    PointsAvaliable.Caption = ("Points Avaliable:" @ INVInventory.MutINV.static.GetPointsAvaliable(INVInventory));
    CombatStats.Caption = ("Combat Lvl:" @ INVInventory.DataRep.CombatLevel @ "-" @ int(INVInventory.DataRep.CombatXP) $ "/"
                         $ INVInventory.MutINV.GetCurrentXP(INVInventory.DataRep.CombatLevel));

    for(i=0;i<INVInventory.MutINV.Skills.Length;i++)
        MListBox.List.Add(INVInventory.MutINV.Skills[i].SkillName @ "-" @ INVInventory.DataRep.SkillLevel[i]);
    MListBox.List.SetIndex(SavedIndex);
}

function bool OKClicked(GUIComponent Sender)
{
    local INVInventory INVInventory;

    INVInventory = class'mutInventorySystem'.static.FindINVInventory(PlayerOwner());

    if(INVInventory == none || MListBox == none || MListBox.MyList == none || MListBox.MyList.Index < 0
    || MListBox.MyList.Index >= class'mutInventorySystem'.default.Skills.length)
        return false;

    INVInventory.AddSkillPoints(int(PointsToAdd.Value), MListBox.MyList.Index);
    return true;
}

defaultproperties
{
    Begin Object Class=GUILabel Name=MissionP
        Caption="Mission Points: 0"
        TextColor=(B=255,G=255,R=255)
        WinTop=0.050000
        WinLeft=0.050000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    MissionPoints=MissionP

    Begin Object Class=GUILabel Name=CombatStat
        Caption="Combat Level: 0"
        TextColor=(B=255,G=255,R=255)
        WinTop=0.100000
        WinLeft=0.050000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    CombatStats=CombatStat

    Begin Object Class=GUILabel Name=PointsAval
        Caption="Points Avaliable: 0"
        TextColor=(B=255,G=255,R=255)
        WinTop=0.150000
        WinLeft=0.050000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    PointsAvaliable=PointsAval

    Begin Object Class=GUILabel Name=CName
        Caption="Class: none"
        TextColor=(B=255,G=255,R=255)
        WinTop=0.200000
        WinLeft=0.050000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    ClassName=CName

    Begin Object Class=GUIListBox Name=MissionListBox
        WinWidth=0.900000
		WinHeight=0.200000
		WinLeft=0.050000
		WinTop=0.450000
		bVisibleWhenEmpty=True
		StyleName="ServerBrowserGrid"
		SelectedStyleName="BrowserListSelection"
		TabOrder=11
	End Object
	MListBox=MissionListBox

    Begin Object Class=GUIButton Name=CloseButton
        Caption="Close"
        WinTop=0.8500000
        WinLeft=0.050000
        WinWidth=0.900000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    CloseWindowButton=CloseButton

    Begin Object Class=GUIButton Name=OK
        Caption="OK"
        WinTop=0.350000
        WinLeft=0.300000
        WinWidth=0.100000
        WinHeight=0.100000
        bBoundToParent=True
        bScaleToParent=True
    End Object
    OKButton=OK

	Begin Object class=GUIImage Name=CImage
		WinWidth=0.200000
		WinHeight=0.400000
		WinLeft=0.7500000
		WinTop=0.050000
		Image=Material'InterfaceContent.Menu.BorderBoxD'
		ImageColor=(R=255,G=255,B=255,A=255);
		ImageRenderStyle=MSTY_Normal
		ImageStyle=ISTY_Scaled
	End Object
    CharImage=CImage

    Begin Object Class=GUIScrollTextBox Name=ItemDescription
		WinWidth=0.900000
		WinHeight=0.150000
		WinLeft=0.050000
		WinTop=0.700000
        CharDelay=0.0025
        EOLDelay=0.5
        bNoTeletype=True
        bNeverFocus=true
        StyleName="NoBackground"
        bTabStop=False
    End Object
    ItemDesc=ItemDescription

    Begin Object Class=GUINumericEdit Name=PointsAdd
        Value="1"
        MinValue=1
        MaxValue=999
        WinTop=0.350000
        WinLeft=0.050000
        WinWidth=0.250000
        WinHeight=0.100000
    End Object
    PointsToAdd=PointsAdd

    DefaultWidth=0.350000
    DefaultHeight=0.500000
    DefaultLeft=0.250000
    DefaultTop=0.000000
    WinWidth=0.350000
	WinHeight=0.500000
	WinLeft=0.250000
	WinTop=0.000000

    WindowName="Stats"

    bRenderWorld=True
    bAllowedAsLast=True
    bResizeWidthAllowed=False
 	bResizeHeightAllowed=False
 	bMoveAllowed=True
}
