class MonsterInfo extends Mutator;

struct Loot
{
    var class<MainInventoryItem> ItemClass;
    var int MaxLoot, Chance;
};
var array<Loot> LootableItems;

var int MaxCredits;

static function Pawn FindMonsterInfo(class<Pawn> PawnClass)
{
    return none;
}

defaultproperties
{
    LootableItems(0)=(ItemClass=Class'MiniHealthInvItem',Chance=2000,MaxLoot=20)
    LootableItems(1)=(ItemClass=Class'HealthInvItem',Chance=1000,MaxLoot=5)
    LootableItems(2)=(ItemClass=Class'SuperHealthInvItem',Chance=500,MaxLoot=2)
    LootableItems(3)=(ItemClass=Class'ShieldInvItem',Chance=1000,MaxLoot=5)
    LootableItems(4)=(ItemClass=Class'SuperShieldInvItem',Chance=500,MaxLoot=2)
    LootableItems(5)=(ItemClass=Class'AdrenalineInvItem',Chance=2000,MaxLoot=20)
    LootableItems(6)=(ItemClass=Class'AdrenalineTwoInvItem',Chance=1000,MaxLoot=5)
    LootableItems(7)=(ItemClass=Class'AdrenalineThreeInvItem',Chance=500,MaxLoot=2)
    LootableItems(8)=(ItemClass=Class'LinkAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(9)=(ItemClass=Class'RocketAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(10)=(ItemClass=Class'ShockAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(11)=(ItemClass=Class'LGunAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(12)=(ItemClass=Class'FlakAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(13)=(ItemClass=Class'AssaultAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(14)=(ItemClass=Class'AVRiLAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(15)=(ItemClass=Class'BioAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(16)=(ItemClass=Class'CSniperAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(17)=(ItemClass=Class'DDamageInvItem',Chance=20,MaxLoot=3)
    LootableItems(18)=(ItemClass=Class'GrenadeAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(19)=(ItemClass=Class'MineAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(20)=(ItemClass=Class'MiniAmmoInvItem',Chance=200,MaxLoot=5)
    LootableItems(21)=(ItemClass=Class'LuckyWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(22)=(ItemClass=Class'VampireWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(23)=(ItemClass=Class'VorpalWepInvItem',Chance=3,MaxLoot=1)
    LootableItems(24)=(ItemClass=Class'InfiniteWepInvItem',Chance=5,MaxLoot=1)
    LootableItems(25)=(ItemClass=Class'FreezeWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(26)=(ItemClass=Class'KnockbackWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(27)=(ItemClass=Class'SpeedWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(28)=(ItemClass=Class'NullWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(29)=(ItemClass=Class'PiercingWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(30)=(ItemClass=Class'PenetratingWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(31)=(ItemClass=Class'ReflectWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(32)=(ItemClass=Class'RageWepInvItem',Chance=5,MaxLoot=1)
    LootableItems(33)=(ItemClass=Class'PoisonWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(34)=(ItemClass=Class'ProtectionWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(35)=(ItemClass=Class'ForceWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(36)=(ItemClass=Class'EnergyWepInvItem',Chance=5,MaxLoot=1)
    LootableItems(37)=(ItemClass=Class'SturdyWepInvItem',Chance=10,MaxLoot=3)
    LootableItems(38)=(ItemClass=Class'SpeedGizmoCreator',Chance=1,MaxLoot=1)
    LootableItems(39)=(ItemClass=Class'JumpGizmoCreator',Chance=1,MaxLoot=1)
    LootableItems(40)=(ItemClass=Class'GhostGizmoCreator',Chance=1,MaxLoot=1)
    LootableItems(41)=(ItemClass=Class'SwimGizmoCreator',Chance=2,MaxLoot=1)
    LootableItems(42)=(ItemClass=Class'TarydiumCrystal',Chance=4000,MaxLoot=15)
    LootableItems(43)=(ItemClass=Class'AdrenalineCreator',Chance=50,MaxLoot=1)
    LootableItems(44)=(ItemClass=Class'AdrenalineTwoCreator',Chance=25,MaxLoot=1)
    LootableItems(45)=(ItemClass=Class'AdrenalineThreeCreator',Chance=10,MaxLoot=1)
    LootableItems(46)=(ItemClass=Class'MiniHealthCreator',Chance=50,MaxLoot=1)
    LootableItems(47)=(ItemClass=Class'HealthCreator',Chance=25,MaxLoot=1)
    LootableItems(48)=(ItemClass=Class'SuperHealthCreator',Chance=10,MaxLoot=1)
    LootableItems(49)=(ItemClass=Class'AmmoGizmoCreator',Chance=3,MaxLoot=1)
    LootableItems(50)=(ItemClass=Class'MetaPupaeCreator',Chance=400,MaxLoot=1)
    LootableItems(51)=(ItemClass=Class'MetaRazorFlyCreator',Chance=450,MaxLoot=1)
    LootableItems(52)=(ItemClass=Class'MetaGasBagCreator',Chance=400,MaxLoot=1)
    LootableItems(53)=(ItemClass=Class'MetaKrallCreator',Chance=350,MaxLoot=1)
    LootableItems(54)=(ItemClass=Class'MetaKrallEliteCreator',Chance=250,MaxLoot=1)
    LootableItems(55)=(ItemClass=Class'MetaBruteCreator',Chance=300,MaxLoot=1)
    LootableItems(56)=(ItemClass=Class'MetaBehemothCreator',Chance=150,MaxLoot=1)
    LootableItems(57)=(ItemClass=Class'MetaWarLordCreator',Chance=50,MaxLoot=1)
    LootableItems(58)=(ItemClass=Class'MetaSkaarjCreator',Chance=100,MaxLoot=1)

    MaxCredits=100
}
