Class Trike extends ONSWheeledCraft;

Var rotator r, l;

//#exec OBJ LOAD FILE=..\textures\TrikeTex.utx
//#exec OBJ LOAD FILE=..\animations\Tribike.ukx

function VehicleFire(bool bWasAltFire)
{
	ServerPlayHorn(0);
}

simulated event DrivingStatusChanged()
{
	local int i;
	local Coords WheelCoords;

	Super(ONSVehicle).DrivingStatusChanged();

	if (bDriving)
          SetTimer(0.05, True);
          Else
               SetTimer(0.0,False);

    if (bDriving && Level.NetMode != NM_DedicatedServer && !bDropDetail)
	{
        Dust.length = 1;
            if (Dust[0] == None)
            {
        		// Create wheel dust emitters.
        		WheelCoords = GetBoneCoords('RearTire');
        		Dust[0] = spawn(class'ONSDirtSlipEffect', self,, WheelCoords.Origin + ((vect(0,0,-1) * Wheels[i].WheelRadius) >> Rotation));
        		Dust[0].SetBase(self);
			    Dust[0].SetDirtColor( Level.DustColor );
        	}

		if(bMakeBrakeLights)
		{
			for(i=0; i<2; i++)
    			if (BrakeLight[i] == None)
    			{
    				BrakeLight[i] = spawn(class'ONSBrakelightCorona', self,, Location + (BrakeLightOffset[i] >> Rotation) );
    				BrakeLight[i].SetBase(self);
    				BrakeLight[i].SetRelativeRotation( rot(0,32768,0) ); // Point lights backwards.
    				BrakeLight[i].Skins[0] = BrakeLightMaterial;
    			}
		}
	}
    else
    {
        if (Level.NetMode != NM_DedicatedServer)
    	{
                Dust[0].Destroy();

            Dust.Length = 0;

            if(bMakeBrakeLights)
            {
            	for(i=0; i<2; i++)
                    if (BrakeLight[i] != None)
                        BrakeLight[i].Destroy();
            }
        }

        TurnDamping = 0.0;
    }
}

Simulated Function UpdateShaft(Float DT)
{
local PlayerController PC;

    PC = Level.GetLocalPlayerController();

    if (Level.NetMode == NM_DedicatedServer)
        return;


    if ( (PC != None) && VSize(PC.pawn.Location - Location) < 2000 )
         {
         R.Roll = ( R.Roll + (Self.Wheels[0].SpinVel * ( dt * 22000)));
         SetBoneRotation('RDShaft', r, 0.2, 1);
         l.Roll = r.Roll;
         SetBoneRotation('LDShaft', l, 0.2, 1);
         }
}

simulated function Tick(float dt)
{
    local int i;
    local bool lostTraction;

    Super(onsvehicle).Tick(dt);

 	// Dont bother doing effects on dedicated server.
	if(Level.NetMode != NM_DedicatedServer && !bDropDetail)
	{
		Updateshaft(DT);
                lostTraction = true;

   		// Update dust kicked up by wheels.
	   	   Dust[0].UpdateDust(Wheels[0], DustSlipRate, DustSlipThresh);

		if(bMakeBrakeLights)
		{
			for(i=0; i<2; i++)
                if (BrakeLight[i] != None)
                    BrakeLight[i].bCorona = True;

			for(i=0; i<2; i++)
                if (BrakeLight[i] != None)
                    BrakeLight[i].UpdateBrakelightState(OutputBrake, Gear);
		}
	}

	TurnDamping = default.TurnDamping;
}

defaultproperties
{
     WheelSoftness=0.040000
     WheelPenScale=1.500000
     WheelPenOffset=0.010000
     WheelRestitution=0.100000
     WheelInertia=0.100000
     WheelLongFrictionFunc=(Points=(,(InVal=100.000000,OutVal=1.000000),(InVal=200.000000,OutVal=0.900000),(InVal=10000000000.000000,OutVal=0.900000)))
     WheelLongSlip=0.001000
     WheelLatSlipFunc=(Points=(,(InVal=30.000000,OutVal=0.009000),(InVal=45.000000),(InVal=10000000000.000000)))
     WheelLongFrictionScale=0.650000
     WheelLatFrictionScale=1.500000
     WheelHandbrakeSlip=0.010000
     WheelHandbrakeFriction=0.100000
     WheelSuspensionTravel=25.000000
     WheelSuspensionMaxRenderTravel=25.000000
     FTScale=0.030000
     ChassisTorqueScale=0.550000
     MinBrakeFriction=4.000000
     MaxSteerAngleCurve=(Points=((OutVal=25.000000),(InVal=1500.000000,OutVal=8.000000),(InVal=1000000000.000000,OutVal=8.000000)))
     TorqueCurve=(Points=((OutVal=9.000000),(InVal=200.000000,OutVal=34.000000),(InVal=1500.000000,OutVal=22.000000),(InVal=2900.000000)))
     GearRatios(0)=-0.500000
     GearRatios(1)=0.200000
     GearRatios(2)=0.450000
     GearRatios(3)=0.950000
     GearRatios(4)=1.500000
     TransRatio=0.290000
     ChangeUpPoint=2200.000000
     ChangeDownPoint=1000.000000
     LSDFactor=1.000000
     EngineBrakeFactor=0.000100
     EngineBrakeRPMScale=0.100000
     MaxBrakeTorque=20.000000
     SteerSpeed=110.000000
     TurnDamping=35.000000
     StopThreshold=100.000000
     HandbrakeThresh=200.000000
     EngineInertia=0.100000
     IdleRPM=500.000000
     EngineRPMSoundRange=5000.000000
     SteerBoneAxis=AXIS_Z
     SteerBoneMaxAngle=90.000000
     DustSlipRate=1.800000
     DustSlipThresh=5.000000
     RevMeterScale=4000.000000
     DaredevilThreshInAirSpin=90.000000
     DaredevilThreshInAirTime=1.200000
     bDoStuntInfo=True
     AirTurnTorque=35.000000
     AirPitchTorque=55.000000
     AirPitchDamping=35.000000
     AirRollTorque=35.000000
     AirRollDamping=35.000000
     RedSkin=Texture'TrikeTex.TrikeRed'
     BlueSkin=Texture'TrikeTex.TrikeBlue'
     IdleSound=Sound'ONSVehicleSounds-S.PRV.PRVEng01'
     StartUpSound=Sound'ONSVehicleSounds-S.PRV.PRVStart01'
     ShutDownSound=Sound'ONSVehicleSounds-S.PRV.PRVStop01'
     StartUpForce="PRVStartUp"
     ShutDownForce="PRVShutDown"
     DestroyedVehicleMesh=StaticMesh'ONSDeadVehicles-SM.newPRVdead'
     DestructionEffectClass=Class'Onslaught.ONSVehicleExplosionEffect'
     DisintegrationEffectClass=Class'Onslaught.ONSVehDeathPRV'
     DisintegrationHealth=-100.000000
     DestructionLinearMomentum=(Min=250000.000000,Max=400000.000000)
     DestructionAngularMomentum=(Min=100.000000,Max=150.000000)
     DamagedEffectScale=1.200000
     DamagedEffectOffset=(X=100.000000,Y=-10.000000,Z=35.000000)
     ImpactDamageMult=0.001000
     Begin Object Class=SVehicleWheel Name=RWheel
         bPoweredWheel=True
         bHandbrakeWheel=True
         BoneName="RearTire"
         WheelRadius=41.500000
         SupportBoneName="RearStrut"
     End Object
     Wheels(0)=SVehicleWheel'Trike.Trike.RWheel'

     Begin Object Class=SVehicleWheel Name=RFWheel
         SteerType=VST_Steered
         BoneName="RFTire"
         WheelRadius=23.160000
         SupportBoneName="RFStrut"
     End Object
     Wheels(1)=SVehicleWheel'Trike.Trike.RFWheel'

     Begin Object Class=SVehicleWheel Name=LFWheel
         SteerType=VST_Steered
         BoneName="LFTire"
         WheelRadius=23.160000
         SupportBoneName="LFStrut"
     End Object
     Wheels(2)=SVehicleWheel'Trike.Trike.LFWheel'

     VehicleMass=4.000000
     bCanDoTrickJumps=True
     bDrawMeshInFP=True
     bHasHandbrake=True
     bDriverHoldsFlag=False
     DrivePos=(X=16.921000,Y=-40.284000,Z=65.793999)
     ExitPositions(0)=(Y=-165.000000,Z=100.000000)
     ExitPositions(1)=(Y=165.000000,Z=100.000000)
     ExitPositions(2)=(Y=-165.000000,Z=-100.000000)
     ExitPositions(3)=(Y=165.000000,Z=-100.000000)
     EntryPosition=(X=20.000000,Y=-60.000000,Z=10.000000)
     EntryRadius=190.000000
     FPCamPos=(X=60.000000,Y=-40.000000,Z=50.000000)
     TPCamDistance=375.000000
     TPCamLookat=(X=0.000000,Z=0.000000)
     TPCamWorldOffset=(Z=100.000000)
     MomentumMult=2.000000
     DriverDamageMult=0.000000
     VehiclePositionString="in a Trike"
     VehicleNameString="Trike"
     RanOverDamageType=Class'Onslaught.DamTypePRVRoadkill'
     CrushedDamageType=Class'Onslaught.DamTypePRVPancake'
     ObjectiveGetOutDist=1500.000000
     HornSounds(0)=Sound'ONSVehicleSounds-S.Horns.Horn09'
     HornSounds(1)=Sound'ONSVehicleSounds-S.Horns.Horn04'
     VehicleIcon=(Material=Texture'AS_FX_TX.Icons.OBJ_HellBender',bIsGreyScale=True)
     GroundSpeed=840.000000
     HealthMax=600.000000
     Health=600
     Mesh=SkeletalMesh'TriBike.Trike'
     DrawScale=1.200000
     SoundVolume=180
     CollisionRadius=175.000000
     Begin Object Class=KarmaParamsRBFull Name=KParams0
         KInertiaTensor(0)=1.000000
         KInertiaTensor(3)=3.000000
         KInertiaTensor(5)=3.500000
         KCOMOffset=(X=-0.300000,Z=-0.500000)
         KLinearDamping=0.050000
         KAngularDamping=0.050000
         KStartEnabled=True
         bKNonSphericalInertia=True
         bHighDetailOnly=False
         bClientOnly=False
         bKDoubleTickRate=True
         bDestroyOnWorldPenetrate=True
         bDoSafetime=True
         KFriction=0.500000
         KImpactThreshold=500.000000
     End Object
     KParams=KarmaParamsRBFull'Trike.Trike.KParams0'

}
