/**
 * RagdollChaining Beta1 11/2/2008
 * Created by Joel Baker (EdudDiputs on http://utforums.epicgames.com)
 *
 * This mutator uses a modified formula from the
 * mutator "NinjaRope2" by Jeff Wofford.
 */

class MutRagChain extends Mutator config (RagChainConfig);


var RagChainList RChainList;

var config int   MaxRagdolls;
var config int   MinRagdolls;
var config float RagdollSeparationDistance;
var config bool  bPullOffScreenChains;
var config float RagdollLifeSpan;
var config int RagdollPhysics;
var config int ChainPullerClassInt;


replication
{
    reliable if(Role==ROLE_Authority && bNetDirty)
        //MaxRagdolls, <- Clients will use their own MaxRagdoll setting
        MinRagdolls, RagdollSeparationDistance,
        RagdollLifeSpan, RagdollPhysics, ChainPullerClassInt;
}

event PostBeginPlay()
{
    local RagChainRules G;
    Super.PostBeginPlay();

    //
    // This is where non-clients set the config properties.
    //
    SetConfigProperties();

    RChainList = spawn(class'RagChainList');
    //RChainList = new(None)class'RagChainList'; //doesn't work as an object. i dunno y

    G = spawn(class'RagChainRules');
    G.RChainList = RChainList;
    if ( Level.Game.GameRulesModifiers == None )
        Level.Game.GameRulesModifiers = G;
    else
        Level.Game.GameRulesModifiers.AddGameRules(G);
}

//Chains are spawned for each player.
//Chains are replicated to all clients.
//Chains are always relavent.
function ModifyPlayer(Pawn Other)
{
    local RagChain NewChain;
    NewChain = spawn(class'RagChain');
    NewChain.ChainPawn = Other;
    NewChain.PRI = Other.PlayerReplicationInfo;
    RChainList.AddChain(NewChain);

    Super.ModifyPlayer(Other);
}

simulated event PostNetReceive()
{
    //
    // This is where clients get and set the config properties.
    //
    SetConfigProperties();
    Super.PostNetReceive();

}

simulated function SetConfigProperties()
{
    local class<IChainPuller> ChainPullerClass;
    ChainPullerClass = class'IChainPuller'.static.GetPullerClass(ChainPullerClassInt);
    ChainPullerClass.default.RagdollSeparationDistance = RagdollSeparationDistance;


    if(MaxRagdolls > Level.MaxRagdolls)
    {
        Level.MaxRagdolls = MaxRagdolls;
        //Log("set level.MaxRagdolls, " $ Level.MaxRagdolls $ " = " $ MaxRagdolls);
    }
    class'RagChain'.default.MinRagdolls = MinRagdolls;
    class'RagChain'.default.RagdollLifeSpan = RagdollLifeSpan;
    class'RagChain'.default.bZeroCollisionRagdolls = RagdollPhysics == 2;
    class'RagChain'.default.bZeroGravityRagdolls = RagdollPhysics == 1 || RagdollPhysics == 2;
    class'RagChain'.default.ChainPullerClass = ChainPullerClass;
    class'RagChain'.default.bPullOffScreenChains = bPullOffScreenChains || class'RagChain'.default.bZeroGravityRagdolls;

}

//Configuration Settings
static event string GetDescriptionText(string PropName) {
  switch (PropName) {
    case "MaxRagdolls":  return "Total ragdolls at one time. Lower it if you are losing frames. Clients use their own config";
    case "MinRagdolls":  return "These ragdolls will never deres from a chain";
    case "RagdollSeparationDistance":  return "Distance between each ragdoll link";
    //case "bPullOffScreenChains": return "Pull off screen chains (turn off if slow)";
    case "RagdollLifeSpan": return "Seconds until the last link will deres (-1 for default)";
    case "RagdollPhysics": return "Ragdoll Physics";
    case "ChainPullerClassInt": return "Chain Behavior";
  }
  return Super.GetDescriptionText(PropName);
}
static function FillPlayInfo(PlayInfo PlayInfo) {
    Super.FillPlayInfo(PlayInfo);  // Always begin with calling parent
    PlayInfo.AddSetting(default.RulesGroup, "MaxRagdolls", "Max Ragdolls", 0, 0, "Text", "4;0:9999", , False, False);
    PlayInfo.AddSetting(default.RulesGroup, "MinRagdolls", "Min Ragdolls per Chain", 0, 0, "Text", "4;0:9999", , False, False);
    PlayInfo.AddSetting(default.RulesGroup, "RagdollSeparationDistance", "Distance between ragdolls", 0, 0, "Text", "4;0.0:9999.9", , False, False);
    //PlayInfo.AddSetting(default.RulesGroup, "bPullOffScreenChains", GetDescriptionText("bPullOffScreenChains"), 0, 0, "Check", "", , False, False);
    PlayInfo.AddSetting(default.RulesGroup, "RagdollLifeSpan", "Ragdoll Life Span", 0, 0, "Text", "-1;-1.0:9999999.9", , False, False);
    PlayInfo.AddSetting(default.RulesGroup, "RagdollPhysics", GetDescriptionText("RagdollPhysics"), 0, 0, "Select", "0;Default;1;0 Grav;2;0 Grav + No Collision", , False, False);
    PlayInfo.AddSetting(default.RulesGroup, "ChainPullerClassInt", GetDescriptionText("ChainPullerClassInt"), 0, 0, "Select", class'IChainPuller'.static.GetMutSelectionString(), , False, False);
}
/*
Old config items that i've removed for now...
var config bool  bKImportantRagdoll;
var localized string GUIDescText[2];    // Config property long descriptions
bKImportantRagdoll=True
GUIDescText(2)="Unreal will not eat chained ragdolls"
 return default.GUIDescText[1];
case "bKImportantRagdoll": return default.GUIDescText[2];
PlayInfo.AddSetting(default.RulesGroup, "bKImportantRagdoll", GetDescriptionText("bKImportantRagdoll"), 0, 0, "Check", , , False, False);
//var bool  bZeroCollisionRagdolls;
//var bool  bZeroGravityRagdolls;
//case "bZeroCollisionRagdolls": return "Ragdolls go through walls + 0 grav";
//case "bZeroGravityRagdolls": return "Ragdolls have zero gravity";
//PlayInfo.AddSetting(default.RulesGroup, "bZeroCollisionRagdolls", GetDescriptionText("bZeroCollisionRagdolls"), 0, 0, "Check", "", , False, False);
//PlayInfo.AddSetting(default.RulesGroup, "bZeroGravityRagdolls", GetDescriptionText("bZeroGravityRagdolls"), 0, 0, "Check", "", , False, False);
//     bZeroCollisionRagdolls = false
//     bZeroGravityRagdolls = false
*/
defaultproperties
{
     MaxRagdolls = 45
     MinRagdolls = 2
     RagdollSeparationDistance = 150
     bPullOffScreenChains = true
     RagdollLifeSpan=-1.0
     RagdollPhysics=1
     ChainPullerClassInt=0


     bAddToServerPackages=True
     GroupName="RagChainRule"
     FriendlyName="Ragdoll Chainin' B1"
     Description="The Dead Like to Party"

     bAlwaysRelevant=true
     bNetNotify=True
     RemoteRole=ROLE_SimulatedProxy
}
