class StiffChainPuller extends IChainPuller;

var StiffChainPuller StaticInstance;

function TickPull(float DeltaTime, Pawn CurrentChainHead, array<xPawn> ChainLinks)
{
    local vector target;
    local int i;

    if(ChainLinks.Length >= 1)
    {
    target = class'RagUtils'.static.PointAlongLine(CurrentChainHead.Location, ChainLinks[0].Location, RagdollSeparationDistance);
    class'RagUtils'.static.PullRagdollToLocationD(ChainLinks[0], target, RagdollSeparationDistance / 2);
    }
    for(i = 1; i < ChainLinks.Length; ++i)
    {
    target = class'RagUtils'.static.PointAlongLine(ChainLinks[i-1].Location, ChainLinks[i].Location, RagdollSeparationDistance);
    class'RagUtils'.static.PullRagdollToLocationD(ChainLinks[i], target, RagdollSeparationDistance / 2);
    }
}
static function IChainPuller NewChainPuller(RagChain chain)
{
    if(default.StaticInstance == None)
    {
        default.StaticInstance = new(None)class'StiffChainPuller';
    }
    return default.StaticInstance;
}

defaultproperties
{
    MutSelectName="Stiff"
}
