class RagChainRules extends GameRules;

var RagChainList RChainList;

//Chains have a "KillerChain" field
//If KillerChain == None.. the chain opperates normally (the player has not been killed)
//If KillerChain != None.. the chain kills itself and joins the KillerChain
//If KillerChain == self.. the chain just kills itself
//ScoreKill will update and replicate this KillerChain field when someone dies.

function ScoreKill(Controller Killer, Controller Killed)
{
    local RagChain KilledChain;
    local Pawn KilledPawn, KillerPawn;
    Super.ScoreKill(Killer,Killed);

    //Log("Getting Pawns for ScoreKill");
    KilledPawn = GetPawn(Killed);
    KillerPawn = GetPawn(Killer);

    if( KilledPawn != None )
    {
        if( KillerPawn != None )
        {
            KilledChain = RChainList.GetChainForPawn(KilledPawn);
            if(KilledChain == None)
            {
                return;
            }
            KilledChain.KillerChain = RChainList.GetChainForPawn(KillerPawn);


            if(KilledChain.KillerChain == None)
            {
                //Should not happen, i think
                //Every Pawn should have a chain
                KilledChain.KillerChain = KilledChain;
            }
        }
        else
        {
            KilledChain = RChainList.GetChainForPawn(KilledPawn);
            if(KilledChain != None)
            {
                KilledChain.KillerChain = KilledChain;
            }
        }
    }
}
function Pawn GetPawn(Controller ctrlr)
{
    local Vehicle v;
    local Pawn p;
    if(ctrlr == None)
        return None;

    p = ctrlr.Pawn;
    v = Vehicle(p);
    if(v != None && v.Driver != None)
    {
        p = v.Driver;
        //Log("Pulling out the driver");
    }
    return p;
}
