class IChainPuller extends Object
      abstract;

/**
 * To make your own ChainPuller:
 * 1. Make a class that extends IChainPuller
 * 2. Override TickPull and NewChainPuller in your class
 * 3. Set a unique MutSelectName in the default properties
 * 4. Add your class to the list of classes in GetPullerClasses()
 * 5. Post it on http://utforums.epicgames.com so we can play with it too, thanks!
 *
 * By the way, if you want to make config options for your specific chainpuller,
 * go right ahead and do it.
 * Look at RagdollSeparationDistance in MutRagChain to see how to do this.
 * Just try to immitate what I did with that.
 * Good luck.
 */




/**
 * Mutator config options.  Do whatever you want with these.
 * Update MutRagChain to let the user config these options.
 */
var float RagdollSeparationDistance;


/**
 * User friendly display name for the mutator select list.
 * Be sure to set this to a unique name in your subclass.
 */
var string MutSelectName;


/**
 * IChainPuller uses these private vars to keep a list of all it's subclasses.
 * You only need to add your subclass in the GetPullerClasses() method.
 * Other than that don't worry about this.
 */
var private array<class<IChainPuller> > PullerClasses;
var private string MutSelectionString;

/**
 * Just add your IChainPuller subclass to this list and it should be
 * selectable from the mutator menu.
 * (Remember to set a new MutSelectName in your default properties)
 */
static final function array<class<IChainPuller> > GetPullerClasses()
{
    if(default.PullerClasses.Length == 0)
    {
        default.PullerClasses[default.PullerClasses.Length] = class'SnakeChainPuller';
        default.PullerClasses[default.PullerClasses.Length] = class'StiffChainPuller';
    }
    return default.PullerClasses;
}


/**
 *  Methods to be overridden in ChainPullers!
 *  TickPull lets you define the behavior of the ragdoll chain.
 *  NewChainPuller() is like the "constructor" for your puller.
 *  You have to override these 2.
 */
function TickPull(float DeltaTime, Pawn CurrentChainHead, array<xPawn> ChainLinks)
{

}
static function IChainPuller NewChainPuller(RagChain chain)
{
    return None;
}










/**
 *  Static, "final" methods used by MutRagChain
 *  to allow the user to choose a prefered subclass.
 *  Don't worry about these.
 *  Just update GetPullerClasses with your class.
 */
static final function string GetMutSelectionString()
{
    local array<class<IChainPuller> > Classes;
    local int i;

    if(default.MutSelectionString == "")
    {
        Classes = GetPullerClasses();


        for(i = 0; i < Classes.Length; ++i)
        {
            default.MutSelectionString $= i $ ";" $ Classes[i].default.MutSelectName;
            if(i < Classes.Length - 1)
                default.MutSelectionString $= ";";
        }
    }
    return default.MutSelectionString;
}

static final function class<IChainPuller> GetPullerClass(int ChainPullerClassInt)
{
    local array<class<IChainPuller> > Classes;
    Classes = GetPullerClasses();


    if(ChainPullerClassInt < Classes.Length)
        return Classes[ChainPullerClassInt];
    else
        return class'SnakeChainPuller';
}

defaultproperties
{
    RagdollSeparationDistance=150
    MutSelectionString = ""
}
