/* 
    Battle Team Arena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of Battle Team Arena.

    Battle Team Arena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleTeamArena/Classes/BattleTeamArena.uci) 

class BattleDynamicMenu extends UTUIScene;

var BattlePlayerController BPC;

var transient UILabel Labels_Title;
var transient UIImage Image_Background;
var transient array<UILabel> Labels[20];
var transient array<UTUISlider> Sliders[20];
var transient array<UILabelButton> Buttons[20];
var transient array<UTUIEditBox> Edits[20];
var transient array<UTUIComboBox> Combos[20];
var array<string> ComboAllValueStrings[20];

var int CloseButtonID;
var int DefaultsButtonID;
var int AdminButtonID;
var int AdminDefaultsButtonID;
var int PlayerButtonID;

var int HitSoundComboID;
var int SkinComboID;
var int HUDComboID;
var int CampingComboID;

var int ChallengeModeComboID;
var int RoundLengthComboID;
var int HUDSettingComboID;
var int FovSliderID;
var int FovSettingSliderID;
var int RemoveComboID;
var int WeaponsComboID;
var int AmmoComboID;
var int ImpactHammerComboID;

var int B1, B2, B3, B4;
var float L, T;

var int NextLabel;
var int NextSlider;
var int NextButton;
var int NextEdit;
var int NextCombo;

var int UpdateCountdown, UpdateAdminCountdown;

function ConnectObjects ()
{
  local int i;

  Labels_Title = UILabel (FindChild ('UILabel_Title', true));
  Image_Background = UIImage (FindChild ('UIImage_Background', true));
  for (i=0; i<20; i++) {
    Labels[i] = UILabel (FindChild (name("UILabel_"$i), true));
    Sliders[i] = UTUISlider (FindChild (name ("UTUISlider_"$i), true));
    Buttons[i] = UILabelButton (FindChild (name ("UILabelButton_"$i), true));
    Buttons[i].OnClicked = OnClicked;
    Edits[i] = UTUIEditBox (FindChild (name ("UTUIEditBox_"$i), true));
    Combos[i] = UTUIComboBox (FindChild (name ("UTUIComboBox_"$i), true));
    Combos[i].ComboEditbox.SetReadOnly (true);
  }
  ResetDialog ();
}

function ResetDialog ()
{
  local int i;

  Labels_Title = UILabel (FindChild ('UILabel_Title', true));
  Image_Background = UIImage (FindChild ('UIImage_Background', true));
  for (i=0; i<20; i++) {
    Labels[i].SetVisibility (false);
    Sliders[i].SetVisibility (false);
    Buttons[i].SetVisibility (false);
    Edits[i].SetVisibility (false);
    Combos[i].SetVisibility (false);
  }
  Labels_Title.SetVisibility (false);
  Image_Background.SetVisibility (false);

  NextLabel = 0;
  NextSlider = 0;
  NextButton = 0;
  NextEdit = 0;
  NextCombo = 0;
  CloseButtonID = -1;
  HitSoundComboID = -1;
  DefaultsButtonID = -1;
  AdminButtonID = -1;
  AdminDefaultsButtonID = -1;
  PlayerButtonID = -1;
  SkinComboID = -1;
  HUDComboID = -1;
  FovSliderID = -1;
  CampingComboID = -1;
  ChallengeModeComboID = -1;
  RoundLengthComboID = -1;
  HUDSettingComboID = -1;
  FovSettingSliderID = -1;
  RemoveComboID = -1;
  WeaponsComboID = -1;
  AmmoComboID = -1;
  ImpactHammerComboID = -1;
}

event PostInitialize()
{
  super.PostInitialize();

  BattlePlayerController (GetUTPlayerOwner()).BDM = Self;
  BPC = BattlePlayerController (GetUTPlayerOwner());
  ConnectObjects ();

  UpdateCountdown = 2; // Wait 2 ticks and then initialize, otherwise UT3 will crash.
}

function int DrawLabel (float Left, float Top, string Text)
{
  Left = Left + 0.245;
  Top = Top + 0.176;

  Labels[NextLabel].SetPosition (Left, UIFACE_Left, EVALPOS_PercentageViewport);
  Labels[NextLabel].SetPosition (Top, UIFACE_Top, EVALPOS_PercentageViewport);
  Labels[NextLabel].SetValue (Text);
  Labels[NextLabel].SetVisibility (true);
  return NextLabel++;
}

function int DrawSlider (float Left, float Top, int Low, int High, int Value)
{
  Left = Left + 0.279;
  Top = Top + 0.167;
  
  Sliders[NextSlider].SliderValue.MinValue = Low;
  Sliders[NextSlider].SliderValue.MaxValue = High;
  Sliders[NextSlider].SetValue (float (Value));
  Sliders[NextSlider].CaptionRenderComponent.SetValue (string (Value));
  Sliders[NextSlider].SetPosition (Left, UIFACE_Left, EVALPOS_PercentageViewport);
  Sliders[NextSlider].SetPosition (Top, UIFACE_Top, EVALPOS_PercentageViewport);
  Sliders[NextSlider].SetPosition (Left + 0.28, UIFACE_Right, EVALPOS_PercentageViewport);
  Sliders[NextSlider].SetVisibility (true);
  return NextSlider++;
}

function int DrawButton (float Left, float Top, string Text)
{
  Left = Left + 0.238;
  Top = Top + 0.162;

  Buttons[NextButton].SetPosition (Left, UIFACE_Left, EVALPOS_PercentageViewport);
  Buttons[NextButton].SetPosition (Top, UIFACE_Top, EVALPOS_PercentageViewport);
  Buttons[NextButton].SetPosition (Left + 0.13, UIFACE_Right, EVALPOS_PercentageViewport);
  Buttons[NextButton].SetCaption (Text);
  Buttons[NextButton].SetVisibility (true);
  return NextButton++;
}

function int DrawEdit (float Left, float Top, string Value)
{
  Left = Left + 0.243;
  Top = Top + 0.165;

  Edits[NextEdit].SetPosition (Left, UIFACE_Left, EVALPOS_PercentageViewport);
  Edits[NextEdit].SetPosition (Top, UIFACE_Top, EVALPOS_PercentageViewport);
  Edits[NextEdit].SetPosition (Left + 0.31, UIFACE_Right, EVALPOS_PercentageViewport);
  Edits[NextEdit].SetValue (Value);
  Edits[NextEdit].SetVisibility (true);
  return NextEdit++;
}

function int GetComboIntValue (int ID)
{
  return int (GetComboStringValue (ID));
}

function string GetComboStringValue (int ID)
{
  local int Index, V;
  local string AllValues, InternalValue, Value;

  AllValues = ComboAllValueStrings[ID];
  Index = Combos[ID].ComboList.Index;
  V = 0;
  while (V < 100 && InStr (AllValues, ";") != -1) {
    AllValues = Mid (AllValues, InStr (AllValues, ";") + 1);
    if (InStr (AllValues, ";") != -1) {
      InternalValue = Mid (AllValues, 0, InStr (AllValues, ";"));
      AllValues = Mid (AllValues, InStr (AllValues, ";") + 1);
    } else {
      InternalValue = AllValues;
      AllValues = ""; 
    }
    if (V == Index) {
      Value = InternalValue;
    }
    V++;
  }

  return Value;
}

function int DrawCombo (float Left, float Top, string Value, string AllValues)
{
  local UTUIDataStore_StringList StringStore;
  local int V;
  local int S;
  local string VisibleValue;
  local string InternalValue;

  Left = Left + 0.2615;
  Top = Top + 0.170;

  V = 0;
  ComboAllValueStrings[NextCombo] = AllValues;
  Combos[NextCombo].SetPosition (Left, UIFACE_Left, EVALPOS_PercentageViewport);
  Combos[NextCombo].SetPosition (Top, UIFACE_Top, EVALPOS_PercentageViewport);
  Combos[NextCombo].SetPosition (Left + 0.30, UIFACE_Right, EVALPOS_PercentageViewport);
  StringStore = UTUIDataStore_StringList (ResolveDataStore ('UTStringList'));
  StringStore.Empty (name ("BTADATA_COMBO_"$NextCombo));
  while (V < 100 && InStr (AllValues, ";") != -1) {
    VisibleValue = Mid (AllValues, 0, InStr (AllValues, ";"));
    AllValues = Mid (AllValues, InStr (AllValues, ";") + 1);
    if (InStr (AllValues, ";") != -1) {
      InternalValue = Mid (AllValues, 0, InStr (AllValues, ";"));
      AllValues = Mid (AllValues, InStr (AllValues, ";") + 1);
    } else {
      InternalValue = AllValues;
      AllValues = ""; 
    }
    StringStore.AddStr(name ("BTADATA_COMBO_"$NextCombo), VisibleValue);
    if (InternalValue == Value) {
      S = V;
    }
    V++;
  }
  Combos[NextCombo].ComboList.SetDataStoreBinding("<UTStringList:"$"BTADATA_COMBO_"$NextCombo$">");
  Combos[NextCombo].ComboList.RefreshSubscriberValue();
  Combos[NextCombo].SetSelectedItem (S);
  if (V > 15) {
    Combos[NextCombo].ComboList.SetRowCount(15);
  } else {
    Combos[NextCombo].ComboList.SetRowCount(V);
  }
  Combos[NextCombo].SetVisibility (true);
  return NextCombo++;
}

function float DLine (float Line)
{
  return 0.02 + Line * 0.06;
}

function float DCol (float Col)
{
  return 0.02 + Col * 0.15;
}

function InitDialog (string Title, int Lines)
{
  Labels_Title.SetValue (Title);
  Image_Background.SetPosition (0.30 + Lines * 0.06, UIFACE_Bottom, EVALPOS_PercentageViewport);
  Labels_Title.SetVisibility (true);
  Image_Background.SetVisibility (true);
}

function int UD (bool bUseDefaults, int DefaultValue, int Current) // UD: Use Defaults
{
  if (bUseDefaults) return DefaultValue;
  return Current;
}

function DrawAdminDialog (optional bool bUD=false) // bUD: Use Defaults
{
  ResetDialog();

  InitDialog ("Battle Team/Freezetag Arena "$`Version$" - Admin Settings", 9);

  DrawLabel  (DCol (0), DLine (0), "Camping");
  CampingComboID = DrawCombo  (DCol (1), DLine (0), string(UD (bUD, 15, BattleGRI (BPC.WorldInfo.GRI).CampingSetting)), "Allow 10 Seconds;10;Allow 15 Seconds;15;Allow 20 Seconds;20;Allow 30 Seconds;30;Allow 45 Seconds;45;Allow 60 Seconds;60;Allow Unlimited;9999");

  DrawLabel  (DCol (0), DLine (1), "Challenge Mode");
  ChallengeModeComboID = DrawCombo  (DCol (1), DLine (1), string(UD (bUD, 0, BattleGRI (BPC.WorldInfo.GRI).ChallengeModeSetting)), "Losing Extra, Winning Less;0;Losing Extra;1;Nothing;2");

  DrawLabel  (DCol (0), DLine (2), "Round Length");
  RoundLengthComboID = DrawCombo  (DCol (1), DLine (2), string(UD (bUD, 120, BattleGRI (BPC.WorldInfo.GRI).RoundLengthSetting)), "30 Seconds;30;1 Minute;60;2 Minutes;120;3 Minutes;180;4 Minutes;240;5 Minutes;300");

  DrawLabel  (DCol (0), DLine (3), "HUD");
  HUDSettingComboID = DrawCombo  (DCol (1), DLine (3), string(UD (bUD, 0, BattleGRI (BPC.WorldInfo.GRI).HUDSetting)), "Allow Stats and 3D Radar;0;Allow Stats;1;Allow 3D Radar;2;Allow Nothing;3");

  DrawLabel  (DCol (0), DLine (4), "Allow FOV");
  FovSettingSliderID = DrawSlider (DCol (1), DLine (4), 100, 150, UD (bUD, 120, BattleGRI (BPC.WorldInfo.GRI).FovSetting));

  DrawLabel  (DCol (0), DLine (5), "Map Items");
  RemoveComboID = DrawCombo  (DCol (1), DLine (5), string(UD (bUD, 0, BattleGRI (BPC.WorldInfo.GRI).RemoveSetting)), "Remove Everything;0;Keep Weapons/Ammo/Health;1;Keep Vehicles;2;Keep Weapons/Vehicles;3;Keep Everything;4");

  DrawLabel  (DCol (0), DLine (6), "Give Weapons");
  WeaponsComboID = DrawCombo  (DCol (1), DLine (6), string(UD (bUD, 8, BattleGRI (BPC.WorldInfo.GRI).WeaponsSetting)), "Hammer + Enforcer;1;'' + SniperRifle;2;'' + ShockRifle;3;'' + LinkGun;4;'' + RocketLauncher;5;'' + FlakCannon;6;'' + Stinger;7;'' + BioRifle;8;'' + Avril;9;");

  DrawLabel  (DCol (0), DLine (7), "Give Ammo");
  AmmoComboID = DrawCombo  (DCol (1), DLine (7), string(UD (bUD, 100, BattleGRI (BPC.WorldInfo.GRI).AmmoSetting)), "Standard;100;-80%;20;-50%;50;+50%;150;+100%;200;Max;1000");

  DrawLabel  (DCol (0), DLine (8), "Impact Hammer");
  ImpactHammerComboID = DrawCombo  (DCol (1), DLine (8), string(UD (bUD, 0, BattleGRI (BPC.WorldInfo.GRI).ImpactHammerSetting)), "Standard;1;Reduced Self Damage;0;+ Reduced Fall Damage;2;+ Boost;3;+ Ultra Boost;4");

  CloseButtonID = DrawButton (DCol (0), DLine (9.5), "Close");
  AdminDefaultsButtonID = DrawButton (DCol (1), DLine (9.5), "Defaults");
  PlayerButtonID = DrawButton (DCol (2), DLine (9.5), "Back");
}

function DrawDialog ()
{
  local string Settings;

  ResetDialog();

  if (BattleGRI (BPC.WorldInfo.GRI).HUDSetting == 3) {
    InitDialog ("Battle Team/Freezetag Arena "$`Version$" - Settings", 3);
  } else {
    InitDialog ("Battle Team/Freezetag Arena "$`Version$" - Settings", 4);
  }

  DrawLabel  (DCol (0), DLine (0), "Hitsounds");
  Settings $= "No Hitsounds;999;";
  Settings $= "Arrow;5;Arrow Inverted;4;";
  Settings $= "Cash;7;Cash Inverted;6;";
  Settings $= "Flick;9;Flick Inverted;8;";
  Settings $= "Pingwarb;11;Pingwarb Inverted;10;";
  Settings $= "Plop;13;Plop Inverted;12;";
  Settings $= "Pock;15;Pock Inverted;14;";
  Settings $= "Poing;17;Poing Inverted;16;";
  Settings $= "Ramp;19;Ramp Inverted;18;";
  Settings $= "Random;3;Random Inverted;2;";
  Settings $= "Shot;21;Shot Inverted;20;";
  Settings $= "Tock;23;Tock Inverted;22;";
  Settings $= "Whizpop;25;Whizpop Inverted;24;";
  Settings $= "Wood;27;Wood Inverted;26;";
  Settings $= "Woosh;29;Woosh Inverted;28;";
  Settings $= "Zap;31;Zap Inverted;30;";
  Settings $= "Zwee;1;Zwee Inverted;0";
  HitSoundComboID = DrawCombo  (DCol (1), DLine (0), string(BPC.HitSoundSetting), Settings);

  DrawLabel  (DCol (0), DLine (1), "Skins");
  SkinComboID = DrawCombo  (DCol (1), DLine (1), string(BPC.SkinSetting), "Liquid Blue Ice;0;Grey Ice;1;Solid Gold;2;Frozen Tar;3;Bright Color Skins;4;Liquid Skins;5;Glowing Skins;6;Liquid + Gold;7");

  if (BattleGRI (BPC.WorldInfo.GRI).HUDSetting == 0) {
    DrawLabel  (DCol (0), DLine (2), "HUD");
    HUDComboID = DrawCombo  (DCol (1), DLine (2), string(BPC.HUDSetting), "Stats and 3D Radar;0;Stats;1;3D Radar;2;Nothing;3");
  } else if (BattleGRI (BPC.WorldInfo.GRI).HUDSetting == 1) {
    DrawLabel  (DCol (0), DLine (2), "HUD");
    HUDComboID = DrawCombo  (DCol (1), DLine (2), string(BPC.HUDSetting), "Stats;1;Nothing;3");
  } else if (BattleGRI (BPC.WorldInfo.GRI).HUDSetting == 2) {
    DrawLabel  (DCol (0), DLine (2), "HUD");
    HUDComboID = DrawCombo  (DCol (1), DLine (2), string(BPC.HUDSetting), "3D Radar;2;Nothing;3");
  }

  if (BattleGRI (BPC.WorldInfo.GRI).HUDSetting == 3) {
    DrawLabel  (DCol (0), DLine (2), "FOV");
    FovSliderID = DrawSlider (DCol (1), DLine (2), 80, BattleGRI (BPC.WorldInfo.GRI).FovSetting, BPC.OnFootDefaultFOV);

    CloseButtonID = DrawButton (DCol (0), DLine (3.5), "Close");
    DefaultsButtonID = DrawButton (DCol (1), DLine (3.5), "Defaults");
    if (BPC.PlayerReplicationInfo.bAdmin || BPC.WorldInfo.NetMode == NM_Standalone) {
      AdminButtonID = DrawButton (DCol (2), DLine (3.5), "Admin");
    }
  } else {
    DrawLabel  (DCol (0), DLine (3), "FOV");
    FovSliderID = DrawSlider (DCol (1), DLine (3), 80, BattleGRI (BPC.WorldInfo.GRI).FovSetting, BPC.OnFootDefaultFOV);

    CloseButtonID = DrawButton (DCol (0), DLine (4.5), "Close");
    DefaultsButtonID = DrawButton (DCol (1), DLine (4.5), "Defaults");
    if (BPC.PlayerReplicationInfo.bAdmin || BPC.WorldInfo.NetMode == NM_Standalone) {
      AdminButtonID = DrawButton (DCol (2), DLine (4.5), "Admin");
    }
  }
}

function bool OnRawInputKey (const out InputEventParameters EventParms)
{
  if ((EventParms.InputKeyName=='Escape' || EventParms.InputKeyName=='F12') && EventParms.EventType == IE_Pressed) {
    CloseScene(self);
  }
  return false;
}

function bool OnClicked(UIScreenObject EventObject, int PlayerIndex)
{
  if (CloseButtonID != -1 && EventObject==Buttons[CloseButtonID]) {
    CloseScene (self);
  } else if (DefaultsButtonID != -1 && EventObject==Buttons[DefaultsButtonID]) {
    BPC.FOV (100); 
    BPC.HitSoundSetting = 0;
    BPC.SkinSetting = 0;
    BPC.HUDSetting = 0;
    BPC.SaveConfig();
    DrawDialog ();
  } else if (AdminDefaultsButtonID != -1 && EventObject==Buttons[AdminDefaultsButtonID]) {
    DrawAdminDialog (true);
  } else if (AdminButtonID != -1 && EventObject==Buttons[AdminButtonID]) {
    DrawAdminDialog ();
  } else if (PlayerButtonID != -1 && EventObject==Buttons[PlayerButtonID]) {
    DrawDialog ();
  }
  return true;
}

function TickAnyway () // UTUIScene does not seem to do tick or timer so we let the BattlePlayerController call us
{ 
  if (UpdateCountdown > 0) {
    if (UpdateCountdown == 1) {
      DrawDialog(); 
    }
    UpdateCountdown--;
  }
  if (CampingComboID != -1) {
    if (GetComboIntValue(CampingComboID) != BattleGRI (BPC.WorldInfo.GRI).CampingSetting) {
      BPC.AdminSetCampingSetting (GetComboIntValue (CampingComboID));
    }
  }
  if (ChallengeModeComboID != -1) {
    if (GetComboIntValue(ChallengeModeComboID) != BattleGRI (BPC.WorldInfo.GRI).ChallengeModeSetting) {
      BPC.AdminSetChallengeModeSetting (GetComboIntValue (ChallengeModeComboID));
    }
  }
  if (RoundLengthComboID != -1) {
    if (GetComboIntValue(RoundLengthComboID) != BattleGRI (BPC.WorldInfo.GRI).RoundLengthSetting) {
      BPC.AdminSetRoundLengthSetting (GetComboIntValue (RoundLengthComboID));
    }
  }
  if (HUDSettingComboID != -1) {
    if (GetComboIntValue(HUDSettingComboID) != BattleGRI (BPC.WorldInfo.GRI).HUDSetting) {
      BPC.AdminSetHUDSetting (GetComboIntValue (HUDSettingComboID));
    }
  }
  if (FOVSettingSliderID != -1) {
    if (Sliders[FOVSettingSliderID].GetValue() != BattleGRI (BPC.WorldInfo.GRI).FOVSetting) {
      BPC.AdminSetFovSetting (Sliders[FOVSettingSliderID].GetValue());
    }
  }
  if (RemoveComboID != -1) {
    if (GetComboIntValue(RemoveComboID) != BattleGRI (BPC.WorldInfo.GRI).RemoveSetting) {
      BPC.AdminSetRemoveSetting (GetComboIntValue (RemoveComboID));
    }
  }
  if (WeaponsComboID != -1) {
    if (GetComboIntValue(WeaponsComboID) != BattleGRI (BPC.WorldInfo.GRI).WeaponsSetting) {
      BPC.AdminSetWeaponsSetting (GetComboIntValue (WeaponsComboID));
    }
  }
  if (AmmoComboID != -1) {
    if (GetComboIntValue(AmmoComboID) != BattleGRI (BPC.WorldInfo.GRI).AmmoSetting) {
      BPC.AdminSetAmmoSetting (GetComboIntValue (AmmoComboID));
    }
  }
  if (ImpactHammerComboID != -1) {
    if (GetComboIntValue(ImpactHammerComboID) != BattleGRI (BPC.WorldInfo.GRI).ImpactHammerSetting) {
      BPC.AdminSetImpactHammerSetting (GetComboIntValue (ImpactHammerComboID));
    }
  }
  if (FovSliderID != -1) {
    if (Sliders[FovSliderID].GetValue() != BPC.OnFootDefaultFOV) {
      BPC.FOV (Sliders[FovSliderID].GetValue()); 
    }
  }
  if (HitSoundComboID != -1) {
    if (GetComboIntValue(HitSoundComboID) != BPC.HitSoundSetting) {
      BPC.HitSoundSetting = GetComboIntValue(HitSoundComboID) ;
      BPC.SaveConfig();
      BPC.HitSound (25);
    }
  }
  if (SkinComboID != -1) {
    if (GetComboIntValue(SkinComboID)  != BPC.SkinSetting) {
      BPC.SkinSetting = GetComboIntValue(SkinComboID);
      BPC.SaveConfig();
    }
  }
  if (HUDComboID != -1) {
    if (GetComboIntValue(HUDComboID) != BPC.HUDSetting) {
      BPC.HUDSetting = GetComboIntValue(HUDComboID);
      BPC.SaveConfig();
    }
  }
}

defaultproperties
{
  bPauseGameWhileActive=False
//  __OnRawInputKey__Delegate=Default__BattleMainMenu.OnRawInputKey
  Name="Default__BattleDynamicMenu"
}