/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    This file also contains code that is derived from code which is
    Copyright 1998-2007 Epic Games, Inc. All Rights Reserved. That part 
    of the code is covered by the Epic license and not by the GPL.
*/ 

class BattleSquadAI extends UTSquadAI;

function bool CloseToLeader(Pawn P)
{
	local float dist;
    local float Optimaldist;
    local BattlePRI BPRI;


	if ( (P == None) || (SquadLeader.Pawn == None) )
		return true;

	if ( Vehicle(P) == None )
	{
		if ( (UTVehicle(SquadLeader.Pawn) != None)
			&& UTVehicle(SquadLeader.Pawn).OpenPositionFor(P) )
			return false;
	}
	else if (PlayerController(SquadLeader) != None && Vehicle(SquadLeader.Pawn) == None)
	{
		return false;
	}
	// if in flying vehicle and above leader, give him air support instead of going down where he is
	else if (P.bCanFly && VolumePathNode(P.Anchor) != None && P.Anchor.GetReachSpecTo(SquadLeader.Pawn.Anchor) != None)
	{
		return true;
	}

	if ( (P.GetVehicleBase() == SquadLeader.Pawn)
		|| (SquadLeader.Pawn.GetVehicleBase() == P) )
		return true;

	// for certain games, have bots wait for leader for a while
	if ( (P.Base != None) && (SquadLeader.Pawn.Base != None) && (SquadLeader.Pawn.Base != P.Base) )
		return false;

	dist = VSize(P.Location - SquadLeader.Pawn.Location);
    optimaldist = 1100.0;
    if (BattleFreezetagArena (WorldInfo.Game) != None) {
      if (SquadLeader != None && SquadLeader.Pawn != None
          && Abs (P.Health - SquadLeader.Pawn.Health) > 10) optimaldist = 90; // Heal or get healed by squad leader
      if (SquadLeader != None && SquadLeader.PlayerReplicationInfo != None) {
        BPRI = BattlePRI (SquadLeader.PlayerReplicationInfo);
        if (BPRI != None) {
          if (BPRI.SpecialPlayerState == SPS_Frozen) optimaldist = 90; // Unfreeze the squad leader
        }
      }
    } 
	if (dist > optimaldist) return false;

	// check if leader is moving away
	if ( PhysicsVolume.bWaterVolume )
	{
		if ( VSize(SquadLeader.Pawn.Velocity) > 0 )
			return false;
	}
	else if ( VSize(SquadLeader.Pawn.Velocity) > SquadLeader.Pawn.WalkingPct * SquadLeader.Pawn.GroundSpeed )
		return false;

	return ( P.Controller.LineOfSightTo(SquadLeader.Pawn) );
}

/** @return the maximum distance a bot should be from the given Actor it wants to defend */
function float GetMaxDefenseDistanceFrom(Actor Center, UTBot B)
{
  local float optimaldist;
  local BattlePRI BPRI;

  if (Pawn(Center) != None) {
    optimaldist = 1100.0;
    if (Abs (Pawn(Center).Health - B.Pawn.Health) > 10) optimaldist = 90; // Heal or get healed
    if (Pawn(Center) != None && Pawn(Center).PlayerReplicationInfo != None) {
      BPRI = BattlePRI (Pawn(Center).PlayerReplicationInfo);
      if (BPRI != None) {
        if (BPRI.SpecialPlayerState == SPS_Frozen) optimaldist = 90; // Unfreeze
      }
    } 
    return optimaldist;
  } else {
    return NEAROBJECTIVEDIST;
  }
}

defaultproperties
{
  FormationSize=90.000000
  Name="BattleSquadAI"
}