/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

class BattleGRI extends UTGameReplicationInfo config (BattleTeamArena);

// Client side data
var BattlePlayerController LocalBattlePlayerController;

// Data replicated from the server to the client
var int RemainingTimeRoundOffset;
var bool bRoundIsOver;
var globalconfig int CampingSetting;
var globalconfig int ChallengeModeSetting;
var globalconfig int RoundLengthSetting;
var globalconfig int HUDSetting;
var globalconfig int FovSetting;
var globalconfig int RemoveSetting;
var globalconfig int WeaponsSetting;
var globalconfig int AmmoSetting;
var globalconfig int ImpactHammerSetting;

var int LastRound_Kills;
var int LastRound_MaxKills;
var string LastRound_MaxKillsBy;
var int LastRound_Damage;
var int LastRound_MaxDamage;
var string LastRound_MaxDamageBy;
var int LastRound_Thaws;
var int LastRound_MaxThaws;
var string LastRound_MaxThawsBy;
var int LastRound_Headshots;
var int LastRound_MaxHeadshots;
var string LastRound_MaxHeadshotsBy;

replication
{
  if (Role == ROLE_Authority)
    RemainingTimeRoundOffset, bRoundIsOver, CampingSetting, ChallengeModeSetting, RoundLengthSetting, HUDSetting,
    FovSetting, RemoveSetting, WeaponsSetting, AmmoSetting, ImpactHammerSetting, LastRound_Kills, LastRound_MaxKills, 
    LastRound_MaxKillsBy, LastRound_Damage, LastRound_MaxDamage, LastRound_MaxDamageBy, LastRound_Thaws, 
    LastRound_MaxThaws, LastRound_MaxThawsBy, LastRound_Headshots, LastRound_MaxHeadshots, LastRound_MaxHeadshotsBy;
}

simulated function Timer() // Derived from UTGameReplicationInfo.uc
{
    local int RemainingRoundTime;
	local byte TimerMessageIndex;
	local PlayerController PC;

    Super (GameReplicationInfo).Timer(); // Super.Super

    if (BattleGRI (WorldInfo.GRI).CampingSetting == 0) BattleGRI (WorldInfo.GRI).CampingSetting = 15;
    if (BattleGRI (WorldInfo.GRI).RoundLengthSetting == 0) BattleGRI (WorldInfo.GRI).RoundLengthSetting = 120;
    if (BattleGRI (WorldInfo.GRI).FovSetting == 0) BattleGRI (WorldInfo.GRI).FovSetting = 120;
    if (BattleGRI (WorldInfo.GRI).WeaponsSetting == 0) BattleGRI (WorldInfo.GRI).WeaponsSetting = 8;
    if (BattleGRI (WorldInfo.GRI).AmmoSetting == 0) BattleGRI (WorldInfo.GRI).AmmoSetting = 100;

	if ( WorldInfo.NetMode == NM_Client )
	{
		if ( bWarmupRound && RemainingTime > 0 )
			RemainingTime--;
	}

    if (WorldInfo.NetMode != NM_DedicatedServer && MapVoteTimeRemaining > 0)
    {
    	MapVoteTimeRemaining--;
    }

    RemainingRoundTime = Min (300, Max (-1, RemainingTime - RemainingTimeRoundOffset));

	// check if we should broadcast a time countdown message, subset of UTGameReplicationInfo otherwise it would become annoying
	if (WorldInfo.NetMode != NM_DedicatedServer && !bRoundIsOver && (bMatchHasBegun || bWarmupRound) && !bStopCountDown && !bMatchIsOver && Winner == None)
	{
		switch (RemainingRoundTime)
		{
			case 0:
				if (RemainingTime!=0) TimerMessageIndex = 17; // No double overtime message
				break;
			case 30:
				TimerMessageIndex = 12;
				break;
			default:
				if (RemainingRoundTime <= 5 && RemainingRoundTime > 0)
				{
					TimerMessageIndex = RemainingRoundTime;
				}
				break;
		}
		if (TimerMessageIndex != 0)
		{
			foreach LocalPlayerControllers(class'PlayerController', PC)
			{
				PC.ReceiveLocalizedMessage(class'BattleTimerMessage', TimerMessageIndex);
			}
		}
	} 
}

defaultproperties
{
  Name="BattleGRI"
}