/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleTeamArena/Classes/BattleTeamArena.uci) 

class BattleWeapon_ShockRifle extends UTWeap_ShockRifle;

simulated function InstantFire()
{
  if (Instigator != None && Instigator.Controller != None 
      && Instigator.Controller.PlayerReplicationInfo != None
      && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
    BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_ShockPrimary);
  }
  Super.InstantFire();  
}

simulated function Projectile ProjectileFire()
{
  if (Instigator != None && Instigator.Controller != None 
      && Instigator.Controller.PlayerReplicationInfo != None
      && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
    BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_ShockBall);
  }
  return Super.ProjectileFire();
}

simulated function ImpactInfo CalcWeaponFire(vector StartTrace, vector EndTrace, optional out array<ImpactInfo> ImpactList)
{
  local ImpactInfo II;
  II = Super.CalcWeaponFire(StartTrace, EndTrace, ImpactList);
  if (bWasACombo) {
    if (Instigator != None && Instigator.Controller != None 
        && Instigator.Controller.PlayerReplicationInfo != None
        && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
      BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_ShockCombo);
    }
  }
  return II;
}

defaultproperties
{
}