/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

class BattleStartupMessage extends UTStartupMessage;

var string TheStage[21];

static simulated function ClientReceive(
	PlayerController P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{

	local UTPlayerController UTP;
	local UTHUD HUD;

	Super(UTLocalMessage).ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);

	UTP = UTPlayerController(P);
	if ( UTP == None )
		return;
	HUD = UTHUD(P.myHUD);
	if ( (HUD != None) && HUD.bIsSplitScreen && !HUD.bIsFirstPlayer )
	{
		return;
	}

	// don't play sound if quickstart=true, so no 'play' voiceover at start of tutorials
	if ( Switch == 5 )
	{
		if ( (P.WorldInfo != none) && ((UTGame(P.WorldInfo.Game) == None) || !UTGame(P.WorldInfo.Game).SkipPlaySound()) )
			UTP.PlayAnnouncement(Default.Class, 1);
	}
	else if ( (Switch > 1) && (Switch < 5) || Switch > 10)
		UTP.PlayBeepSound();
}

static function string GetString(
	optional int Switch,
	optional bool bPRI1HUD,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	local int i, PlayerCount;
	local GameReplicationInfo GRI;

	if ( (RelatedPRI_1 != None) && (RelatedPRI_1.WorldInfo.NetMode == NM_Standalone) )
	{
		  if ( (UTGame(RelatedPRI_1.WorldInfo.Game) != None) && UTGame(RelatedPRI_1.WorldInfo.Game).bQuickstart )
			  return "";
		if ( Switch < 2 )
			return Default.SinglePlayer;
		}
	else if ( Switch == 0 && RelatedPRI_1 != None )
	{
		GRI = RelatedPRI_1.WorldInfo.GRI;
		if (GRI == None)
			return Default.TheStage[0];
		for (i = 0; i < GRI.PRIArray.Length; i++)
		{
			if ( GRI.PRIArray[i] != None && !GRI.PRIArray[i].bOnlySpectator
			     && (!GRI.PRIArray[i].bIsSpectator || GRI.PRIArray[i].bWaitingPlayer) )
				PlayerCount++;
		}
		if (UTGameReplicationInfo(GRI).MinNetPlayers - PlayerCount > 0)
			return Default.TheStage[0]@"("$(UTGameReplicationInfo(GRI).MinNetPlayers - PlayerCount)$")";
	}
	else if ( switch == 1 )
	{
		if ( (RelatedPRI_1 == None) || !RelatedPRI_1.bWaitingPlayer )
			return Default.TheStage[0];
		else if ( RelatedPRI_1.bReadyToPlay )
			return Default.TheStage[1];
		else
			return Default.NotReady;
	}
	return Default.TheStage[Switch];
}

defaultproperties
{
  TheStage(0)="Waiting for other players."
  TheStage(1)="Waiting for ready signals. You are READY."
  TheStage(2)="The round is about to begin...3"
  TheStage(3)="The round is about to begin...2"
  TheStage(4)="The round is about to begin...1"
  TheStage(5)="The round has begun!"
  TheStage(6)="The round has begun!"
  TheStage(7)=""
  TheStage(8)=""
  TheStage(9)=""
  TheStage(10)=""
  TheStage(11)="The round is about to begin...1"
  TheStage(12)="The round is about to begin...2"
  TheStage(13)="The round is about to begin...3"
  TheStage(14)="The round is about to begin...4"
  TheStage(15)="The round is about to begin...5"
  TheStage(16)="The round is about to begin...6"
  TheStage(17)="The round is about to begin...7"
  TheStage(18)="The round is about to begin...8"
  TheStage(19)="The round is about to begin...9"
  TheStage(20)="The round is about to begin...10"
  Name="BattleStartupMessage"
}