/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleTeamArena/Classes/BattleTeamArena.uci) 

class BattleWeapon_ImpactHammer extends UTWeap_ImpactHammer;

simulated function Tick(float DeltaTime)
{
  if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 1) { // Standard
    SelfDamageScale = 0.3;
    MinForce = 40000;
    MaxForce = 100000;
    SelfForceScale=-1.2;
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 0) { // Reduced Self Damage
    SelfDamageScale = 0.05;
    MinForce = 40000;
    MaxForce = 100000;
    SelfForceScale=-1.2;
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 2) { // + Reduced Fall Damage
    SelfDamageScale = 0.05;
    MinForce = 40000;
    MaxForce = 100000;
    SelfForceScale = -1.2;
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 3) { // + Boost
    SelfDamageScale = 0.05;
    MinForce = 50000;
    MaxForce = 120000;
    SelfForceScale = -1.5;
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 4) { // + Ultra Boost
    SelfDamageScale = 0.02;
    MinForce = 80000;
    MaxForce = 200000;
    SelfForceScale = -2.4;
  }
}

simulated function String GetHumanReadableName()
{
  if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 1) { // Standard
    return "Impact Hammer";
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 0) { // Reduced Self Damage
    return "Impact Hammer RSD";
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 2) { // + Reduced Fall Damage
    return "Impact Hammer RSD+RFD";
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 3) { // + Boost
    return "Impact Hammer RSD+RFD+Boost";
  } else if (BattleGRI (WorldInfo.GRI).ImpactHammerSetting == 4) { // + Ultra Boost
    return "Impact Hammer RSD+RFD+Ultra Boost";
  }
}

simulated function ProcessInstantHit( byte FiringMode, ImpactInfo Impact )
{
  Super.ProcessInstantHit (FiringMode, Impact);
}

simulated function InstantFire()
{
  if (Instigator != None && Instigator.Controller != None 
      && Instigator.Controller.PlayerReplicationInfo != None
      && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
    BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_ImpactHammer);
  }
  Super.InstantFire();  
}

defaultproperties
{
   MinSelfDamage=2.67
   SelfDamageScale=0.1
}