/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleInteraction extends Interaction;

var BattlePRI BPRI;
var PlayerController PC;

function bool InputKey (int ControllerId, name Key, EInputEvent EventType, optional float AmountDepressed=1.f, optional bool bGamepad)
{
  local UIScene Scene;
  local GameUISceneClient GS;

  if (PC != None && BattlePRI (PC.PlayerReplicationInfo) != None) {
    if (Key == 'F12' && EventType == IE_Pressed) {
      GS = UTGameUISceneClient (class'UIRoot'.static.GetSceneClient());
      Scene = UIScene(DynamicLoadObject("BattleTeamArenaContent.BattleDynamicMenu", class'UIScene'));
	  if (Scene != None) {
        GS.OpenScene(Scene);
	  }  
    }
    if (Key == 'F3' && EventType == IE_Pressed) {
      BattlePRI (PC.PlayerReplicationInfo).bShowStats = !BattlePRI (PC.PlayerReplicationInfo).bShowStats;
      if (BattlePRI (PC.PlayerReplicationInfo).bShowStats) {
        BattlePRI (PC.PlayerReplicationInfo).ShowBPRI = BattlePRI (PC.PlayerReplicationInfo);
        BattlePlayerController (PC).RequestStatReplication (BattlePRI (PC.PlayerReplicationInfo).ShowBPRI); 
      }
    }
    if (Key == 'PageUp' && EventType == IE_Pressed) {
      BattlePRI (PC.PlayerReplicationInfo).ShowBPRI = BattlePlayerController(PC).NextInCycle (BattlePRI (PC.PlayerReplicationInfo).ShowBPRI, "viewstats", -1);
      BattlePlayerController (PC).RequestStatReplication (BattlePRI (PC.PlayerReplicationInfo).ShowBPRI); 
    }
    if (Key == 'PageDown' && EventType == IE_Pressed) {
      BattlePRI (PC.PlayerReplicationInfo).ShowBPRI = BattlePlayerController(PC).NextInCycle (BattlePRI (PC.PlayerReplicationInfo).ShowBPRI, "viewstats");
      BattlePlayerController (PC).RequestStatReplication (BattlePRI (PC.PlayerReplicationInfo).ShowBPRI); 
    }
  }
  return false;
}

defaultproperties
{ 
   __OnReceivedNativeInputKey__Delegate=Default__BattleInteraction.InputKey
   Name="Default__BattleInteraction"
   ObjectArchetype=Interaction'Engine.Default__Interaction'
}