/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

`include (BattleTeamArena/Classes/BattleTeamArena.uci) 

class BattleHUD extends UTTeamHUD;

var bool bDefaultsCreated;
var bool bExtentsCreated;
var TextureCoordinates PawnIconCoords;
var int RequestCounter;

function DrawPlayerStats (Vector2D POS, BattlePRI BPRI)
{
  local Vector2D TS; 
  local int i;
  local string LastLine;

  if (RequestCounter++ >= 5) {
    BattlePlayerController(PlayerOwner).RequestStatReplication (BPRI);
    RequestCounter = 0;
  }
  BPRI.Stats_Prepare ();
  TS = TextSize (37, `STATS_Types + 5);
  if (BPRI.Team.Teamindex==0) DrawNiceRect (POS, TS, "red"); else DrawNiceRect (POS, TS, "blue"); 
  DrawNiceText (POS, 0, 0, BPRI.PlayerName, "yellow");
  DrawNiceText (POS, 9, 0, "Killed with", "yellow");
  DrawNiceText (POS, 12, 1, "Shots", "yellow");
  DrawNiceText (POS, 17, 1, "Hits", "yellow"); 
  DrawNiceText (POS, 21, 1, "Dam.", "yellow");
  DrawNiceText (POS, 26, 0, "Killed by", "yellow");
  DrawNiceText (POS, 30, 1, "Hits", "yellow");
  DrawNiceText (POS, 34, 1, "Dam.", "yellow");
  for (i=0; i<`STATS_Types; i++) {
    if (BPRI.StatsPres_Present[i] > 0) {
      DrawNiceText (POS, 0, 2+i, BPRI.Stats_DamageIndex2Name (i), "white");
      if (i != `STATS_DMG_SniperHeadShot) {
        DrawNiceText (POS, 8, 2+i, FormatNumber(BPRI.StatsPres_KilledTo[i]), "white");
        DrawNiceText (POS, 12, 2+i, FormatNumber(BPRI.StatsPres_Shots[i]), "white");
        DrawNiceText (POS, 16, 2+i, FormatNumber(BPRI.StatsPres_HitsTo[i]), "white");
        DrawNiceText (POS, 20, 2+i, FormatNumber(BPRI.StatsPres_DamageTo[i],5), "white");
        DrawNiceText (POS, 25, 2+i, FormatNumber(BPRI.StatsPres_KilledBy[i]), "white");
        DrawNiceText (POS, 29, 2+i, FormatNumber(BPRI.StatsPres_HitsBy[i]), "white");
        DrawNiceText (POS, 33, 2+i, FormatNumber(BPRI.StatsPres_DamageBy[i],5), "white");
      } else {
        DrawNiceText (POS, 16, 2+i, FormatNumber(BPRI.StatsPres_HitsTo[i]), "white");
        DrawNiceText (POS, 29, 2+i, FormatNumber(BPRI.StatsPres_HitsBy[i]), "white");
      }
    } else {
      DrawNiceText (POS, 0, 2+i, BPRI.Stats_DamageIndex2Name (i), "grey");
    }
  }  
  DrawNiceText (POS, 0, 2+`STATS_Types, "Total", "yellow");
  DrawNiceText (POS, 8, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_KilledTo), "yellow");
  DrawNiceText (POS, 12, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_Shots), "yellow");
  DrawNiceText (POS, 16, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_HitsTo), "yellow");
  DrawNiceText (POS, 20, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_DamageTo,5), "yellow");
  DrawNiceText (POS, 25, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_KilledBy), "yellow");
  DrawNiceText (POS, 29, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_HitsBy), "yellow");
  DrawNiceText (POS, 33, 2+`STATS_Types, FormatNumber(BPRI.StatsPresTotal_DamageBy,5), "yellow");
  if (BPRI.Stats_Thawed > 0) {
    LastLine = LastLine@"Thawed:"@BPRI.Stats_Thawed@" ";
  }
  if (BPRI.Stats_ThawedOther > 0) {
    LastLine = LastLine@"Thawed others:"@BPRI.Stats_ThawedOther@" ";
  }
  if (BPRI.SpecialPlayerState == SPS_Frozen) {
    LastLine = LastLine@"FROZEN";
  }
  if (BPRI.SpecialPlayerState == SPS_VeryDead) {
    LastLine = LastLine@"DEAD";
  }
  DrawNiceText (POS, 0, 3+`STATS_Types, LastLine, "white");
  DrawNiceText (POS, 0, 4+`STATS_Types, "(F3: Team Stats   PageUp/PageDown: Cycle)", "grey");
}

function DrawRoundStatsTable (Vector2D POS)
{
  local Vector2D TS; 
  local BattleGRI BGRI;

  BGRI = BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI);
  if (BGRI.LastRound_Headshots > 0) {
    if (BGRI.LastRound_Thaws > 0) {
      TS = TextSize (24, 5);
    } else {
      TS = TextSize (24, 4);
    }
  } else {
    if (BGRI.LastRound_Thaws > 0) {
      TS = TextSize (24, 4);
    } else {
      TS = TextSize (24, 3);
    }
  }
  DrawNiceRect (POS, TS, "yellow");
  DrawNiceText (POS, 0, 0, "Round", "yellow");
  DrawNiceText (POS, 6, 0, "Total", "yellow");
  DrawNiceText (POS, 10, 0, " Max", "yellow");
  DrawNiceText (POS, 14, 0, "By", "yellow");

  DrawNiceText (POS, 0, 1, "Kills", "yellow");
  DrawNiceText (POS, 6, 1, FormatNumber (BGRI.LastRound_Kills), "white");
  DrawNiceText (POS, 10, 1, FormatNumber (BGRI.LastRound_MaxKills), "white");
  DrawNiceText (POS, 14, 1, BGRI.LastRound_MaxKillsBy, "white");

  DrawNiceText (POS, 0, 2, "Damage", "yellow");
  DrawNiceText (POS, 6, 2, FormatNumber (BGRI.LastRound_Damage), "white");
  DrawNiceText (POS, 10, 2, FormatNumber (BGRI.LastRound_MaxDamage), "white");
  DrawNiceText (POS, 14, 2, BGRI.LastRound_MaxDamageBy, "white");

  if (BGRI.LastRound_Headshots > 0) {
    DrawNiceText (POS, 0, 3, "Headshots", "yellow");
    DrawNiceText (POS, 6, 3, FormatNumber (BGRI.LastRound_Headshots), "white");
    DrawNiceText (POS, 10, 3, FormatNumber (BGRI.LastRound_MaxHeadshots), "white");
    DrawNiceText (POS, 14, 3, BGRI.LastRound_MaxHeadshotsBy, "white");
    if (BGRI.LastRound_Thaws > 0) { // To make table cleaner and work with both BTA and BFA
      DrawNiceText (POS, 0, 4, "Thaws", "yellow");
      DrawNiceText (POS, 6, 4, FormatNumber (BGRI.LastRound_Thaws), "white");
      DrawNiceText (POS, 10, 4, FormatNumber (BGRI.LastRound_MaxThaws), "white");
      DrawNiceText (POS, 14, 4, BGRI.LastRound_MaxThawsBy, "white");
    }
  } else {
    if (BGRI.LastRound_Thaws > 0) { // To make table cleaner and work with both BTA and BFA
      DrawNiceText (POS, 0, 3, "Thaws", "yellow");
      DrawNiceText (POS, 6, 3, FormatNumber (BGRI.LastRound_Thaws), "white");
      DrawNiceText (POS, 10, 3, FormatNumber (BGRI.LastRound_MaxThaws), "white");
      DrawNiceText (POS, 14, 3, BGRI.LastRound_MaxThawsBy, "white");
    }
  }
}

function DrawPlayerTable (Vector2D POS, int t, bool ShowHealth)
{
  local int i;
  local array<BattlePRI> A;
  local BattlePRI BPRI;
  local String CL;
  local Vector2D TS; 
  local bool SortDone;
  
  if (ShowHealth || BattleGRI (WorldInfo.GRI).bRoundIsOver) TS = TextSize (16, 9); else TS = TextSize (16, 8);

  if (t==0) DrawNiceRect (POS, TS, "red"); else DrawNiceRect (POS, TS, "blue"); 
  
  // Filter
  for (i = 0; i < WorldInfo.GRI.PRIArray.length; i++) {
    BPRI = BattlePRI(WorldInfo.GRI.PRIArray[i]);
    if (BPRI != None) {
      if (BPRI.Team.TeamIndex == t && !BPRI.bOnlySpectator && BPRI.PlayerName != "Admin" && !BPRI.bIgnoreMe) {
        A.AddItem (BPRI);
      }
    }
  }  
  
  // Sort
  SortDone = false;
  while (!SortDone && A.length > 1) {
    SortDone = true;
    for (i=0; i < A.length-1; i++) {     
      if (A[i].Score < A[i+1].Score) {
        SortDone = false;
        BPRI = A[i]; A[i] = A[i+1]; A[i+1] = BPRI;        
      }
    }
  }
  
  // Show
  DrawNiceText (POS, 0, 0, "Player", "yellow");
  if (ShowHealth || BattleGRI (WorldInfo.GRI).bRoundIsOver) DrawNiceText (POS, 12, 0, " Health", "yellow");
  for (i = 0; i < A.length && i < 7; i++) {
    BPRI = A[i];
    if (BPRI.SpecialPlayerState == SPS_Frozen) CL="grey"; else CL="white";
    if (BPRI.SpecialPlayerState == SPS_VeryDead) CL="black";
    DrawNiceText (POS, 0, i+1, BPRI.PlayerName, CL);
    if (BPRI.SpecialPlayerState == SPS_Frozen && (ShowHealth || BattleGRI (WorldInfo.GRI).bRoundIsOver)) 
      DrawNiceText (POS, 12, i+1, FormatNumber(BPRI.TotalHealth)$"%", CL);
    else if (BPRI.SpecialPlayerState == SPS_VeryDead) 
      DrawNiceText (POS, 12, i+1, " DEAD", CL);
    if (BPRI.SpecialPlayerState == SPS_Alive && (ShowHealth || BattleGRI (WorldInfo.GRI).bRoundIsOver)) 
      DrawNiceText (POS, 13, i+1, FormatNumber(BPRI.TotalHealth), CL);
  }  

  if (ShowHealth) DrawNiceText (POS, 0, 8, "(F3: Stats  F12: Settings)", "grey");
}

// Allow easy mixing of virtual and absolute screen coordinates
function Vector2D VA2D (Int vX, int vY, int aX, int aY) // Combines (V)irtual and (A)bsolute coordinate
{
  local vector2D V;

  V.X = vX * ResolutionScaleX + aX;
   V.Y = vY * ResolutionScale + aY;
  
  return V;
}

function DrawNiceRect (vector2D POS, vector2D SIZE, optional string Type="yellow")
{
  if (Type=="red") Canvas.DrawColor = MakeColor (255, 0, 0, 128);
  if (Type=="blue") Canvas.DrawColor = MakeColor (0, 0, 255, 128);
  if (Type=="yellow") Canvas.DrawColor = MakeColor (192, 192, 0, 192);
  Canvas.SetPos (POS.X+2, POS.Y);
  Canvas.DrawRect (SIZE.X-4, 2);
  Canvas.SetPos (POS.X, POS.Y+2);
  Canvas.DrawRect (2, SIZE.Y-4);
  Canvas.SetPos (POS.X+2, POS.Y+SIZE.Y-2);
  Canvas.DrawRect (SIZE.X-4, 2);
  Canvas.SetPos (POS.X+SIZE.X-2, POS.Y+2);
  Canvas.DrawRect (2, SIZE.Y-4);
  Canvas.SetPos (POS.X+1, POS.Y+1);
  Canvas.DrawRect (1, 1);
  Canvas.SetPos (POS.X+SIZE.X-2, POS.Y+1);
  Canvas.DrawRect (1, 1);
  Canvas.SetPos (POS.X+1, POS.Y+SIZE.Y-2);
  Canvas.DrawRect (1, 1);
  Canvas.SetPos (POS.X+SIZE.X-2, POS.Y+SIZE.Y-2);
  Canvas.DrawRect (1, 1); 
  if (Type=="red") Canvas.DrawColor = MakeColor (255, 0, 0, 32);
  if (Type=="blue") Canvas.DrawColor = MakeColor (0, 0, 255, 32);
  if (Type=="yellow") Canvas.DrawColor = MakeColor (192, 192, 0, 64);
  Canvas.SetPos (POS.X, POS.Y+1);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+1, POS.Y);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X, POS.Y+SIZE.Y-2);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+1, POS.Y+SIZE.Y-1);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+SIZE.X-1, POS.Y+1);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+SIZE.X-2, POS.Y);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+SIZE.X-1, POS.Y+SIZE.Y-2);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+SIZE.X-2, POS.Y+SIZE.Y-1);
  Canvas.DrawRect (1, 1);   
  Canvas.SetPos (POS.X+2, POS.Y+2);
  Canvas.DrawRect (SIZE.X-4, SIZE.Y-4);
}

function DrawNiceTextABS (vector2D POS, String Text, optional String Type="white") 
{
  if (Type=="white") Canvas.DrawColor = MakeColor (255, 255, 255, 255);
  if (Type=="grey") Canvas.DrawColor = MakeColor (160, 160, 160, 255);
  if (Type=="black") Canvas.DrawColor = MakeColor (80, 80, 80, 255);
  if (Type=="cyan") Canvas.DrawColor = MakeColor (0, 255, 255, 255);
  if (Type=="yellow") Canvas.DrawColor = MakeColor (255, 255, 0, 255);
  Canvas.SetPos (POS.X, POS.Y);
  Canvas.Font = class'Engine'.static.GetTinyFont();
  Canvas.DrawTextClipped (Text, false);
}

function vector2D TextSize (int Cols, int Lines)
{
  return VA2D (0, 0, 12 + Cols * 9, 8 + Lines * 14);
}

function DrawNiceText (vector2D POS, int Col, int Line, String Text, optional String Type="white") 
{
  DrawNiceTextABS (VA2D (0, 0, POS.X+Col*9 + 6, POS.Y+Line*14 + 6), Text, Type);
}

function String FormatNumber (int Number, optional int digits=4)
{
  local String Result;
  local int i;

  Result = ""$Number;
  i = digits - Len(Result);
  while (i-->0) Result = "  "$Result;
  return Result;
}

function DrawGameHud()
{
  local Vector2D POS;
  local BattlePRI BPRI;
  
  BPRI = BattlePRI (UTOwnerPRI);

  if (BattlePlayerController(PlayerOwner).HUDSetting == 0 || BattlePlayerController(PlayerOwner).HUDSetting == 1) {
    if (BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI).HUDSetting == 0 || BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI).HUDSetting == 1) { 
      if (BPRI.bShowStats) {
        if (BPRI.ShowBPRI != None) {
          POS = VA2D (10, 75, 0, 0);
          DrawPlayerStats (POS, BPRI.ShowBPRI);
        } else {
          BPRI.bShowStats = false;
        }
      } else {
        POS = VA2D (10, 45, 0, 0); 
        DrawPlayerTable (POS, BPRI.Team.TeamIndex, true); 
        POS = VA2D (10, 45, 0, 145);
        DrawPlayerTable (POS, 1 - BPRI.Team.TeamIndex, false);
      }
    }
  }
  if (BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI).bRoundIsOver) {
    POS = VA2D (10, 45, 0, 340);
    DrawRoundStatsTable (POS);
  } 
  Super.DrawGameHud(); // Make sure UT3 HUD stuf goes over my stuff
}

function DisplayClock()
{
	local string Time1;
	local string Time2;
	local vector2D POS;
    local int RoundTimeLeft;

	if (UTGRI != None)
	{
		POS = ResolveHudPosition(ClockPosition,183,44);
		Time1 = FormatTime(UTGRI.TimeLimit != 0 ? UTGRI.RemainingTime : UTGRI.ElapsedTime);
        RoundTimeLeft = Min (300, Max (0, UTGRI.RemainingTime - BattleGRI (WorldInfo.GRI).RemainingTimeRoundOffset));        
        if (RoundTimeLeft > 99) {
          Time2 = "" $ RoundTimeLeft;
        } else if (RoundTimeLeft > 9) {
          Time2 = "0" $ RoundTimeLeft;
        } else {
          Time2 = "00" $ RoundTimeLeft;
        }

		Canvas.SetPos(POS.X, POS.Y);
		Canvas.DrawColorizedTile(AltHudTexture, 240 * ResolutionScale,34 * ResolutionScale,489,395,183,44,TeamHudColor);

		Canvas.DrawColor = WhiteColor;
		DrawGlowText(Time1, POS.X + (43* ResolutionScale), POS.Y, 29 * ResolutionScale);
		DrawGlowText(Time2, POS.X + (158 * ResolutionScale), POS.Y, 29 * ResolutionScale);
	}
}

function DisplayMap() // Derived from Galtanors invasion with permission from Galtanor
{
	local GameReplicationInfo GRI;
    local BattlePRI BPRI;
	local float AdjustedViewportHeight;
	local float DotScale;
	local vector DrawVector;
	local linearcolor FinalColor;
	local float HalfHeight;
	local float HalfWidth;
	local float Height;
	local Pawn LocalPawnOwner;
	local UTPlayerController LocalPlayerOwner;
	local float LocationX;
	local float LocationY;
	local linearcolor MapColor;
	local UTMapInfo MapInfo;
	local rotator MapRot;
	local vector MapRotZ;
	local float MinRadarRange;
	local UTPickupFactory NavPoint;
	local vector NorthDir;
	local vector NorthLocation;
	local int NumPoints;
	local vector PlayerLocation;
	local vector MyLocation;
	local int PlayerYaw;
	local int PRIIndex;
	local float ScaleY;
	local vector ScreenLocation;
	local float Width;
    local float ZF;

    if (BattlePlayerController(PlayerOwner).HUDSetting == 1 || BattlePlayerController(PlayerOwner).HUDSetting == 3) return;
    if (BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI).HUDSetting == 1 || BattleGRI(BattlePlayerController(PlayerOwner).WorldInfo.GRI).HUDSetting == 3) return;

	GRI = WorldInfo.GRI;

	// find mapinfo
	MapInfo = UTMapInfo(WorldInfo.GetMapInfo());
	if (MapInfo == none)
	{
		MapInfo = new class'UTGame.UTMapInfo';
		WorldInfo.SetMapInfo(MapInfo);
	}

	// find player owner
	LocalPlayerOwner = UTPlayerController(PlayerOwner);
	if ((LocalPlayerOwner == None) || (LocalPlayerOwner.PlayerReplicationInfo == None))
	{
  	  return;
	}

	// verify defaults
	if (bDefaultsCreated == false)
	{
		if (MapInfo.DefaultMapSize == 0.0)
		{
			MapInfo.DefaultMapSize = 127.0;
		}
		if (MapInfo.MapMaterialReference == none)
		{
			MapInfo.MapMaterialReference = Material'UI_HUD.Materials.MapRing_Mat';
		}
		if ((MapInfo.MapRotX.X == 0.0) && (MapInfo.MapRotX.Y == 0.0) && (MapInfo.MapRotX.Z == 0.0))
		{
			MapInfo.MapRotX.X = 1.0;
		}
		if ((MapInfo.MapRotY.X == 0.0) && (MapInfo.MapRotY.Y == 0.0) && (MapInfo.MapRotY.Z == 0.0))
		{
			MapInfo.MapRotY.Y = 1.0;
		}
		if (MapInfo.MapTexture == none)
		{
//			MapInfo.MapTexture = Texture2D'BattleTeamArenaContent.Textures.GenericGrid';
			MapInfo.MapTexture = Texture2D'EngineResources.Black';
		}
		if ((MapInfo.PlayerIconCoords.U == 0.0) && (MapInfo.PlayerIconCoords.V == 0.0) && (MapInfo.PlayerIconCoords.UL == 0.0) && (MapInfo.PlayerIconCoords.VL == 0.0))
		{
			MapInfo.PlayerIconCoords.U = 657.0;
			MapInfo.PlayerIconCoords.V = 129.0;
			MapInfo.PlayerIconCoords.UL = 68.0;
			MapInfo.PlayerIconCoords.VL = 106.0;
		}
		if (MapInfo.RotatingMiniMapRange == 0.0)
		{
			MapInfo.RotatingMiniMapRange = 12000.0;
		}
		bDefaultsCreated = true;
	}

	// make the necessary calculations
	AdjustedViewportHeight = bIsSplitScreen ? Canvas.ClipY * 2 : Canvas.ClipY;
	ScaleY = AdjustedViewportHeight / 768;
	Height = MapDefaultSize * ScaleY;
	Width = MapDefaultSize * ScaleY;
	LocationX = Canvas.ClipX - (Canvas.ClipX * (1.0 - MapPosition.X)) - Width;
	LocationY = (AdjustedViewportHeight * MapPosition.Y);

	// create the material if needed
	if (MapInfo.MapMaterialInstance == none)
	{
		MapInfo.MapMaterialInstance = new class'MaterialInstanceConstant';
		MapInfo.MapMaterialInstance.SetParent(MapInfo.MapMaterialReference);
		MapInfo.MapMaterialInstance.SetTextureParameterValue('LevelMap', MapInfo.MapTexture);
	}

	// create color
	MapColor = MakeLinearColor(0.2f,0.f,0.f,1.0f);

	// Make sure we have tracked all of the nodes
	if (MapInfo.bMapUpToDate == false)
	{
		MapInfo.FindObjectives();
	}

	// verify map extents
	if (bExtentsCreated == false)
	{
		NumPoints = 0;
		MapInfo.MapCenter = vect(0,0,0);
		ForEach WorldInfo.AllNavigationPoints(class'UTPickupFactory', NavPoint)
		{
			MapInfo.MapCenter += NavPoint.Location;
			NumPoints++;
		}
		if (NumPoints > 0)
		{
			MapInfo.MapCenter = MapInfo.MapCenter / NumPoints;
		}
		ForEach WorldInfo.AllNavigationPoints(class'UTPickupFactory', NavPoint)
		{
			MapInfo.MapExtent = FMax(MapInfo.MapExtent, 2.75 * vsize2D(MapInfo.MapCenter - NavPoint.Location));
		}
		bExtentsCreated = true;
	}
	MapInfo.bMapUpToDate = true;

	// make color
	MapInfo.ColorPercent = 0.5f + Cos((WorldInfo.RealTimeSeconds * 4.0) * 3.14159 * 0.5f) * 0.5f;

	// get the current view target... this is to handle if you are flying a redeemer, for instance
	LocalPawnOwner = Pawn(LocalPlayerOwner.ViewTarget);

	// Refresh all Positional Data
	MapInfo.CenterPos.X = LocationX + (Width * 0.5);
	MapInfo.CenterPos.Y = LocationY + (Height * 0.5);

	// MapScale is the different between the original map and this map
	MapInfo.MapScale = 1.5 * Height / MapInfo.DefaultMapSize;
	MapInfo.RadarWidth = Height * MapInfo.UseableRadius * 2;

	// determine player position on minimap
	ScreenLocation = (LocalPawnOwner != None) ? LocalPawnOwner.Location : LocalPlayerOwner.Location;
	PlayerYaw = (UTRemoteRedeemer(LocalPawnOwner) == None) ? LocalPlayerOwner.Rotation.Yaw & 65535 : LocalPawnOwner.Rotation.Yaw & 65535;

	// calculate radar range and rotation
	MapInfo.RadarRange = MapInfo.MapExtent;
	MapRot.Yaw = (MapInfo.MapYaw * 182.04444444);

	// check split screen
	bIsSplitScreen = class'Engine'.static.IsSplitScreen();
	LocalPlayerOwner.bRotateMinimap = LocalPlayerOwner.bRotateMinimap && !bIsSplitScreen;

	// map center and rotation based on player position
	MapInfo.ActualMapCenter = ScreenLocation;
	MapRot.Yaw = PlayerYaw + 16384;
	MinRadarRange = MapInfo.RotatingMiniMapRange;

	// draw map image
    MapInfo.DrawMapImage(Canvas, LocationX, LocationY, Width, Height, PlayerYaw - (MapInfo.MapYaw * 182.0444), 1.0 );

	// update radar
	MapInfo.RadarRange = MinRadarRange;

	// Draw the Ring
	HalfWidth = Width * 0.5;
    HalfHeight = Height * 0.5;
	// UL
	Canvas.SetPos(LocationX, LocationY);
	Canvas.DrawColorizedTile(class'UTHUD'.default.IconHudTexture, HalfWidth, HalfHeight, 215, 579, 347, 347, MapColor);
	// UR
	Canvas.SetPos(LocationX + HalfWidth, LocationY);
	Canvas.DrawColorizedTile(class'UTHUD'.default.IconHudTexture, HalfWidth, HalfHeight, 562, 579, -347, 347, MapColor);
	// LL
	Canvas.SetPos(LocationX, LocationY + HalfHeight);
	Canvas.DrawColorizedTile(class'UTHUD'.default.IconHudTexture, HalfWidth, HalfHeight, 215, 926, 347, -347, MapColor);
	// LR
	Canvas.SetPos(LocationX + HalfWidth, LocationY + HalfHeight);
	Canvas.DrawColorizedTile(class'UTHUD'.default.IconHudTexture, HalfWidth, HalfHeight, 562, 926, -347, -347, MapColor);

	// adjust scale
	DotScale = HalfWidth / 347;

	// North indicator
	NorthDir = MapInfo.MapRotY;
	NorthDir.X *= -1.0;
	NorthLocation = MapInfo.CenterPos - 0.92 * HalfHeight * NorthDir;
	NorthLocation.X -=  29.5 * DotScale;
	NorthLocation.Y -= 33.5 * DotScale;
	Canvas.DrawColor = class'UTHUD'.default.RedColor;
	Canvas.DrawColor.R = 128;
	Canvas.SetPos(NorthLocation.X, NorthLocation.Y);
	NorthDir = MapInfo.MapRotX;
	NorthDir.Y *= -1.0;
	Canvas.DrawRotatedTile(class'UTHUD'.default.IconHudTexture, rotator(NorthDir), 59 * DotScale, 67 * DotScale, 725, 175, 59, 67);

	// update rotation
	if (MapInfo.CurrentMapRotYaw != MapRot.Yaw)
	{
		GetAxes(MapRot, MapInfo.MapRotX, MapInfo.MapRotY, MapRotZ);
		MapInfo.CurrentMapRotYaw = MapRot.Yaw;
	}

	// set the position of the canvas
	Canvas.SetPos(MapInfo.CenterPos.X - 0.5 * MapInfo.RadarWidth, MapInfo.CenterPos.Y - 0.5 * MapInfo.RadarWidth);

	// draw your player
	if ((LocalPawnOwner != None) && (LocalPlayerOwner.Pawn == LocalPawnOwner))
	{
		PlayerLocation = MapInfo.UpdateHUDLocation(ScreenLocation);
		Canvas.DrawColor = class'UTTeamInfo'.Default.BaseTeamColor[2];
		MapInfo.DrawRotatedTile(Canvas, class'UTHUD'.default.IconHudTexture, PlayerLocation, PlayerYaw + 16384, 2.0, MapInfo.PlayerIconCoords, MakeLinearColor(0.4,1.0,0.4,0.5));
	}

	// reset color
	FinalColor = class'UTHUD'.default.WhiteLinearColor;

      // Try to use the local Pawn (only available if in sight) otherwise use the slower replicated location
      MyLocation = Vect (0,0,0);
      if (LocalPlayerOwner != None && BattlePRI (LocalPlayerOwner.PlayerReplicationInfo) != None) {
        if (BattlePRI (LocalPlayerOwner.PlayerReplicationInfo).MyPawn != None) {
          MyLocation = BattlePRI (LocalPlayerOwner.PlayerReplicationInfo).MyPawn.Location; // Local pawn
        } else {
          MyLocation = BattlePRI (LocalPlayerOwner.PlayerReplicationInfo).PawnLocation; // Replicated location
        }
      }
  	  if (MyLocation != vect (0,0,0)) for (PRIIndex = 0; PRIIndex < GRI.PRIArray.length; PRIIndex++) {
		  BPRI = BattlePRI (GRI.PRIArray[PRIIndex]);
		  if (BPRI != none && BPRI != LocalPlayerOwner.PlayerReplicationInfo && BPRI.Team.TeamIndex == LocalPlayerOwner.PlayerReplicationInfo.Team.TeamIndex) {
		    if (BPRI.MyPawn != None) {
		      PlayerLocation = BPRI.MyPawn.Location; // Local pawn
		    } else {
		      PlayerLocation = BPRI.PawnLocation; // Replicated location
		    }
            if (PlayerLocation != vect(0,0,0)) {
              ZF = (75.0 + Max (-25, Min (25, (PlayerLocation.Z - MyLocation.Z)/10)))/100.0;
              if (BPRI.SpecialPlayerState == SPS_Frozen) {
                  FinalColor = MakeLinearColor (0, ZF, 1, 0.8);
                  DrawVector = MapInfo.UpdateHUDLocation(PlayerLocation);
                  InvDrawRotatedTile(Texture2D'BattleTeamArenaContent.Textures.HudTexture', DrawVector, MapInfo.MapScale, 0.8 * ZF, PawnIconCoords, FinalColor);
              } else if (BPRI.SpecialPlayerState == SPS_Alive) {
                  FinalColor = MakeLinearColor (1, ZF, 0, 0.8);
                  DrawVector = MapInfo.UpdateHUDLocation(PlayerLocation);
                  InvDrawRotatedTile(Texture2D'BattleTeamArenaContent.Textures.HudTexture', DrawVector, MapInfo.MapScale, 0.8 * ZF, PawnIconCoords, FinalColor);
              }
            }
		  }
	  }

	// reset color
	Canvas.SetDrawColor(255,255,255,255);
}

function InvDrawRotatedTile(Texture2D DrawTexture, vector MapLocation, float MapScale, float IconScale, TextureCoordinates TexCoords, LinearColor DrawColor)
{
	local rotator NewRotation;
	local float Width;
	local float Height;

	Width = TexCoords.UL * (MapScale / 4) * IconScale;
	Height = TexCoords.VL * (MapScale / 4) * IconScale;

	Canvas.SetPos(MapLocation.X - (0.5 * Width), MapLocation.Y - (0.5 * Height) );
	Canvas.DrawColor = MakeColor(DrawColor.R * 255, DrawColor.G * 255, DrawColor.B * 255, DrawColor.A * 255);
	Canvas.DrawRotatedTile(DrawTexture, NewRotation, Width, Height, TexCoords.U, TexCoords.V, TexCoords.UL, TexCoords.VL);
}

defaultproperties
{
  ScoreboardSceneTemplate=UTUIScene_TeamScoreboard'BattleTeamArenaContent.sbBattleTeamArena'
  PawnIconCoords=(U=64.000000,V=0.000000,UL=32.000000,VL=32.000000)
  FireToRespawnMessage="You are dead. Press [FIRE] to spectate."
  bHasMap=True
  bShowMap=True
  Name="Default__BattleHUD"
}