/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

class BattleGameRules extends GameRules;

function NetDamage (int OriginalDamage, out int Damage, pawn Injured, Controller InstigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local BattlePRI BPRI_InstigatedBy;
  local BattlePRI BPRI_Injured;

  if (!WorldInfo.Game.IsInState('MatchInProgress')) {
    Damage = 0;
    return;
  }

  if (BattlePawn (Injured) != None && DamageType == class'UTDmgType_Slime' || DamageType == class'UTDmgType_Lava') {
    BattlePawn (Injured).LastHurtBySlimeOrLava = WorldInfo.GRI.ElapsedTime;
  }

  Super.NetDamage (OriginalDamage, Damage, Injured, InstigatedBy, HitLocation, Momentum, DamageType);
  if (Injured.Owner != None && Controller(Injured.Owner) != None && Controller(Injured.Owner).PlayerReplicationInfo != None
      && BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo) != None) {
    if (BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo).SpecialPlayerState == SPS_Frozen) {
      if (DamageType == class'UTDmgType_Slime' || DamageType == class'UTDmgType_Lava') {
        // Rapid unfreeze player when (s)he is damaged by slime or lava
        Injured.Health += 33;
        if (Injured.Health >= 100) { 
          BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo).Stats_Thawed++;
          BattlePawn(Injured).Unfreeze (BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo));
        }
        return;
      }
    }
  }
  if (Injured.Owner != None && Controller(Injured.Owner) != None && Controller(Injured.Owner).PlayerReplicationInfo != None
      && BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo) != None) {
    if (BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo).SpecialPlayerState != SPS_Alive) {
      Damage = 0; // Cannot hurt someone who is not alive (e.g. frozen)
    }
  }
  if (Damage > 0 && InstigatedBy != None && Injured != None && BattlePlayerController(InstigatedBy) != None){
    if (InstigatedBy.GetTeamNum() != Injured.GetTeamNum()) {
      BattlePlayerController(InstigatedBy).HitSound(Damage);
    }    
  }
  if (Damage > 0 && InstigatedBy != None && Injured != None && InstigatedBy != None){
    BPRI_Injured = BattlePRI (Controller(Injured.Owner).PlayerReplicationInfo);
    BPRI_InstigatedBy = BattlePRI (InstigatedBy.PlayerReplicationInfo);
    if (BPRI_Injured != BPRI_InstigatedBy) { // No points for self damage
      InstigatedBy.PlayerReplicationInfo.Score += Damage / 100.0; // 1 point for each 100 damage
    }
    if (InstigatedBy.GetTeamNum() != Injured.GetTeamNum() || BPRI_Injured == BPRI_InstigatedBy) {
      BPRI_InstigatedBy.Stats_RecordHit (BPRI_Injured, DamageType, Damage);
      if (BattlePawn (Injured).CampCounter > 5) BattlePawn (Injured).CampCounter = 5; // Getting hurt does not count as camping
    }
  }
}

defaultproperties
{
  Name="BattleGameRules"
}