/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    This file also contains code that is derived from code which is
    Copyright 1998-2007 Epic Games, Inc. All Rights Reserved. That part 
    of the code is covered by the Epic license and not by the GPL.
*/

class BattleBotController extends UTBot;

function float GetDesiredOffset()
{
  local float optimaldist;
  local BattlePRI BPRI;

	if ( Pawn==None || Squad==None || (Squad.SquadLeader == None) ||  Squad.SquadLeader.Pawn==None || (MoveTarget != Squad.SquadLeader.Pawn) )
		return 0;

    optimaldist = 1100.0;
    if (BattleFreezetagArena (WorldInfo.Game) != None) {
      if ((Pawn.Health - Squad.SquadLeader.Pawn.Health) > 10) optimaldist = 90; // Heal or get healed
      if (Squad.SquadLeader != None && Squad.SquadLeader.PlayerReplicationInfo != None) {
        BPRI = BattlePRI (Squad.SquadLeader.PlayerReplicationInfo);
        if (BPRI != None) {
          if (BPRI.SpecialPlayerState == SPS_Frozen) optimaldist = 90; // Unfreeze
        }
      } 
    }

	return optimaldist*0.5;
}

event Tick (float DeltaTime)
{
  if (Role == ROLE_Authority) {
    if (PlayerReplicationInfo != None && BattlePRI (PlayerReplicationInfo).SpecialPlayerState == SPS_Frozen) {
      if (!IsInState('Frozen')) {
        if (Pawn != None) Pawn.Velocity = Vect (0, 0, 0);
        Reset();
        GotoState('Frozen');        
        if (Pawn != None) Pawn.Velocity = Vect (0, 0, 0);
      }
  } else if (BattlePRI (PlayerReplicationInfo).SpecialPlayerState != SPS_Frozen) {
      if (IsInState('Frozen')) {
        GotoState('Roaming');        
      }
    }
  }
  Super.Tick (DeltaTime);
  if (Role == ROLE_Authority) {
    if (Squad != None && Enemy != None && Enemy.PlayerReplicationInfo != None && BattlePRI (Enemy.PlayerReplicationInfo).SpecialPlayerState == SPS_Frozen) {
      Squad.RemoveEnemy (Enemy);
      Squad.FindNewEnemyFor (Self, false);
    }
  }
}

state Reboot
{
ignores SeePlayer, EnemyNotVisible, HearNoise, ReceiveWarning, NotifyLanded, NotifyPhysicsVolumeChange,
		NotifyHeadVolumeChange, NotifyLanded, NotifyHitWall, NotifyBump, ExecuteWhatToDoNext;

	event DelayedWarning() {}
	function DoRangedAttackOn(Actor A) {}
	function WhatToDoNext() {}
	function Celebrate() {}
	function bool SetRouteToGoal(Actor A) {	return true; }
	function SetAttractionState() {}
	function EnemyChanged(bool bNewEnemyVisible) {}
	function WanderOrCamp() {}
	function Timer() {}

	function BeginState(Name PreviousStateName)
	{
		if ((DefensePoint != None) && (UTHoldSpot(DefensePoint) == None)) FreePoint();
		if (NavigationPoint(MoveTarget) != None) {
          NavigationPoint(MoveTarget).FearCost = 2 * NavigationPoint(MoveTarget).FearCost + 600;
		  WorldInfo.Game.bDoFearCostFallOff = true;
		}
		PendingMover = None;
		Enemy = None;
		StopFiring();
		bFrustrated = false;
		BlockedPath = None;
		bInitLifeMessage = false;
		bPlannedJump = false;
		bInDodgeMove = false;
		bReachedGatherPoint = false;
		bFinalStretch = false;
		bWasNearObjective = false;
		bPreparingMove = false;
		bPursuingFlag = false;
		bHasSuperWeapon = false;
		bHasTranslocator = false;
		ImpactJumpZ = 0.f;
		RouteGoal = None;
		NoVehicleGoal = None;
		SquadRouteGoal = None;
		bUsingSquadRoute = true;
		bUsePreviousSquadRoute = false;
		MoveTarget = None;
		ImpactVelocity = vect(0,0,0);
		LastSeenTime = -1000;
		bEnemyInfoValid = false;
	}

Begin:
	if ( WorldInfo.Game.bGameEnded )
		GotoState('RoundEnded');
	Sleep(0.1);
TryAgain:
	if (UTGame(WorldInfo.Game) == None) {
      destroy();
	} else {
      Sleep(0.1);
	  LastRespawnTime = WorldInfo.TimeSeconds;
	  WorldInfo.Game.ReStartPlayer(self);
	  Goto('TryAgain');
	}

MPStart:
	Sleep(0.1);
	WorldInfo.Game.ReStartPlayer(self);
	Goto('TryAgain');
}


defaultproperties
{
  Name="BattleBotController"
}