/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleTeamArena/Classes/BattleTeamArena.uci) 

class BattleWeapon_LinkGun extends UTWeap_LinkGun;

simulated function Projectile ProjectileFire()
{
  if (Instigator != None && Instigator.Controller != None 
      && Instigator.Controller.PlayerReplicationInfo != None
      && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
    BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_LinkPlasma);
  }
  return Super.ProjectileFire();
}

function ConsumeBeamAmmo (float Amount)
{
  local int i;

  PartialAmmo += Amount;
  if (PartialAmmo >= 1.0) {
    if (Instigator != None && Instigator.Controller != None 
        && Instigator.Controller.PlayerReplicationInfo != None
        && BattlePRI (Instigator.Controller.PlayerReplicationInfo) != None) {
      for (i=0; i<int(PartialAmmo); i++) {
        BattlePRI (Instigator.Controller.PlayerReplicationInfo).Stats_RecordShot (`STATS_DMG_LinkBeam);
      }
    }
    AddAmmo(-int(PartialAmmo));
    PartialAmmo -= int(PartialAmmo);
  }
}


defaultproperties
{
}