/* 
    BattleMOD Copyright (C) 2007 Nico de Vries.

    This file is part of BattleMOD.

    BattleMOD is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleMOD extends UTMutator config(BattleMOD);

var config string CfgCheckConfig;
var config float CfgGameSpeedMultiplier;            // Total gamespeed (same as Speed Freak mutator).
var config float CfgWeaponSpeedMultiplier;          // Fire rate of weapons.
var config float CfgWalkingSpeedMultiplier;         // Walking speed.
var config float CfgHealthMultiplier;               // Extra starting health.
var config float CfgJumpMultiplier;                 // Extra high jumping.
var config bool CfgbMaxAmmo;                        // Weapons get max ammo.
// var config bool CfgbNewScoreboard;               // Use the new scoreboard (with PPH etc.).
var config bool CfgbAllWeapons;                     // Players spawn with all weapons.


function InitMutator(string Options, out string ErrorMessage)
{
//  LogInternal("BattleMOD:################ "@self$".InitMutator(...)");

  // (Re)create default INI file BattleMOD.INI in the Config directory.
  if (CfgCheckConfig!="DO NOT REMOVE THIS!") { 
    CfgCheckConfig = "DO NOT REMOVE THIS!";
    CfgbMaxAmmo = True;
    CfgbAllWeapons = True;
//    CfgbNewScoreboard = False; 
  }
  // Try to make sure values are valid. E.g. when a new version of BattleMOD has been installed.
  if (CfgGameSpeedMultiplier < 0.01) CfgGameSpeedMultiplier = 1.0;
  if (CfgWeaponSpeedMultiplier < 0.01) CfgWeaponSpeedMultiplier = 1.5;
  if (CfgWalkingSpeedMultiplier < 0.01) CfgWalkingSpeedMultiplier = 1.5;
  if (CfgJumpMultiplier < 0.01) CfgJumpMultiplier = 1.5;
  if (CfgHealthMultiplier < 0.01) CfgHealthMultiplier = 1.5;
  SaveConfig();

  WorldInfo.Game.SetGameSpeed(CfgGameSpeedMultiplier);

  if (CfgbAllWeapons) {
    UTGame(WorldInfo.Game).DefaultInventory.Length = 9;
    UTGame(WorldInfo.Game).DefaultInventory[0] = Class'UTGame.UTWeap_Enforcer';
    UTGame(WorldInfo.Game).DefaultInventory[1] = Class'UTGame.UTWeap_ImpactHammer';
    UTGame(WorldInfo.Game).DefaultInventory[2] = Class'UTGame.UTWeap_RocketLauncher';
    UTGame(WorldInfo.Game).DefaultInventory[3] = Class'UTGameContent.UTWeap_Avril_Content';
    UTGame(WorldInfo.Game).DefaultInventory[4] = Class'UTGameContent.UTWeap_BioRifle_Content';
    UTGame(WorldInfo.Game).DefaultInventory[5] = Class'UTGame.UTWeap_FlakCannon';
    UTGame(WorldInfo.Game).DefaultInventory[6] = Class'UTGame.UTWeap_LinkGun';
    UTGame(WorldInfo.Game).DefaultInventory[7] = Class'UTGame.UTWeap_ShockRifle';
    UTGame(WorldInfo.Game).DefaultInventory[8] = Class'UTGame.UTWeap_SniperRifle';
    UTGame(WorldInfo.Game).DefaultInventory[9] = Class'UTGame.UTWeap_Stinger';
  }

  Super.InitMutator(Options, ErrorMessage);
}

event Tick(float DeltaTime)
{
//  LogInternal("BattleMOD:################ "@self$".Tick("@DeltaTime@") Role:"@Role@" RemoteRole:"@RemoteRole@" WorldInfo.NetMode:"@WorldInfo.NetMode);
//  Standalone: Role: ROLE_Authority  RemoteRole: ROLE_None  WorldInfo.NetMode: NM_ListenServer
//  Client+Server/Server: Role: ROLE_Authority  RemoteRole: ROLE_None  WorldInfo.NetMode: NM_DedicatedServer
}

simulated function ModifyPlayer(Pawn Other)
{
  local UTPawn P;
//  local PlayerController PC;
//  local UTPlayerController UTPC;

//  LogInternal("BattleMOD:################ "@self$".ModifyPlayer("$Other$")");

/* Disabled until Epic patches bug (http://utforums.epicgames.com/showthread.php?t=588343)
  if (Other!=None) {
    PC = PlayerController (Other.Owner);
    UTPC = UTPlayerController (PC);
    if (CfgbNewScoreboard && PC != None) {
      if (InStr(WorldInfo.GetGameClass().name, "Ons")!=-1) {
        PC.ClientSetHUD (Class'BattleOnslaughtHUD', Worldinfo.Game.Scoreboardtype);         
//        PC.myHUD = Spawn(Class'UTOnslaughtHUD', PC);
//        PC.myHUD.ScoreBoard = Spawn (Worldinfo.Game.Scoreboardtype, PC);
//        PC.myHUD.ScoreBoard.HudOwner = PC.myHUD;
//        PC.MyHUD.SpawnScoreBoard (Worldinfo.Game.Scoreboardtype);
      } else if (InStr(WorldInfo.GetGameClass().name, "CTF")!=-1) {
        PC.ClientSetHUD (Class'BattleCTFHUD', Worldinfo.Game.Scoreboardtype);
      } else if (InStr(WorldInfo.GetGameClass().name, "Duel")!=-1) {
        PC.ClientSetHUD (Class'BattleDuelHUD', Worldinfo.Game.Scoreboardtype);
      } else if (InStr(WorldInfo.GetGameClass().name, "Team")!=-1) {
        PC.ClientSetHUD (Class'BattleTeamHUD', Worldinfo.Game.Scoreboardtype);
      } else if (InStr(WorldInfo.GetGameClass().name, "Death")!=-1) {
        PC.ClientSetHUD (Class'BattleHUD', Worldinfo.Game.Scoreboardtype);
      } // Use the default HUD for unknown gametypes.
      if (UTPC!=None) UTPC.LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    }
  }
*/

  P = UTPawn(Other);
  if (P != None) {
    P.FireRateMultiplier = P.default.FireRateMultiplier / CfgWeaponSpeedMultiplier;
    P.GroundSpeed = P.default.GroundSpeed * CfgWalkingSpeedMultiplier;
    P.WaterSpeed = P.default.WaterSpeed * CfgWalkingSpeedMultiplier;
    P.JumpZ = P.default.JumpZ * CfgJumpMultiplier;
    P.Health = P.default.Health * CfgHealthMultiplier; 
  }

  Super.ModifyPlayer(Other);

  if (Other!=None) Other.CreateInventory(class'BattleMOD.BattleClient');
}

simulated function bool CheckReplacement(Actor Other)
{
  local UTWeapon W;

//  LogInternal("BattleMOD:################ "@self$".CheckReplacement("$Other$")");

  if (Other != None) {
    W = UTWeapon(Other);
    if (W != None) {
      if (CfgbMaxAmmo && !W.bSuperWeapon) {
        W.Loaded(true);
      }
    }
  }

  return true;
}

defaultproperties
{
  Name="BattleMOD"
}