/* 
    BattleMOD Copyright (C) 2007 Nico de Vries.

    This file is part of BattleMOD.

    BattleMOD is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleClient extends Inventory config (BattleMOD);

var config string CfgCheckConfig;
var config float CfgWeaponSwitchSpeedMultiplier; // Weapon swiching speed.
var config float CfgHoverVehicleSpeedMultiplier; // Hoverboard speed.
var config bool CfgbAllowDodgeJumping;           // Weapon swiching speed.
var config int CfgHealthMaxRegen;                // Health per second.
var config int CfgHealthRegenPerSecond;          // Max health after full regeneration.
var config int CfgAmmoResupplyPerSecond;         // % ammo per second.

replication
{
  if (Role == ROLE_Authority)
    CfgWeaponSwitchSpeedMultiplier, CfgbAllowDodgeJumping, CfgHoverVehicleSpeedMultiplier;
}

simulated function PostBeginPlay()
{
  super.PostBeginPlay();
  if (CfgWeaponSwitchSpeedMultiplier < 0.01) CfgWeaponSwitchSpeedMultiplier = 1.5;
  if (CfgHealthMaxRegen < 10) CfgHealthMaxRegen = 150;
  if (CfgHoverVehicleSpeedMultiplier < 0.01) CfgHoverVehicleSpeedMultiplier = 1.5;
  if (CfgCheckConfig!="DO NOT REMOVE THIS!") { 
    CfgCheckConfig = "DO NOT REMOVE THIS!";
    CfgHealthRegenPerSecond = 5;
    CfgAmmoResupplyPerSecond = 1;
    CfgbAllowDodgeJumping = True;
  }
  SaveConfig();
//  if (Role == ROLE_Authority) {
    SetTimer (1.0, True, 'ServerTimer');
//  }
//  if (WorldInfo.NetMode == NM_ListenServer || WorldInfo.NetMode == NM_Client) {
    SetTimer (0.25, True, 'ClientTimer'); 
//  }
}

simulated function DoChangeWeaponSwitchSpeed (UTWeapon W)
{
  if (W != None) {
    W.EquipTime = W.default.EquipTime / CfgWeaponSwitchSpeedMultiplier;
    W.MinReloadPct[0] = W.default.MinReloadPct[0] / CfgWeaponSwitchSpeedMultiplier;
    W.MinReloadPct[1] = W.default.MinReloadPct[1] / CfgWeaponSwitchSpeedMultiplier;
    W.PutDownTime = W.default.PutDownTime / CfgWeaponSwitchSpeedMultiplier;
    W.SwitchAbortTime = W.default.SwitchAbortTime / CfgWeaponSwitchSpeedMultiplier;
  }
}

simulated function ChangeWeaponSwitchSpeed (Actor Other)
{
  if (Pawn(Other) != None) {
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).Weapon));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_Enforcer')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_ImpactHammer')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_RocketLauncher')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_FlakCannon')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_LinkGun')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_ShockRifle')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_SniperRifle')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGame.UTWeap_Stinger')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGameContent.UTWeap_Avril_Content')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGameContent.UTWeap_BioRifle_Content')));
    DoChangeWeaponSwitchSpeed (UTWeapon(Pawn(Other).FindInventoryType (Class'UTGameContent.UTWeap_Redeemer_Content')));
  }
}

simulated event Tick(float DeltaTime)
{
//   LogInternal("BattleMOD:################ "@self$".Tick("@DeltaTime@") WSP:"@CfgWeaponSwitchSpeedMultiplier@" Role:"@Role@" RemoteRole:"@RemoteRole@" WorldInfo.NetMode:"@WorldInfo.NetMode);
//   Standalone: Role: ROLE_Authority RemoteRole: ROLE_SimulatedProxy  WorldInfo.NetMode: NM_ListenServer
//   Client+Server/Client: Role: ROLE_SimulatedProxy  RemoteRole: ROLE_Authority  WorldInfo.NetMode: NM_Client
//   Client+Server/Server: Role: ROLE_Authority  RemoteRole: ROLE_SimulatedProxy  WorldInfo.NetMode: NM_DedicatedServer
  if (CfgbAllowDodgeJumping && UTPawn(Owner) != None && UTPawn(Owner).bDodging) {
    UTPawn(Owner).bReadyToDoubleJump = True;
    UTPawn(Owner).bDodging = False;    
  }
}

simulated function ClientTimer ()
{
  local UTHoverVehicle HV;

//  LogInternal("BattleMOD:################ "@self$".ClientTimer() #1");
  if (Pawn(Owner) != None) {
//    LogInternal("BattleMOD:################ "@self$".ClientTimer() #2");
    HV = UTHoverVehicle(Pawn(Owner).DrivenVehicle);
    if (HV != None) {
//      LogInternal("BattleMOD:################ "@self$".ClientTimer() #3 "@HV.MaxSpeed);
      HV.MaxSpeed = HV.default.MaxSpeed * CfgHoverVehicleSpeedMultiplier;
      HV.GroundSpeed = HV.default.GroundSpeed * CfgHoverVehicleSpeedMultiplier;
      if (UTVehicleSimHoverboard(HV.SimObj) != None) {
//        LogInternal("BattleMOD:################ "@self$".ClientTimer() #4 "@UTVehicleSimHoverboard(HV.SimObj).MaxThrustForce);
        UTVehicleSimHoverboard(HV.SimObj).MaxThrustForce = UTVehicleSimHoverboard(HV.SimObj).default.MaxThrustForce * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).MaxUphillHelpThrust = UTVehicleSimHoverboard(HV.SimObj).default.MaxUphillHelpThrust * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).MaxReverseForce = UTVehicleSimHoverboard(HV.SimObj).default.MaxReverseForce * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).MaxReverseVelocity = UTVehicleSimHoverboard(HV.SimObj).default.MaxReverseVelocity * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).MaxStrafeForce = UTVehicleSimHoverboard(HV.SimObj).default.MaxStrafeForce * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).TurnTorqueFactor = UTVehicleSimHoverboard(HV.SimObj).default.TurnTorqueFactor * CfgHoverVehicleSpeedMultiplier;
        UTVehicleSimHoverboard(HV.SimObj).MaxTurnTorque = UTVehicleSimHoverboard(HV.SimObj).default.MaxTurnTorque * CfgHoverVehicleSpeedMultiplier;
//        LogInternal("BattleMOD:################ "@self$".ClientTimer() #5 "@UTVehicleSimHoverboard(HV.SimObj).MaxThrustForce);
      }
//      LogInternal("BattleMOD:################ "@self$".ClientTimer() #6 "@HV.MaxSpeed);
//      HV.CustomTimeDilation = SV.default.CustomTimeDilation * CfgHoverVehicleSpeedMultiplier; // works for slower but not for faster
    }
  }

  ChangeWeaponSwitchSpeed (Owner);
}

function ServerTimer ()
{
  if (Pawn(Owner) != None) {
    if (Pawn(Owner).Health < CfgHealthMaxRegen) {
      Pawn(Owner).Health += Min (CfgHealthMaxRegen - Pawn(Owner).Health, CfgHealthRegenPerSecond);
    }
    if (UTWeapon(Pawn(Owner).Weapon) != None && !UTWeapon(Pawn(Owner).Weapon).bSuperWeapon) {
      UTWeapon(Pawn(Owner).Weapon).AddAmmo (CfgAmmoResupplyPerSecond); // Automatically reduced by UT3
    }
  }  
}

defaultproperties
{
  Name="BattleClient"
}