/* 
    BattleMOD Copyright (C) 2007 Nico de Vries.

    This file is part of BattleMOD.

    BattleMOD is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleDuelQueueScoreBoardPanel extends UTDuelQueueScoreboardPanel config(Game);

function string GetRightMisc(UTPlayerReplicationInfo PRI)
{
  local int TotalSeconds, Score, PPH;
  local string BaseString;

  if (PRI.WorldInfo.NetMode != NM_Standalone) {
    BaseString = Super.GetRightMisc(PRI);
    TotalSeconds = PRI.WorldInfo.GRI.ElapsedTime - PRI.StartTime;
    Score = int(GetPlayerScore(PRI));
    PPH = int(float(Score) / (float(TotalSeconds+1)/float(3600)));
    return BaseString$"   "$"PPH "$PPH;
  }
  return "";
}

defaultproperties
{
}